/***************************************************************************
                          RTSPServerLayer.cc
                         -------------------
    begin                : Sun Jun 09 2002
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*! \file RTSPServerLayer.cc
This header file declares the class RTSPServerLayer.
*/
					
#include "omnetpp.h"
#include "types.h"

#include "SocketInterfacePacket.h"

#include "ip_address.h"
#include "RTSPServerLayer.h"
#include "RTSPMessage_m.h"
#include "RTPInterfacePacket.h"


Define_Module(RTSPServerLayer);

//
// methods inherited from cSimpleModule
//

void RTSPServerLayer::initialize() {
	
	_portRTP = IN_Port((int)(par("portNumberRTP").longValue()));
	_debug = par("debug");
	_socketFd = Socket::FILEDESC_UNDEF;
	setPhase("INIT");

};



void RTSPServerLayer::handleMessage(cMessage *msg) {

	if (msg->arrivalGateId() == findGate("fromSocketLayer")) {
		handleMessageFromSocketLayer(msg);
	}

	else if (msg->arrivalGateId() == findGate("fromServerModule")) {
		handleMessageFromServerModule(msg);
	}

	else if (msg->arrivalGateId() == findGate("fromRTP")) {
		handleMessageFromRTP(msg);
	}
	
	else {
		opp_error("RTSPServerLayer: Message from unknown Gate!");
	}

};


void RTSPServerLayer::handleMessageFromServerModule(cMessage *msg) {

	request = (rtspRequest *)(msg);
	
	if (_socketFd == Socket::FILEDESC_UNDEF) {
		if (!opp_strcmp(par("rtspTransportProtocol"), "UDP")) {
			SocketInterfacePacket *sifpOut = new SocketInterfacePacket("socket()");
			sifpOut->socket(Socket::AF_INET, Socket::SOCK_DGRAM, Socket::UDP);
			send(sifpOut, "toSocketLayer");	
		}

		else if (!opp_strcmp(par("rtspTransportProtocol"), "TCP")) {	
			SocketInterfacePacket *sifpOut = new SocketInterfacePacket("socket()");
			sifpOut->socket(Socket::AF_INET, Socket::SOCK_DGRAM, Socket::TCP);
			send(sifpOut, "toSocketLayer");	
		}
	}
	
	else handleRequest();

};


	
void RTSPServerLayer::handleMessageFromSocketLayer(cMessage *msg) {
	
	SocketInterfacePacket *sifpIn = (SocketInterfacePacket *)msg;
	
	if (sifpIn->action() == SocketInterfacePacket::SA_SOCKET_RET) {
		_socketFd = sifpIn->filedesc();
		delete sifpIn;

		SocketInterfacePacket *sifpOut = new SocketInterfacePacket("connect()");
		sifpOut->connect(_socketFd, IN_Addr(par("remote_addr").stringValue()), IN_Port((int)(par("remote_port").longValue())));

		send(sifpOut, "toSocketLayer");
	}

	else if (sifpIn->action() == SocketInterfacePacket::SA_CONNECT_RET) {
		delete sifpIn;
		handleRequest();
	}

	else {
		ev << "RTSPServerLayer: Unknown SocketInterfacePacket type " << sifpIn->action() << " !" << endl;
	}
	
};



void RTSPServerLayer::handleRequest() {
	
	FSM_Switch(fsm) {

			case FSM_Exit(INIT):
				handleRequestStateInit();
			break;
		
			case FSM_Enter(READY):
			break;
			
			case FSM_Exit(READY):
				handleRequestStateReady();
			break;

			case FSM_Enter(PLAYING):
			break;
	 
			case FSM_Exit(PLAYING):
				handleRequestStatePlaying();
			break;
	}

};



void RTSPServerLayer::handleRequestStateInit() {
							
	response = new rtspResponse();
	response->setRtspVersion(1.0);
	response->setCseq(request->getCseq());
	response->setSessionId(request->getSessionId());
	response->setRtpInfo(" ");		
	
	if (request->getRtspVersion() != 1.0) {
		response->setStatusCode(505);
		response->setReasonPhrase("RTSP Version Not Supported");
	
		if (_debug) {
			writeResponseContents(response);
		}	
	
		SocketInterfacePacket *sifpOut = new SocketInterfacePacket("rtspResponse()");
    	sifpOut->write(_socketFd, response);
		send(sifpOut, "toSocketLayer");
			
	}
	else {
		_filename = opp_strdup(request->getFileName());
		sprintf(_url, "rtsp://%s/%s", request->getDestinationAddress(), request->getFileName());
		
		//parse transport parameter
		char *tempCh = strstr(request->getTransport(), "destination=")+12;
		ev << "destination address is " << tempCh << endl;
		char destinationAddress[strstr(tempCh, ";")-tempCh];
		strncpy(destinationAddress, tempCh, strstr(tempCh, ";")-tempCh);
	        destinationAddress[strstr(tempCh, ";")-tempCh]='\0';

		ev << "destination address is " << destinationAddress << endl;

		// create an RTPInterfacePacket to start the session
		RTPInterfacePacket *rifpOut1 = new RTPInterfacePacket("enterSession()");
		rifpOut1->enterSession(opp_strdup("RTSPServerLayer"), opp_strdup("RTPAVProfile"), 8000, IN_Addr(destinationAddress), _portRTP);
	
		// and send it to the rtp layer
		send(rifpOut1, "toRTP");
		
	}
					
	delete request;
	
};



void RTSPServerLayer::handleRequestStateReady() {

	SocketInterfacePacket *sifpOut = new SocketInterfacePacket("rtspResponse()");	
	
	if (_debug) {
		writeRequestContents(request);
	}	

	response = new rtspResponse();

	response->setRtspVersion(1.0);
	response->setSessionId(request->getSessionId());	
	response->setRtpInfo(" ");			

	if (request->getRtspVersion() != 1.0) {
		response->setStatusCode(505);
		response->setReasonPhrase("RTSP Version Not Supported");
		if (_debug) {
			writeResponseContents(response);
		}	
	    sifpOut->write(_socketFd, response);
		send(sifpOut, "toSocketLayer");
	}

	else {
		response->setCseq(request->getCseq());

		//cModule *mod;
		RTPInterfacePacket *rifpOut;		
		RTPSenderControlMessage *rscmOut;
		char *temp1, temp2[255];
		switch (request->getMethod()) {
					
			case SETUP:
				response->setStatusCode(455);
				response->setReasonPhrase("Method Not Valid In This	State");
		
				if (_debug) {
					writeResponseContents(response);
				}

		        sifpOut->write(_socketFd, response);
				send(sifpOut, "toSocketLayer");
			break;

			case PLAY:
				
				//handle range header
				temp1 = strstr(request->getRange(), "-");
				if (temp1== NULL) {
					_rangeFrom = -1;
					_rangeTo =-1;
				}
				else {
					_rangeFrom = atof(strncpy(temp2, request->getRange(),temp1 - request->getRange()));
					if ((strlen(request->getRange()) - (temp1 - request->getRange()) -1) == 0) _rangeTo = -1;
					else _rangeTo = atof(temp1+1);
				}
				
				
				//TODO!!! if (rangeFrom > 0) "PLAY after SEEK_TIME" else "PLAY only"
				
				if (true) {
					response->setRtpInfo(request->getDestinationAddress());
					rifpOut = new RTPInterfacePacket("senderModuleControl()");
					
						rscmOut = new RTPSenderControlMessage("setCommand()");
						rscmOut->setCommand("PLAY");
	
					rifpOut->senderModuleControl(_ssrc, rscmOut);
					send(rifpOut, "toRTP");
				}
				else {
					response->setRtpInfo(request->getDestinationAddress());
					rifpOut = new RTPInterfacePacket("senderModuleControl()");
					
						rscmOut = new RTPSenderControlMessage("setCommand()");
						///???rscmOut->setCommand("SEEK_TIME", _rangeFrom);
	
					rifpOut->senderModuleControl(_ssrc, rscmOut);
					send(rifpOut, "toRTP");
				}
				
				delete sifpOut;
			break;

			case PAUSE:
				response->setStatusCode(200);
				response->setReasonPhrase("OK");
				if (_debug) {
					writeResponseContents(response);
				}
		        sifpOut->write(_socketFd, response);
				send(sifpOut, "toSocketLayer");
			break;

			case TEARDOWN:
				response->setStatusCode(200);
				response->setReasonPhrase("OK");
				if (_debug) {
					writeResponseContents(response);
				}
		        rifpOut = new RTPInterfacePacket("leaveSession()");
				rifpOut->leaveSession();
				send(rifpOut, "toRTP");
				
				sifpOut->write(_socketFd, response);
				send(sifpOut, "toSocketLayer");
						
				sifpOut = new SocketInterfacePacket("closeSocket()");
				sifpOut->close(_socketFd);
				send(sifpOut, "toSocketLayer");
								
				sendDirect(new cMessage("closeSession()"), 0.2, parentModule()->parentModule(), "fromServerProcess");
			break;

			default:
				response->setStatusCode(405);
				response->setReasonPhrase("Method not Allowed");
				if (_debug) {
					writeResponseContents(response);
				}	
				sifpOut->write(_socketFd, response);
				send(sifpOut, "toSocketLayer");
			break;
		}
	}	
		
	delete request;

};



void RTSPServerLayer::handleRequestStatePlaying() {

	SocketInterfacePacket *sifpOut = new SocketInterfacePacket("rtspResponse()");	
	
	if (_debug) {
		writeRequestContents(request);
	}	
	response = new rtspResponse();

	response->setRtspVersion(1.0);
	response->setSessionId(request->getSessionId());				
	response->setRtpInfo(" ");

	if (request->getRtspVersion() != 1.0) {
		response->setStatusCode(505);
		response->setReasonPhrase("RTSP Version Not Supported");
		if (_debug) {
			writeResponseContents(response);
		}	
	    sifpOut->write(_socketFd, response);
		send(sifpOut, "toSocketLayer");
	}

	else {
		response->setCseq(request->getCseq());

		//cModule *mod;
		RTPInterfacePacket *rifpOut;		
		RTPSenderControlMessage *rscmOut;
	
		switch (request->getMethod()) {
					
			case SETUP:
				response->setStatusCode(455);
				response->setReasonPhrase("Method Not Valid In This	State");
				if (_debug) {
					writeResponseContents(response);
				}
		        sifpOut->write(_socketFd, response);
				send(sifpOut, "toSocketLayer");
			break;

			case PLAY:
				//Nothing to do
				response->setStatusCode(200);
				response->setReasonPhrase("OK");
				if (_debug) {
					writeResponseContents(response);
				}
					
		        sifpOut->write(_socketFd, response);
				send(sifpOut, "toSocketLayer");
			break;

			case PAUSE:
				rifpOut = new RTPInterfacePacket("senderModuleControl()");
					
					rscmOut = new RTPSenderControlMessage("setCommand()");
					rscmOut->setCommand("PAUSE");
	
				rifpOut->senderModuleControl(_ssrc, rscmOut);
				send(rifpOut, "toRTP");
				delete sifpOut;
			break;

			case TEARDOWN:
				response->setStatusCode(200);
				response->setReasonPhrase("OK");
				if (_debug) {
					writeResponseContents(response);
				}
		        
				rifpOut = new RTPInterfacePacket("deleteSenderModule()");
				rifpOut->deleteSenderModule(_ssrc);
				send(rifpOut, "toRTP");
				
				sifpOut->write(_socketFd, response);
				send(sifpOut, "toSocketLayer");
						
				sifpOut = new SocketInterfacePacket("closeSocket()");
				sifpOut->close(_socketFd);
				send(sifpOut, "toSocketLayer");
				
			break;

			default:
				response->setStatusCode(405);
				response->setReasonPhrase("Method not Allowed");
				if (_debug) {
					writeResponseContents(response);
				}	
				sifpOut->write(_socketFd, response);
				send(sifpOut, "toSocketLayer");
			break;
		}
	}	
		
	delete request;

};



void RTSPServerLayer::handleSelfMessage(cMessage *msg) {  
};


void RTSPServerLayer::handleMessageFromRTP(cMessage *msg) {  
	
	RTPInterfacePacket *rinpIn = (RTPInterfacePacket *)msg;
					
	
	if (rinpIn->type() == RTPInterfacePacket::RTP_IFP_SESSION_ENTERED) {

		_ssrc = rinpIn->ssrc();

		RTPInterfacePacket *rifpOut = new RTPInterfacePacket("createSenderModule()");
		rifpOut->createSenderModule(_ssrc, 32, _filename);
		send(rifpOut, "toRTP");

		delete rinpIn;
	}
	else if (rinpIn->type() == RTPInterfacePacket::RTP_IFP_SENDER_MODULE_CREATED) {
			
		response->setStatusCode(200);
		response->setReasonPhrase("OK");

		SocketInterfacePacket *sifpOut = new SocketInterfacePacket("rtspResponse()");
	    sifpOut->write(_socketFd, response);
		send(sifpOut, "toSocketLayer");
			
		if (_debug) {
			writeResponseContents(response);
		}	
		
		setPhase("READY");
		FSM_Goto(fsm, READY);
		
		delete rinpIn;
	}
	else if (rinpIn->type() == RTPInterfacePacket::RTP_IFP_SENDER_STATUS) {
		
		RTPSenderStatusMessage *rssm = (RTPSenderStatusMessage *)rinpIn->decapsulate(); 
		
		if (!opp_strcmp(rssm->status(), "PLAYING")) {
			
			response->setStatusCode(200);
			response->setReasonPhrase("OK");
			
			char msgrtpinfo[255];
			sprintf(msgrtpinfo,"url=%s;rtptime=%f",_url,rssm->timeStamp()+_rangeFrom*90000); //send dummy time
			response->setRtpInfo(msgrtpinfo);
			SocketInterfacePacket *sifpOut = new SocketInterfacePacket("rtspResponse()");
	        sifpOut->write(_socketFd, response);
			send(sifpOut, "toSocketLayer");
		
			if (_debug) {
				writeResponseContents(response);
			}	
							
			setPhase("PLAYING");
			FSM_Goto(fsm, PLAYING);
		
		}	
		else if (!opp_strcmp(rssm->status(), "PAUSED")) {
			
			response->setStatusCode(200);
			response->setReasonPhrase("OK");
				
			SocketInterfacePacket *sifpOut = new SocketInterfacePacket("rtspResponse()");
    	    sifpOut->write(_socketFd, response);
			send(sifpOut, "toSocketLayer");
		
			if (_debug) {
				writeResponseContents(response);
			}	
							
			setPhase("READY");
			FSM_Goto(fsm, READY);
		
		}	
		else if (!opp_strcmp(rssm->status(), "FINISHED")) {
			
			ev << "RTP_IFP_SENDER_STATUS: FINISHED" << endl;
		
		}	

		
		delete rssm;
		delete rinpIn;		
	}	
	else if (rinpIn->type() == RTPInterfacePacket::RTP_IFP_SENDER_MODULE_DELETED) {

			RTPInterfacePacket *rifpOut = new RTPInterfacePacket("leaveSession()");
			rifpOut->leaveSession();
			send(rifpOut, "toRTP");
				
			
				
			sendDirect(new cMessage("closeSession()"), 0.2, parentModule()->parentModule(), "fromServerProcess");
		
		delete rinpIn;
	}

	/*else if (rinpIn->type() == RTPInterfacePacket::RTP_IFP_SESSION_LEFT) {
		SocketInterfacePacket *sifpOut = new SocketInterfacePacket("closeSocket()");
		sifpOut->close(_socketFd);
		send(sifpOut, "toSocketLayer");
		
		cModule *mod = simulation.module(id());	
		mod->deleteModule();
	}	*/

};



void RTSPServerLayer::writeRequestContents(rtspRequest *request) {
	ev << "\nRTSPServerLayer ProcessId "<< id () << ": receiving request...\n"
	   << "-----------------------------------------------------------------------------\n"; 
		switch (request->getMethod()) {
		case SETUP: 
				ev << "SETUP"
				<< " rtsp://" 
			   	<< request->getDestinationAddress() 
				<< "/" 
				<< request->getFileName() 
				<< " RTSP/"
				<< request->getRtspVersion() 
				<< endl
				<< "CSeq: " 
				<< request->getCseq() 
				<< endl
				<< "Transport: " 
				<< request->getTransport() 
				<< endl;	
		break;
		
		case PLAY:
				ev << "PLAY"
				<< " rtsp://" 
			   	<< request->getDestinationAddress() 
				<< "/" 
				<< request->getFileName() 
				<< " RTSP/"
				<< request->getRtspVersion() 
				<< endl
				<< "CSeq: " 
				<< request->getCseq() 
				<< endl
				<< "Session: " 
				<< request->getSessionId() 
				<< endl	
				<< "Range: " 
				<< request->getRange() 
				<< endl;	

		break;
		
		case PAUSE: 
				ev << "PAUSE"
				<< " rtsp://" 
			   	<< request->getDestinationAddress() 
				<< "/" 
				<< request->getFileName() 
				<< " RTSP/"
				<< request->getRtspVersion() 
				<< endl
				<< "CSeq: " 
				<< request->getCseq() 
				<< endl
				<< "Session: " 
				<< request->getSessionId() 
				<< endl;	
		break;
		
		case TEARDOWN:
			ev << "TEARDOWN"
				<< " rtsp://" 
			   	<< request->getDestinationAddress() 
				<< "/" 
				<< request->getFileName() 
				<< " RTSP/"
				<< request->getRtspVersion() 
				<< endl
				<< "CSeq: " 
				<< request->getCseq() 
				<< endl
				<< "Session: " 
				<< request->getSessionId() 
				<< endl;	
		}			
	
	ev << "-----------------------------------------------------------------------------\n\n";		
};



void RTSPServerLayer::writeResponseContents(rtspResponse *response) {
	ev << "\nRTSPServerLayer ProcessId "<< id () << ": sending response...\n"
	  << "-----------------------------------------------------------------------------\n"
	   << "RTSP/" 
	   << response->getRtspVersion() 
	   << " " 
	   << response->getStatusCode() 
	   << " " 
	   << response->getReasonPhrase()
	   << endl
	   << "CSeq: " 
	   << response->getCseq() 
	   << endl
	   << "Session: " 
	   << response->getSessionId() 
   	   << endl;
	   if (opp_strcmp(response->getRtpInfo(), " ")) {
	ev << "RTP-Info: " 
	   << response->getRtpInfo()
	   << endl;
	}  
	ev << "-----------------------------------------------------------------------------\n\n"; 
};
