/***************************************************************************
                          RTSPClientModule.h
                         -------------------
    begin                : Fri May 17 2002
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*! \file RTSPClientModule.h
This file declares the class RTSPClientModule.
*/

#include "omnetpp.h"
#include "RTSPMessage_m.h"

/*! \class RTSPClientModule
The class RTSPClientModule is responsible for receiving and
processing messages from an application which uses RTSP. It 
forwards the messages to the right session (RTSPClientProcess). 
If the session does not exist, it creates a new session.
*/
class RTSPClientModule : public cSimpleModule {

	
	Module_Class_Members(RTSPClientModule, cSimpleModule, 0);
	
	/*!
	Initializes variables.
	*/
	virtual void initialize();
	
	/*!
	Handles incoming messages.
	*/
	virtual void handleMessage(cMessage *msg);
	

	protected:
		
		/*!
		Handles messages received from the application.
		*/
		virtual void handleMessageFromApp(cMessage *msg);
			
		/*!
		Handles messages received from client process.
		*/
		virtual void handleMessageFromClientProcess(cMessage *msg);
			
		/*!
		Creates a new session.
		*/
		virtual void createSession();		
		
	
	private:
		
		/*!
		A debug parameter.
		*/
		int _debug;
		
		/*
		The handled request.
		*/
		rtspRequest *request;
		
};
