/***************************************************************************
                          RTSPClientModule.cc 
                          -------------------
    begin                : Fri May 17 2002
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*! \file RTSPClientModule.cc
This file contains the implementation of member functions of the class
RTSPClientModule.              
*/
					
#include "omnetpp.h"
#include "RTSPMessage_m.h"
#include "RTSPClientModule.h"
#include <iostream>

using namespace std;

Define_Module(RTSPClientModule);


//
// methods inherited from cSimpleModule
//

void RTSPClientModule::initialize() {

	// initialize variables
	_debug = par("debug");
	
	if (opp_strcmp(par("rtspTransportProtocol"), "UDP") && (opp_strcmp(par("rtspTransportProtocol"), "TCP"))) {
		opp_error("Transport protocol %s not supported.", par("rtspTransportProtocol").stringValue());
	}	

};



void RTSPClientModule::handleMessage(cMessage *msg){

	if (msg->arrivalGateId() == findGate("fromApp")) {
		handleMessageFromApp(msg);
	} 

	else if (msg->arrivalGateId() == findGate("fromClientProcess")) {
		handleMessageFromClientProcess(msg);
		cout << "test2" << endl;
	} 

	else {
		opp_error("RTSPClientModule: Message from unknown Gate.");
	}

};	



void RTSPClientModule::handleMessageFromApp(cMessage *msg) {	
	
	request = (rtspRequest *)msg;
	request->setName("rtspRequest()");
	
	if (simulation.module(findSubmodule(opp_concat(request->getDestinationAddress(), request->getFileName()))) == NULL) { 
		// session with given sessionId does not exist -> create new session
		createSession();
	}

	else {
		// forward message to submodule
		cModule *mod = simulation.module(findSubmodule(opp_concat(request->getDestinationAddress(), request->getFileName())));
		sendDirect(request, 0.0, mod, "fromApp" );		
	}
	
};



void RTSPClientModule::handleMessageFromClientProcess(cMessage *msg) {	
		
	cModule *mod;
	if (!opp_strcmp(msg->name(), "closeSession()")) {
		// delete dynamically submodule		
		cout << "Received close session" << endl;
		ev << "Received close session" << endl;
		mod = simulation.module(msg->senderModuleId())->parentModule();
		cout << "Deleting module " << mod->name() << endl;
		mod->deleteModule();
		cout << "..finished " << endl;
		delete msg;
	}
	else {
		// forward message to application
		send(msg, "toApp");
	}

	cout << "test1" << endl;
};

	
	
void RTSPClientModule::createSession() {
				
	// find and create submodule
	cModuleType	*moduleType = findModuleType("RTSPClientProcess");
	cModule *mod = moduleType->create(opp_concat(request->getDestinationAddress(), request->getFileName()),this);
	// set parameters
	mod->par("timeout") = par("rtspUDPTimeout");
	mod->par("portNumberRTSP") = par("portNumberRTSP");
	mod->par("portNumberRTP") = par("portNumberRTP");
	mod->par("profileName") = par("profileName");
	mod->par("bandwidth") = par("bandwidth");
	mod->par("rtspTransportProtocol") = par("rtspTransportProtocol");
	mod->par("debug") = par("debug");
	moduleType->buildInside(mod);
	mod->callInitialize();
	mod->scheduleStart(simTime());
	
	// find SocketLayer Module
	cModule *socketMod = gate("toSocketLayer")->toGate()->ownerModule();

	// find free gate at SocketLayer
	int j = 0;
	while (socketMod->gate("from_appl",j)->isConnected()) {
		j++;
		if (socketMod->gate("from_appl")->size() == j) opp_error("SocketLayer gateSize() to small.");
	}
		
	// set links from and to SocketLayerRTSP
	mod->gate("toSocketLayerRTSP")->setTo(socketMod->gate("from_appl", j));
	mod->gate("fromSocketLayerRTSP")->setFrom(socketMod->gate("to_appl", j));
	socketMod->gate("from_appl", j) -> setFrom(mod->gate("toSocketLayerRTSP"));
	socketMod->gate("to_appl", j) -> setTo(mod->gate("fromSocketLayerRTSP"));
	
	
	// locate free SocketLayer link
	j = 0;
	while (socketMod->gate("from_appl",j)->isConnected()) {
		j++;
		if (socketMod->gate("from_appl")->size() == j) opp_error("RTSPClientLayer: SocketLayer gateSize() to small.");
	}
		
	// set links from and to SocketLayerRTP
	mod->gate("toSocketLayerRTP")->setTo(socketMod->gate("from_appl", j));
	mod->gate("fromSocketLayerRTP")->setFrom(socketMod->gate("to_appl", j));
	socketMod->gate("from_appl", j) -> setFrom(mod->gate("toSocketLayerRTP"));
	socketMod->gate("to_appl", j) -> setTo(mod->gate("fromSocketLayerRTP"));

	// locate free SocketLayer link
	j = 0;
	while (socketMod->gate("from_appl",j)->isConnected()) {
		j++;
		if (socketMod->gate("from_appl")->size() == j) opp_error("RTSPClientLayer: SocketLayer gateSize() to small.");
	}
	
	// set links from and to SocketLayerRTCP	
	mod->gate("toSocketLayerRTCP")->setTo(socketMod->gate("from_appl", j));
	mod->gate("fromSocketLayerRTCP")->setFrom(socketMod->gate("to_appl", j));
	socketMod->gate("from_appl", j)->setFrom(mod->gate("toSocketLayerRTCP"));
	socketMod->gate("to_appl", j)->setTo(mod->gate("fromSocketLayerRTCP"));
	
	// forward request
	sendDirect(request, 0.0, mod, "fromApp");

};
