/***************************************************************************
                          RTSPClientLayer.h  
                         -------------------
    begin                : Sun Jun 09 2002
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*! \file RTSPClientLayer.h
This header file declares the class RTSPClientLayer.
*/

#include "omnetpp.h"

#include "sockets.h"
#include "in_addr.h"
#include "in_port.h"

#include "RTSPMessage_m.h"

/*! \class RTSPClientLayer
An RTSPClientLayer module is the center of the rtsp client layer.
It sends and receives rtsp requests.
It also communicates with the rtp layer and the RTSPClientModule.
*/
class RTSPClientLayer : public cSimpleModule {

	
	/*!
	The states of the finite state machine.
	*/
	enum FSM_STATES {

	     INIT        = 0,
	     READY       = FSM_Steady(1),
	     PLAYING     = FSM_Steady(2),
	};
	
		
	Module_Class_Members(RTSPClientLayer, cSimpleModule, 0);
	
	/*!
	Initializes variables.
	*/
	virtual void initialize();
	
	/*!
	Handles incoming messages.
	*/
	virtual void handleMessage(cMessage *msg);
	
		
	protected:
									
		/*!
		Handles messages received from the application.
		*/
		virtual void handleMessageFromApp(cMessage *msg);
		
		/*!
		Handles messages received from rtp layer.
		*/
		virtual void handleMessageFromRTP(cMessage *msg);
		
		/*!
		Handles messages received from socket layer.
		*/
		virtual void handleMessageFromSocketLayer(cMessage *msg);
					
		/*!
		Handles RTSP-Messages.
		*/
		virtual void handleResponse(SocketInterfacePacket *sifp);
				
		/*!
		Handles messages state INIT.
		*/
		virtual void handleResponseStateInit(rtspResponse *response);

		/*!
		Handles messages state READY.
		*/
		virtual void handleResponseStateReady(rtspResponse *response);

		/*!
		Handles messages state PLAYING.
		*/
		virtual void handleResponseStatePlaying(rtspResponse *response);

		/*!
		Handles self messages.
		*/
		virtual void handleSelfMessage(cMessage *msg);
		
		/*!
		Close this session 
		*/
		virtual void closeSession();
	
	private:
		
		/*
		The finite state machine 
		*/
		cFSM fsm;
						
		/*!
		The Cseq number.
		*/
		int _cseq;
		
		/*!
		The rtp port.
		*/
		IN_Port _portRTP;
		
		/*!
		The session ID.
		*/
		opp_string _sessionId;
		
		/*!
		The actuel handled request.
		*/
		rtspRequest *request;
					
		/*!
		Stores a copy of the last request.
		*/
		rtspRequest *requestCopy;
		
		/*!
		Timeout message.
		*/
		cMessage *timeoutMsg;
						
		/*!
		The timeout for UDP.
		*/
		simtime_t _timeout;
		
		/*!
		The rtsp server socket file descriptor.
		*/
		Socket::Filedesc _socketFd;

		/*!
		A debug parameter.
		*/
		bool _debug;

		/*!
		Writes a request to omnet environment.
		*/
		virtual void writeRequestContents(rtspRequest *request);

		/*!
		Writes a response to omnet environment.
		*/
		virtual void writeResponseContents(rtspResponse *response);	
	
};
