/***************************************************************************
                          RTSPApplication.h
                         -------------------
    begin       	     : Fr May 31 2002
            				
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*! \mainpage The Real-time Streaming Protocol model
 *
 * \section intro Introduction
 *
 * \subsection rtsp The Real-time Streaming Protocol (RTSP)
 *
 *  "The Real Time Streaming Protocol, or RTSP, is an application-level
 *  protocol for control over the delivery of data with real-time
 *  properties. RTSP provides an extensible framework to enable
 *  controlled, on-demand delivery of real-time data, such as audio and
 *  video. Sources of data can include both live data feeds and stored
 *  clips. This protocol is intended to control multiple data delivery
 *  sessions, provide a means for choosing delivery channels such as UDP,
 *  multicast UDP and TCP, and provide a means for choosing delivery
 *  mechanisms based upon RTP (RFC 1889)." [RFC 2326]
 *
 * \subsection simu The model
 *
 * This model of the Real-time Streaming Protocol (RTSP) for OMNeT++ is based on ip-suite 
 * and the socket layer. To carry the continous media, it uses the RTP protocol. A few  
 * networks are included to demonstrate the functionality of the model. The networks use the
 * the class RTSPApplication, a sample application. It simulates a user interface by reading 
 * user commands from a specified file. The networks contain a file named 'rtsp.cmd' which shows 
 * and explains the syntax of the commands. 
 *
 *
 *
 * \section install Installation
 *
 * \subsection step1 Step 1: 
 * Edit omm.sh and change the path to your ip-suite installation.
 *
 * \subsection step2 Step 2: 
 * Run the script to create the Makefiles in all directories.
 *  
 * \subsection step3 Step 3: 
 * Run make to create a sample network. (subdirectory /rtsp/Networks/). 
 *
 *
 * 
 * \section nwt The networks
 *
 * \subsection  uni Unicast:
 * This is a quite simple example for rtp unicast transmission.Two hosts, one sender, one receiver.
 *
 * \subsection mult Mulicast: 
 * This is just a simple RTP multicast example with four hosts and one router
 * to connect them. Host1 acts as RTSPServer, Host2 controls the session and Host3+4 are receiver.
 */



/*! \file RTSPApplication.h
This file declares the class RTSPApplication.
*/
#include <omnetpp.h>

/*! \class RTSPApplication
The class RTSPApplication is a sample for an application which 
uses RTSP. It reads commands from a specified file (rtsp.cmd for 
example) and sends the commands to RTSPClientModule. Also it 
receives status messages from the same module.
*/

class RTSPApplication : public cSimpleModule {

	Module_Class_Members(RTSPApplication, cSimpleModule, 16384);
	
	/*!
	RTSPApplication uses activity for message handling.
	The behaviour is controlled by omnet parameters.
	*/
	virtual void activity();

	private:
		
		/*!
		Reads and schedules the commands from specified file 
		(by omnet parameters). 
		*/
		virtual void readCmdFile();

};
