/***************************************************************************
                             RTSPApplication.cc  
                             -------------------
    begin       	     : Fr May 31 2002
            				
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*! \file RTSPApplication.cc
This file contains the implementation for member functions
of RTSPApplication.
*/

#include "omnetpp.h"

#include <fstream>
#include <string>

#include "RTSPApplication.h"
#include "RTSPMessage_m.h"


Define_Module(RTSPApplication)

using namespace std;

void RTSPApplication::activity() {

	// read, parse and queue commands from cmdFile
	readCmdFile();
		
	// do an endless loop
	while (true) {
		cMessage *msgIn = receive();
		//handle queued commands
		if (msgIn->isSelfMessage()) {
			rtspRequest *request = (rtspRequest *)msgIn;
			send(msgIn, "toRTSP");
		}
		// receive messages from RTSP
		else {
			ev << "RTSPApplication: received msg <<" << msgIn->name() << ">>" << endl;
			delete msgIn;
		}	
	}

};

void RTSPApplication::readCmdFile() {
	
	char c;
	string conv;
	unsigned int t = 0,
				 line = 1;	
	double time;
	
	rtspRequest *req = new rtspRequest("cmd()");
	req->setRtspVersion(0.0);
	req->setSessionId(" ");
	req->setCseq(0);
	req->setTransport(" ");
	req->setRange(" ");
			
	ifstream cmdstream;
	
	cmdstream.open(par("cmdFileName").stringValue());
	
	if (!cmdstream) {
	     error ("RtspCmdFile %s not found", par("cmdFileName").stringValue());
	}

	
	while (cmdstream.get(c)) {
	
		if (c == '#') { 
			line++;
			while (cmdstream.get(c) && c != '\n') {}
		}	
		else if (c != '\n')
			do{ conv += c; } while (cmdstream.get(c) && c != ' ' && c != '\n');
			
		if  (conv.compare("")) {

			switch (t) {
				case 0:  time = atof(conv.c_str());
				break;
						
				case 1: if (!conv.compare("SETUP")) req->setMethod(SETUP);
				  	else if (!conv.compare("PLAY")) req->setMethod(PLAY);
				  	else if (!conv.compare("PAUSE")) req->setMethod(PAUSE);
				  	else if (!conv.compare("TEARDOWN")) req->setMethod(TEARDOWN);
					else error ("Unknown RTSPMethod in %s line %d",par("cmdFileName").stringValue(), line);
				break;	
			
				case 2:  req->setDestinationAddress(conv.c_str());
				break;
				
				case 3:	 req->setFileName(conv.c_str());
				break;
				
				case 4: if (req->getMethod() == SETUP) req->setTransport(conv.c_str());
						else if (req->getMethod() == PLAY) req->setRange(conv.c_str());
				break;		
				
				default: error ("Too many parameters in cmdFile %s line %d",par("cmdFileName").stringValue(), line);
	
			}		 
			
			conv =""; t++;
		
		}	
			
		if ((c == '\n') && (t != 0)) {
			t = 0; line++;
			scheduleAt(simTime()+time, req);

			req = new rtspRequest("cmd()");
			req->setRtspVersion(0.0);
			req->setSessionId(" ");
			req->setCseq(0);
			req->setTransport(" ");
			req->setRange(" ");
		
		}				
	}
	
	delete req;
	cmdstream.close();
	
};

