#!/bin/bash


###
#   set this to the absolute! path to your ip-suite installation
###
IP_SUITE_DIR="/home/kahmann/omnetsim/ip-suite"
RTP_DIR="/home/kahmann/omnetsim/rtp/rtp"

IP_SUITE_SUBDIRS="Interface Socket UDP TCP IPNode IPProcessing QoS MAC_LLC ControlApps"

BASE_DIR=$PWD
RTSP_DIR=$BASE_DIR/rtsp

PROFILES_DIR=$RTP_DIR/Profiles
PROFILES="AVProfile"

NETWORKS_DIR=$RTP_DIR/Networks
NETWORKS="Unicast Multicast1 Multicast2"

NETWORKS_DIR_RTSP=$RTSP_DIR/Networks
NETWORKSRTSP="Unicast Multicast"

MSGFILES="RTSPMessage.msg"

# these networks need special preparation: make -f Makefile.first
SPECIAL_NETWORK_DIRS="Multicast2"

LIBRARYNAMES="audiofile"

for specialdir in $SPECIAL_NETWORK_DIRS; do cd $NETWORKS_DIR/$specialdir; make -f Makefile.first; done

for includedir in $IP_SUITE_SUBDIRS; do IP_SUITE_INCLUDES=$IP_SUITE_INCLUDES\ -I$IP_SUITE_DIR/$includedir; done
for linkdir in $IP_SUITE_SUBDIRS; do IP_SUITE_OBJECTS=$IP_SUITE_OBJECTS\ $IP_SUITE_DIR/$linkdir; done
for includedir in $PROFILES; do PROFILE_INCLUDES=$PROFILE_INCLUDES\ -I$PROFILES_DIR/$includedir; done
for linkdir in $PROFILES; do PROFILE_OBJECTS=$PROFILE_OBJECTS\ $PROFILES_DIR/$linkdir; done

for library in $LIBRARYNAMES; do LIBRARIES=$LIBRARIES\ -l$library; done

cd $RTP_DIR
opp_makemake -n -f $IP_SUITE_INCLUDES $LIBRARIES

cd $RTSP_DIR
opp_makemake -n -f $IP_SUITE_INCLUDES -I$RTP_DIR 
for msgfile in $MSGFILES; do opp_msgc $msgfile; done

for profiledir in $PROFILES; do cd $PROFILES_DIR/$profiledir; opp_makemake -n -f $IP_SUITE_INCLUDES -I$RTP_DIR $LIBRARIES; done
echo "made profiles, now make rtp nw"
for networkdir in $NETWORKS; do cd $NETWORKS_DIR/$networkdir; opp_makemake -f $IP_SUITE_INCLUDES $PROFILE_INCLUDES -I$RTP_DIR $LIBRARIES $IP_SUITE_OBJECTS $RTSP_DIR $RTP_DIR $PROFILE_OBJECTS; done
echo "made rtp networks, now make rtsp nw"
for networkdir in $NETWORKSRTSP; do cd $NETWORKS_DIR_RTSP/$networkdir; opp_makemake -f $IP_SUITE_INCLUDES $PROFILE_INCLUDES -I$RTP_DIR -I$RTSP_DIR $LIBRARIES $IP_SUITE_OBJECTS $RTSP_DIR $RTP_DIR $PROFILE_OBJECTS; done
echo "made rtsp nw"
