#!/bin/bash


###
#   set this to the absolute! path to your ip-suite installation
###
IP_SUITE_DIR="/home/kahmann/omnetsim/ip-suite"

IP_SUITE_SUBDIRS="Interface Socket UDP IPNode IPProcessing QoS MAC_LLC ControlApps"

BASE_DIR=$PWD
RTP_DIR=$BASE_DIR/rtp

PROFILES_DIR=$RTP_DIR/Profiles
PROFILES="AVProfile"

NETWORKS_DIR=$RTP_DIR/Networks
NETWORKS="Unicast Multicast1 Multicast2"

# these networks need special preparation: make -f Makefile.first
SPECIAL_NETWORK_DIRS="Multicast2"

LIBRARYNAMES="audiofile"

for specialdir in $SPECIAL_NETWORK_DIRS; do cd $NETWORKS_DIR/$specialdir; make -f Makefile.first; done

for includedir in $IP_SUITE_SUBDIRS; do IP_SUITE_INCLUDES=$IP_SUITE_INCLUDES\ -I$IP_SUITE_DIR/$includedir; done
for linkdir in $IP_SUITE_SUBDIRS; do IP_SUITE_OBJECTS=$IP_SUITE_OBJECTS\ $IP_SUITE_DIR/$linkdir; done
for includedir in $PROFILES; do PROFILE_INCLUDES=$PROFILE_INCLUDES\ -I$PROFILES_DIR/$includedir; done
for linkdir in $PROFILES; do PROFILE_OBJECTS=$PROFILE_OBJECTS\ $PROFILES_DIR/$linkdir; done

for library in $LIBRARYNAMES; do LIBRARIES=$LIBRARIES\ -l$library; done

cd $RTP_DIR
opp_makemake -n -f $IP_SUITE_INCLUDES $LIBRARIES

for profiledir in $PROFILES; do cd $PROFILES_DIR/$profiledir; opp_makemake -n -f $IP_SUITE_INCLUDES -I$RTP_DIR $LIBRARIES; done
for networkdir in $NETWORKS; do cd $NETWORKS_DIR/$networkdir; opp_makemake -f $IP_SUITE_INCLUDES $PROFILE_INCLUDES -I$RTP_DIR $LIBRARIES $IP_SUITE_OBJECTS $RTP_DIR $PROFILE_OBJECTS; done

