#if !defined(__MSP430_HEADERS_DMAX_H__)
#define __MSP430_HEADERS_DMAX_H__

/* dmax.h
 *
 * mspgcc project: MSP430 device headers
 * Real-Time Clock
 *
 * Based on cc430x613x.h version 1.5 by Texas Instruments
 *
 * NOTE: This header file is intended for 16- and 20-bit MSP430X
 * processors.  For systems that support only 8-bit memory access, use
 * <msp430/dma.h>.
 *
 * Peter A. Bigot <pab@peoplepowerco.com>
 *
 */

/* Switches:
__MSP430_HAS_DMA_3__  - if module has 16-bit address registers
__MSP430_HAS_DMAX_3__ - if module has 20-bit address registers (430X core)
__MSP430_DMA_BASE__   - base address of DMA module
*/

#if defined(__MSP430_DMA_BASE__)

#define DMACTL0_ __MSP430_DMA_BASE__ + 0x00  /* DMA Module Control 0 */
sfrw(DMACTL0, DMACTL0_);
#define DMACTL0_L_ __MSP430_DMA_BASE__ + 0x00  
sfrb(DMACTL0_L, DMACTL0_L_);
#define DMACTL0_H_ __MSP430_DMA_BASE__ + 0x01  
sfrb(DMACTL0_H, DMACTL0_H_);
#define DMACTL1_ __MSP430_DMA_BASE__ + 0x02  /* DMA Module Control 1 */
sfrw(DMACTL1, DMACTL1_);
#define DMACTL1_L_ __MSP430_DMA_BASE__ + 0x02  
sfrb(DMACTL1_L, DMACTL1_L_);
#define DMACTL1_H_ __MSP430_DMA_BASE__ + 0x03  
sfrb(DMACTL1_H, DMACTL1_H_);
#define DMACTL2_ __MSP430_DMA_BASE__ + 0x04  /* DMA Module Control 2 */
sfrw(DMACTL2, DMACTL2_);
#define DMACTL2_L_ __MSP430_DMA_BASE__ + 0x04  
sfrb(DMACTL2_L, DMACTL2_L_);
#define DMACTL2_H_ __MSP430_DMA_BASE__ + 0x05  
sfrb(DMACTL2_H, DMACTL2_H_);
#define DMACTL3_ __MSP430_DMA_BASE__ + 0x06  /* DMA Module Control 3 */
sfrw(DMACTL3, DMACTL3_);
#define DMACTL3_L_ __MSP430_DMA_BASE__ + 0x06  
sfrb(DMACTL3_L, DMACTL3_L_);
#define DMACTL3_H_ __MSP430_DMA_BASE__ + 0x07  
sfrb(DMACTL3_H, DMACTL3_H_);
#define DMACTL4_ __MSP430_DMA_BASE__ + 0x08  /* DMA Module Control 4 */
sfrw(DMACTL4, DMACTL4_);
#define DMACTL4_L_ __MSP430_DMA_BASE__ + 0x08  
sfrb(DMACTL4_L, DMACTL4_L_);
#define DMACTL4_H_ __MSP430_DMA_BASE__ + 0x09  
sfrb(DMACTL4_H, DMACTL4_H_);
#define DMAIV_ __MSP430_DMA_BASE__ + 0x0e  /* DMA Interrupt Vector Word */
sfrw(DMAIV, DMAIV_);
#define DMAIV_L_ __MSP430_DMA_BASE__ + 0x0e  
sfrb(DMAIV_L, DMAIV_L_);
#define DMAIV_H_ __MSP430_DMA_BASE__ + 0x0f  
sfrb(DMAIV_H, DMAIV_H_);

#define DMA0CTL_ __MSP430_DMA_BASE__ + 0x00  /* DMA Channel 0 Control */
sfrw(DMA0CTL, DMA0CTL_);
#define DMA0CTL_L_ __MSP430_DMA_BASE__ + 0x00  
sfrb(DMA0CTL_L, DMA0CTL_L_);
#define DMA0CTL_H_ __MSP430_DMA_BASE__ + 0x01  
sfrb(DMA0CTL_H, DMA0CTL_H_);

#define DMA0SA_ __MSP430_DMA_BASE__ + 0x02  /* DMA Channel 0 Source Address */
#if defined(__MSP430_HAS_DMAX_3__)
sfra(DMA0SA, DMA0SA_);
#define DMA0SAL_ __MSP430_DMA_BASE__ + 0x02  /* DMA Channel 0 Source Address */
sfrw(DMA0SAL, DMA0SAL_);
#else // __MSP430_HAS_DMAX_3__
sfrw(DMA0SA, DMA0SA_);
#endif // __MSP430_HAS_DMAX_3__

#define DMA0DA_ __MSP430_DMA_BASE__ + 0x06  /* DMA Channel 0 Destination Address */
#if defined(__MSP430_HAS_DMAX_3__)
sfra(DMA0DA, DMA0DA_);
#define DMA0DAL_ __MSP430_DMA_BASE__ + 0x06  /* DMA Channel 0 Destination Address */
sfrw(DMA0DAL, DMA0DAL_);
#else // __MSP430_HAS_DMAX_3__
sfrw(DMA0DA, DMA0DA_);
#endif // __MSP430_HAS_DMAX_3__

#define DMA0SZ_ __MSP430_DMA_BASE__ + 0x0a  /* DMA Channel 0 Transfer Size */
sfrw(DMA0SZ, DMA0SZ_);
#define DMA0SZ_L_ __MSP430_DMA_BASE__ + 0x0a  
sfrb(DMA0SZ_L, DMA0SZ_L_);
#define DMA0SZ_H_ __MSP430_DMA_BASE__ + 0x0b  
sfrb(DMA0SZ_H, DMA0SZ_H_);

#define DMA1CTL_ __MSP430_DMA_BASE__ + 0x10  /* DMA Channel 1 Control */
sfrw(DMA1CTL, DMA1CTL_);
#define DMA1CTL_L_ __MSP430_DMA_BASE__ + 0x10  
sfrb(DMA1CTL_L, DMA1CTL_L_);
#define DMA1CTL_H_ __MSP430_DMA_BASE__ + 0x11  
sfrb(DMA1CTL_H, DMA1CTL_H_);
#if defined(__MSP430_HAS_DMAX_3__)
#define DMA1SA_ __MSP430_DMA_BASE__ + 0x12  /* DMA Channel 1 Source Address */
sfra(DMA1SA, DMA1SA_);
#endif // __MSP430_HAS_DMAX_3__
#define DMA1SAL_ __MSP430_DMA_BASE__ + 0x12  /* DMA Channel 1 Source Address */
sfrw(DMA1SAL, DMA1SAL_);

#define DMA1DA_ __MSP430_DMA_BASE__ + 0x16  /* DMA Channel 1 Destination Address */
#if defined(__MSP430_HAS_DMAX_3__)
sfra(DMA1DA, DMA1DA_);
#define DMA1DAL_ __MSP430_DMA_BASE__ + 0x16  /* DMA Channel 1 Destination Address */
sfrw(DMA1DAL, DMA1DAL_);
#else // __MSP430_HAS_DMAX_3__
sfrw(DMA1DA, DMA1DA_);
#endif // __MSP430_HAS_DMAX_3__

#define DMA1SZ_ __MSP430_DMA_BASE__ + 0x1a  /* DMA Channel 1 Transfer Size */
sfrw(DMA1SZ, DMA1SZ_);
#define DMA1SZ_L_ __MSP430_DMA_BASE__ + 0x1a  
sfrb(DMA1SZ_L, DMA1SZ_L_);
#define DMA1SZ_H_ __MSP430_DMA_BASE__ + 0x1b  
sfrb(DMA1SZ_H, DMA1SZ_H_);

#define DMA2CTL_ __MSP430_DMA_BASE__ + 0x20  /* DMA Channel 2 Control */
sfrw(DMA2CTL, DMA2CTL_);
#define DMA2CTL_L_ __MSP430_DMA_BASE__ + 0x20  
sfrb(DMA2CTL_L, DMA2CTL_L_);
#define DMA2CTL_H_ __MSP430_DMA_BASE__ + 0x21  
sfrb(DMA2CTL_H, DMA2CTL_H_);

#define DMA2SA_ __MSP430_DMA_BASE__ + 0x22  /* DMA Channel 2 Source Address */
#if defined(__MSP430_HAS_DMAX_3__)
sfra(DMA2SA, DMA2SA_);
#define DMA2SAL_ __MSP430_DMA_BASE__ + 0x22  /* DMA Channel 2 Source Address */
sfrw(DMA2SAL, DMA2SAL_);
#else // __MSP430_HAS_DMAX_3__
sfrw(DMA2SA, DMA2SA_);
#endif // __MSP430_HAS_DMAX_3__

#define DMA2DA_ __MSP430_DMA_BASE__ + 0x26  /* DMA Channel 2 Destination Address */
#if defined(__MSP430_HAS_DMAX_3__)
sfra(DMA2DA, DMA2DA_);
#define DMA2DAL_ __MSP430_DMA_BASE__ + 0x26  /* DMA Channel 2 Destination Address */
sfrw(DMA2DAL, DMA2DAL_);
#else // __MSP430_HAS_DMAX_3__
sfrw(DMA2DA, DMA2DA_);
#endif // __MSP430_HAS_DMAX_3__

#define DMA2SZ_ __MSP430_DMA_BASE__ + 0x2a  /* DMA Channel 2 Transfer Size */
sfrw(DMA2SZ, DMA2SZ_);
#define DMA2SZ_L_ __MSP430_DMA_BASE__ + 0x2a  
sfrb(DMA2SZ_L, DMA2SZ_L_);
#define DMA2SZ_H_ __MSP430_DMA_BASE__ + 0x2b  
sfrb(DMA2SZ_H, DMA2SZ_H_);

/* DMACTL0 Control Bits */
#define DMA0TSEL0              (0x0001)       /* DMA channel 0 transfer select bit 0 */
#define DMA0TSEL1              (0x0002)       /* DMA channel 0 transfer select bit 1 */
#define DMA0TSEL2              (0x0004)       /* DMA channel 0 transfer select bit 2 */
#define DMA0TSEL3              (0x0008)       /* DMA channel 0 transfer select bit 3 */
#define DMA0TSEL4              (0x0010)       /* DMA channel 0 transfer select bit 4 */
#define DMA1TSEL0              (0x0100)       /* DMA channel 1 transfer select bit 0 */
#define DMA1TSEL1              (0x0200)       /* DMA channel 1 transfer select bit 1 */
#define DMA1TSEL2              (0x0400)       /* DMA channel 1 transfer select bit 2 */
#define DMA1TSEL3              (0x0800)       /* DMA channel 1 transfer select bit 3 */
#define DMA1TSEL4              (0x1000)       /* DMA channel 1 transfer select bit 4 */

/* DMACTL0 Control Bits */
#define DMA0TSEL0_L            (0x0001)       /* DMA channel 0 transfer select bit 0 */
#define DMA0TSEL1_L            (0x0002)       /* DMA channel 0 transfer select bit 1 */
#define DMA0TSEL2_L            (0x0004)       /* DMA channel 0 transfer select bit 2 */
#define DMA0TSEL3_L            (0x0008)       /* DMA channel 0 transfer select bit 3 */
#define DMA0TSEL4_L            (0x0010)       /* DMA channel 0 transfer select bit 4 */

/* DMACTL0 Control Bits */
#define DMA1TSEL0_H            (0x0001)       /* DMA channel 1 transfer select bit 0 */
#define DMA1TSEL1_H            (0x0002)       /* DMA channel 1 transfer select bit 1 */
#define DMA1TSEL2_H            (0x0004)       /* DMA channel 1 transfer select bit 2 */
#define DMA1TSEL3_H            (0x0008)       /* DMA channel 1 transfer select bit 3 */
#define DMA1TSEL4_H            (0x0010)       /* DMA channel 1 transfer select bit 4 */

/* DMACTL01 Control Bits */
#define DMA2TSEL0              (0x0001)       /* DMA channel 2 transfer select bit 0 */
#define DMA2TSEL1              (0x0002)       /* DMA channel 2 transfer select bit 1 */
#define DMA2TSEL2              (0x0004)       /* DMA channel 2 transfer select bit 2 */
#define DMA2TSEL3              (0x0008)       /* DMA channel 2 transfer select bit 3 */
#define DMA2TSEL4              (0x0010)       /* DMA channel 2 transfer select bit 4 */

/* DMACTL01 Control Bits */
#define DMA2TSEL0_L            (0x0001)       /* DMA channel 2 transfer select bit 0 */
#define DMA2TSEL1_L            (0x0002)       /* DMA channel 2 transfer select bit 1 */
#define DMA2TSEL2_L            (0x0004)       /* DMA channel 2 transfer select bit 2 */
#define DMA2TSEL3_L            (0x0008)       /* DMA channel 2 transfer select bit 3 */
#define DMA2TSEL4_L            (0x0010)       /* DMA channel 2 transfer select bit 4 */

/* DMACTL01 Control Bits */

/* DMACTL4 Control Bits */
#define ENNMI                  (0x0001)       /* Enable NMI interruption of DMA */
#define ROUNDROBIN             (0x0002)       /* Round-Robin DMA channel priorities */
#define DMARMWDIS              (0x0004)       /* Inhibited DMA transfers during read-modify-write CPU operations */

/* DMACTL4 Control Bits */
#define ENNMI_L                (0x0001)       /* Enable NMI interruption of DMA */
#define ROUNDROBIN_L           (0x0002)       /* Round-Robin DMA channel priorities */
#define DMARMWDIS_L            (0x0004)       /* Inhibited DMA transfers during read-modify-write CPU operations */

/* DMACTL4 Control Bits */

/* DMAxCTL Control Bits */
#define DMAREQ                 (0x0001)       /* Initiate DMA transfer with DMATSEL */
#define DMAABORT               (0x0002)       /* DMA transfer aborted by NMI */
#define DMAIE                  (0x0004)       /* DMA interrupt enable */
#define DMAIFG                 (0x0008)       /* DMA interrupt flag */
#define DMAEN                  (0x0010)       /* DMA enable */
#define DMALEVEL               (0x0020)       /* DMA level sensitive trigger select */
#define DMASRCBYTE             (0x0040)       /* DMA source byte */
#define DMADSTBYTE             (0x0080)       /* DMA destination byte */
#define DMASRCINCR0            (0x0100)       /* DMA source increment bit 0 */
#define DMASRCINCR1            (0x0200)       /* DMA source increment bit 1 */
#define DMADSTINCR0            (0x0400)       /* DMA destination increment bit 0 */
#define DMADSTINCR1            (0x0800)       /* DMA destination increment bit 1 */
#define DMADT0                 (0x1000)       /* DMA transfer mode bit 0 */
#define DMADT1                 (0x2000)       /* DMA transfer mode bit 1 */
#define DMADT2                 (0x4000)       /* DMA transfer mode bit 2 */

/* DMAxCTL Control Bits */
#define DMAREQ_L               (0x0001)       /* Initiate DMA transfer with DMATSEL */
#define DMAABORT_L             (0x0002)       /* DMA transfer aborted by NMI */
#define DMAIE_L                (0x0004)       /* DMA interrupt enable */
#define DMAIFG_L               (0x0008)       /* DMA interrupt flag */
#define DMAEN_L                (0x0010)       /* DMA enable */
#define DMALEVEL_L             (0x0020)       /* DMA level sensitive trigger select */
#define DMASRCBYTE_L           (0x0040)       /* DMA source byte */
#define DMADSTBYTE_L           (0x0080)       /* DMA destination byte */

/* DMAxCTL Control Bits */
#define DMASRCINCR0_H          (0x0001)       /* DMA source increment bit 0 */
#define DMASRCINCR1_H          (0x0002)       /* DMA source increment bit 1 */
#define DMADSTINCR0_H          (0x0004)       /* DMA destination increment bit 0 */
#define DMADSTINCR1_H          (0x0008)       /* DMA destination increment bit 1 */
#define DMADT0_H               (0x0010)       /* DMA transfer mode bit 0 */
#define DMADT1_H               (0x0020)       /* DMA transfer mode bit 1 */
#define DMADT2_H               (0x0040)       /* DMA transfer mode bit 2 */

#define DMASWDW                (0*0x0040u)    /* DMA transfer: source word to destination word */
#define DMASBDW                (1*0x0040u)    /* DMA transfer: source byte to destination word */
#define DMASWDB                (2*0x0040u)    /* DMA transfer: source word to destination byte */
#define DMASBDB                (3*0x0040u)    /* DMA transfer: source byte to destination byte */

#define DMASRCINCR_0           (0*0x0100u)    /* DMA source increment 0: source address unchanged */
#define DMASRCINCR_1           (1*0x0100u)    /* DMA source increment 1: source address unchanged */
#define DMASRCINCR_2           (2*0x0100u)    /* DMA source increment 2: source address decremented */
#define DMASRCINCR_3           (3*0x0100u)    /* DMA source increment 3: source address incremented */

#define DMADSTINCR_0           (0*0x0400u)    /* DMA destination increment 0: destination address unchanged */
#define DMADSTINCR_1           (1*0x0400u)    /* DMA destination increment 1: destination address unchanged */
#define DMADSTINCR_2           (2*0x0400u)    /* DMA destination increment 2: destination address decremented */
#define DMADSTINCR_3           (3*0x0400u)    /* DMA destination increment 3: destination address incremented */

#define DMADT_0                (0*0x1000u)    /* DMA transfer mode 0: Single transfer */
#define DMADT_1                (1*0x1000u)    /* DMA transfer mode 1: Block transfer */
#define DMADT_2                (2*0x1000u)    /* DMA transfer mode 2: Burst-Block transfer */
#define DMADT_3                (3*0x1000u)    /* DMA transfer mode 3: Burst-Block transfer */
#define DMADT_4                (4*0x1000u)    /* DMA transfer mode 4: Repeated Single transfer */
#define DMADT_5                (5*0x1000u)    /* DMA transfer mode 5: Repeated Block transfer */
#define DMADT_6                (6*0x1000u)    /* DMA transfer mode 6: Repeated Burst-Block transfer */
#define DMADT_7                (7*0x1000u)    /* DMA transfer mode 7: Repeated Burst-Block transfer */

/* DMAIV Definitions */
#define DMAIV_NONE             (0x0000)       /* No Interrupt pending */
#define DMAIV_DMA0IFG          (0x0002)       /* DMA0IFG*/
#define DMAIV_DMA1IFG          (0x0004)       /* DMA1IFG*/
#define DMAIV_DMA2IFG          (0x0006)       /* DMA2IFG*/

#define DMA0TSEL_0             (0*0x0001u)    /* DMA channel 0 transfer select 0:  DMA_REQ (sw) */
#define DMA0TSEL_1             (1*0x0001u)    /* DMA channel 0 transfer select 1:  Timer0_A (TA0CCR0.IFG) */
#define DMA0TSEL_2             (2*0x0001u)    /* DMA channel 0 transfer select 2:  Timer0_A (TA0CCR2.IFG) */
#define DMA0TSEL_3             (3*0x0001u)    /* DMA channel 0 transfer select 3:  Timer1_A (TA1CCR0.IFG) */
#define DMA0TSEL_4             (4*0x0001u)    /* DMA channel 0 transfer select 4:  Timer1_A (TA1CCR2.IFG) */
#define DMA0TSEL_5             (5*0x0001u)    /* DMA channel 0 transfer select 5:  TimerB (TB0CCR0.IFG) */
#define DMA0TSEL_6             (6*0x0001u)    /* DMA channel 0 transfer select 6:  TimerB (TB0CCR2.IFG) */
#define DMA0TSEL_7             (7*0x0001u)    /* DMA channel 0 transfer select 7:  Reserved */
#define DMA0TSEL_8             (8*0x0001u)    /* DMA channel 0 transfer select 8:  Reserved */
#define DMA0TSEL_9             (9*0x0001u)    /* DMA channel 0 transfer select 9:  Reserved */
#define DMA0TSEL_10            (10*0x0001u)   /* DMA channel 0 transfer select 10: Reserved */
#define DMA0TSEL_11            (11*0x0001u)   /* DMA channel 0 transfer select 11: Reserved */
#define DMA0TSEL_12            (12*0x0001u)   /* DMA channel 0 transfer select 12: Reserved */
#define DMA0TSEL_13            (13*0x0001u)   /* DMA channel 0 transfer select 13: Reserved */
#define DMA0TSEL_14            (14*0x0001u)   /* DMA channel 0 transfer select 14: RFRXIFG */
#define DMA0TSEL_15            (15*0x0001u)   /* DMA channel 0 transfer select 15: RFTXIFG */
#define DMA0TSEL_16            (16*0x0001u)   /* DMA channel 0 transfer select 16: USCIA0 receive */
#define DMA0TSEL_17            (17*0x0001u)   /* DMA channel 0 transfer select 17: USCIA0 transmit */
#define DMA0TSEL_18            (18*0x0001u)   /* DMA channel 0 transfer select 18: USCIB0 receive */
#define DMA0TSEL_19            (19*0x0001u)   /* DMA channel 0 transfer select 19: USCIB0 transmit */
#define DMA0TSEL_20            (20*0x0001u)   /* DMA channel 0 transfer select 20: Reserved  */
#define DMA0TSEL_21            (21*0x0001u)   /* DMA channel 0 transfer select 21: Reserved  */
#define DMA0TSEL_22            (22*0x0001u)   /* DMA channel 0 transfer select 22: Reserved  */
#define DMA0TSEL_23            (23*0x0001u)   /* DMA channel 0 transfer select 23: Reserved  */
#define DMA0TSEL_24            (24*0x0001u)   /* DMA channel 0 transfer select 24: ADC12IFGx */
#define DMA0TSEL_25            (25*0x0001u)   /* DMA channel 0 transfer select 25: Reserved */
#define DMA0TSEL_26            (26*0x0001u)   /* DMA channel 0 transfer select 26: Reserved */
#define DMA0TSEL_27            (27*0x0001u)   /* DMA channel 0 transfer select 27: Reserved */
#define DMA0TSEL_28            (28*0x0001u)   /* DMA channel 0 transfer select 28: Reserved */
#define DMA0TSEL_29            (29*0x0001u)   /* DMA channel 0 transfer select 29: Multiplier ready */
#define DMA0TSEL_30            (30*0x0001u)   /* DMA channel 0 transfer select 30: previous DMA channel DMA2IFG */
#define DMA0TSEL_31            (31*0x0001u)   /* DMA channel 0 transfer select 31: ext. Trigger (DMAE0) */

#define DMA1TSEL_0             (0*0x0100u)    /* DMA channel 1 transfer select 0:  DMA_REQ (sw) */
#define DMA1TSEL_1             (1*0x0100u)    /* DMA channel 1 transfer select 1:  Timer0_A (TA0CCR0.IFG) */
#define DMA1TSEL_2             (2*0x0100u)    /* DMA channel 1 transfer select 2:  Timer0_A (TA0CCR2.IFG) */
#define DMA1TSEL_3             (3*0x0100u)    /* DMA channel 1 transfer select 3:  Timer1_A (TA1CCR0.IFG) */
#define DMA1TSEL_4             (4*0x0100u)    /* DMA channel 1 transfer select 4:  Timer1_A (TA1CCR2.IFG) */
#define DMA1TSEL_5             (5*0x0100u)    /* DMA channel 1 transfer select 5:  TimerB (TB0CCR0.IFG) */
#define DMA1TSEL_6             (6*0x0100u)    /* DMA channel 1 transfer select 6:  TimerB (TB0CCR2.IFG) */
#define DMA1TSEL_7             (7*0x0100u)    /* DMA channel 1 transfer select 7:  Reserved */
#define DMA1TSEL_8             (8*0x0100u)    /* DMA channel 1 transfer select 8:  Reserved */
#define DMA1TSEL_9             (9*0x0100u)    /* DMA channel 1 transfer select 9:  Reserved */
#define DMA1TSEL_10            (10*0x0100u)   /* DMA channel 1 transfer select 10: Reserved */
#define DMA1TSEL_11            (11*0x0100u)   /* DMA channel 1 transfer select 11: Reserved */
#define DMA1TSEL_12            (12*0x0100u)   /* DMA channel 1 transfer select 12: Reserved */
#define DMA1TSEL_13            (13*0x0100u)   /* DMA channel 1 transfer select 13: Reserved */
#define DMA1TSEL_14            (14*0x0100u)   /* DMA channel 1 transfer select 14: RFRXIFG */
#define DMA1TSEL_15            (15*0x0100u)   /* DMA channel 1 transfer select 15: RFTXIFG */
#define DMA1TSEL_16            (16*0x0100u)   /* DMA channel 1 transfer select 16: USCIA0 receive */
#define DMA1TSEL_17            (17*0x0100u)   /* DMA channel 1 transfer select 17: USCIA0 transmit */
#define DMA1TSEL_18            (18*0x0100u)   /* DMA channel 1 transfer select 18: USCIB0 receive */
#define DMA1TSEL_19            (19*0x0100u)   /* DMA channel 1 transfer select 19: USCIB0 transmit */
#define DMA1TSEL_20            (20*0x0100u)   /* DMA channel 1 transfer select 20: Reserved  */
#define DMA1TSEL_21            (21*0x0100u)   /* DMA channel 1 transfer select 21: Reserved  */
#define DMA1TSEL_22            (22*0x0100u)   /* DMA channel 1 transfer select 22: Reserved  */
#define DMA1TSEL_23            (23*0x0100u)   /* DMA channel 1 transfer select 23: Reserved  */
#define DMA1TSEL_24            (24*0x0100u)   /* DMA channel 1 transfer select 24: ADC12IFGx */
#define DMA1TSEL_25            (25*0x0100u)   /* DMA channel 1 transfer select 25: Reserved */
#define DMA1TSEL_26            (26*0x0100u)   /* DMA channel 1 transfer select 26: Reserved */
#define DMA1TSEL_27            (27*0x0100u)   /* DMA channel 1 transfer select 27: Reserved */
#define DMA1TSEL_28            (28*0x0100u)   /* DMA channel 1 transfer select 28: Reserved */
#define DMA1TSEL_29            (29*0x0100u)   /* DMA channel 1 transfer select 29: Multiplier ready */
#define DMA1TSEL_30            (30*0x0100u)   /* DMA channel 1 transfer select 30: previous DMA channel DMA0IFG */
#define DMA1TSEL_31            (31*0x0100u)   /* DMA channel 1 transfer select 31: ext. Trigger (DMAE0) */

#define DMA2TSEL_0             (0*0x0001u)    /* DMA channel 2 transfer select 0:  DMA_REQ (sw) */
#define DMA2TSEL_1             (1*0x0001u)    /* DMA channel 2 transfer select 1:  Timer0_A (TA0CCR0.IFG) */
#define DMA2TSEL_2             (2*0x0001u)    /* DMA channel 2 transfer select 2:  Timer0_A (TA0CCR2.IFG) */
#define DMA2TSEL_3             (3*0x0001u)    /* DMA channel 2 transfer select 3:  Timer1_A (TA1CCR0.IFG) */
#define DMA2TSEL_4             (4*0x0001u)    /* DMA channel 2 transfer select 4:  Timer1_A (TA1CCR2.IFG) */
#define DMA2TSEL_5             (5*0x0001u)    /* DMA channel 2 transfer select 5:  TimerB (TB0CCR0.IFG) */
#define DMA2TSEL_6             (6*0x0001u)    /* DMA channel 2 transfer select 6:  TimerB (TB0CCR2.IFG) */
#define DMA2TSEL_7             (7*0x0001u)    /* DMA channel 2 transfer select 7:  Reserved */
#define DMA2TSEL_8             (8*0x0001u)    /* DMA channel 2 transfer select 8:  Reserved */
#define DMA2TSEL_9             (9*0x0001u)    /* DMA channel 2 transfer select 9:  Reserved */
#define DMA2TSEL_10            (10*0x0001u)   /* DMA channel 2 transfer select 10: Reserved */
#define DMA2TSEL_11            (11*0x0001u)   /* DMA channel 2 transfer select 11: Reserved */
#define DMA2TSEL_12            (12*0x0001u)   /* DMA channel 2 transfer select 12: Reserved */
#define DMA2TSEL_13            (13*0x0001u)   /* DMA channel 2 transfer select 13: Reserved */
#define DMA2TSEL_14            (14*0x0001u)   /* DMA channel 2 transfer select 14: RFRXIFG */
#define DMA2TSEL_15            (15*0x0001u)   /* DMA channel 2 transfer select 15: RFTXIFG */
#define DMA2TSEL_16            (16*0x0001u)   /* DMA channel 2 transfer select 16: USCIA0 receive */
#define DMA2TSEL_17            (17*0x0001u)   /* DMA channel 2 transfer select 17: USCIA0 transmit */
#define DMA2TSEL_18            (18*0x0001u)   /* DMA channel 2 transfer select 18: USCIB0 receive */
#define DMA2TSEL_19            (19*0x0001u)   /* DMA channel 2 transfer select 19: USCIB0 transmit */
#define DMA2TSEL_20            (20*0x0001u)   /* DMA channel 2 transfer select 20: Reserved  */
#define DMA2TSEL_21            (21*0x0001u)   /* DMA channel 2 transfer select 21: Reserved  */
#define DMA2TSEL_22            (22*0x0001u)   /* DMA channel 2 transfer select 22: Reserved  */
#define DMA2TSEL_23            (23*0x0001u)   /* DMA channel 2 transfer select 23: Reserved  */
#define DMA2TSEL_24            (24*0x0001u)   /* DMA channel 2 transfer select 24: ADC12IFGx */
#define DMA2TSEL_25            (25*0x0001u)   /* DMA channel 2 transfer select 25: Reserved */
#define DMA2TSEL_26            (26*0x0001u)   /* DMA channel 2 transfer select 26: Reserved */
#define DMA2TSEL_27            (27*0x0001u)   /* DMA channel 2 transfer select 27: Reserved */
#define DMA2TSEL_28            (28*0x0001u)   /* DMA channel 2 transfer select 28: Reserved */
#define DMA2TSEL_29            (29*0x0001u)   /* DMA channel 2 transfer select 29: Multiplier ready */
#define DMA2TSEL_30            (30*0x0001u)   /* DMA channel 2 transfer select 30: previous DMA channel DMA1IFG */
#define DMA2TSEL_31            (31*0x0001u)   /* DMA channel 2 transfer select 31: ext. Trigger (DMAE0) */

#define DMA0TSEL__DMA_REQ      (0*0x0001u)    /* DMA channel 0 transfer select 0:  DMA_REQ (sw) */
#define DMA0TSEL__TA0CCR0      (1*0x0001u)    /* DMA channel 0 transfer select 1:  Timer0_A (TA0CCR0.IFG) */
#define DMA0TSEL__TA0CCR2      (2*0x0001u)    /* DMA channel 0 transfer select 2:  Timer0_A (TA0CCR2.IFG) */
#define DMA0TSEL__TA1CCR0      (3*0x0001u)    /* DMA channel 0 transfer select 3:  Timer1_A (TA1CCR0.IFG) */
#define DMA0TSEL__TA1CCR2      (4*0x0001u)    /* DMA channel 0 transfer select 4:  Timer1_A (TA1CCR2.IFG) */
#define DMA0TSEL__TB0CCR0      (5*0x0001u)    /* DMA channel 0 transfer select 5:  TimerB (TB0CCR0.IFG) */
#define DMA0TSEL__TB0CCR2      (6*0x0001u)    /* DMA channel 0 transfer select 6:  TimerB (TB0CCR2.IFG) */
#define DMA0TSEL__RES7         (7*0x0001u)    /* DMA channel 0 transfer select 7:  Reserved */
#define DMA0TSEL__RES8         (8*0x0001u)    /* DMA channel 0 transfer select 8:  Reserved */
#define DMA0TSEL__RES9         (9*0x0001u)    /* DMA channel 0 transfer select 9:  Reserved */
#define DMA0TSEL__RES10        (10*0x0001u)   /* DMA channel 0 transfer select 10: Reserved */
#define DMA0TSEL__RES11        (11*0x0001u)   /* DMA channel 0 transfer select 11: Reserved */
#define DMA0TSEL__RES12        (12*0x0001u)   /* DMA channel 0 transfer select 12: Reserved */
#define DMA0TSEL__RES13        (13*0x0001u)   /* DMA channel 0 transfer select 13: Reserved */
#define DMA0TSEL__RFRXIFG      (14*0x0001u)   /* DMA channel 0 transfer select 14: RFRXIFG */
#define DMA0TSEL__RFTXIFG      (15*0x0001u)   /* DMA channel 0 transfer select 15: RFTXIFG */
#define DMA0TSEL__USCIA0RX     (16*0x0001u)   /* DMA channel 0 transfer select 16: USCIA0 receive */
#define DMA0TSEL__USCIA0TX     (17*0x0001u)   /* DMA channel 0 transfer select 17: USCIA0 transmit */
#define DMA0TSEL__USCIB0RX     (18*0x0001u)   /* DMA channel 0 transfer select 18: USCIB0 receive */
#define DMA0TSEL__USCIB0TX     (19*0x0001u)   /* DMA channel 0 transfer select 19: USCIB0 transmit */
#define DMA0TSEL__RES20        (20*0x0001u)   /* DMA channel 0 transfer select 20: Reserved  */
#define DMA0TSEL__RES21        (21*0x0001u)   /* DMA channel 0 transfer select 21: Reserved  */
#define DMA0TSEL__RES22        (22*0x0001u)   /* DMA channel 0 transfer select 22: Reserved  */
#define DMA0TSEL__RES23        (23*0x0001u)   /* DMA channel 0 transfer select 23: Reserved  */
#define DMA0TSEL__ADC12IFG     (24*0x0001u)   /* DMA channel 0 transfer select 24: ADC12IFGx */
#define DMA0TSEL__RES25        (25*0x0001u)   /* DMA channel 0 transfer select 25: Reserved */
#define DMA0TSEL__RES26        (26*0x0001u)   /* DMA channel 0 transfer select 26: Reserved */
#define DMA0TSEL__RES27        (27*0x0001u)   /* DMA channel 0 transfer select 27: Reserved */
#define DMA0TSEL__RES28        (28*0x0001u)   /* DMA channel 0 transfer select 28: Reserved */
#define DMA0TSEL__MPY          (29*0x0001u)   /* DMA channel 0 transfer select 29: Multiplier ready */
#define DMA0TSEL__DMA2IFG      (30*0x0001u)   /* DMA channel 0 transfer select 30: previous DMA channel DMA2IFG */
#define DMA0TSEL__DMAE0        (31*0x0001u)   /* DMA channel 0 transfer select 31: ext. Trigger (DMAE0) */
                        
#define DMA1TSEL__DMA_REQ      (0*0x0100u)    /* DMA channel 1 transfer select 0:  DMA_REQ (sw) */
#define DMA1TSEL__TA0CCR0      (1*0x0100u)    /* DMA channel 1 transfer select 1:  Timer0_A (TA0CCR0.IFG) */
#define DMA1TSEL__TA0CCR2      (2*0x0100u)    /* DMA channel 1 transfer select 2:  Timer0_A (TA0CCR2.IFG) */
#define DMA1TSEL__TA1CCR0      (3*0x0100u)    /* DMA channel 1 transfer select 3:  Timer1_A (TA1CCR0.IFG) */
#define DMA1TSEL__TA1CCR2      (4*0x0100u)    /* DMA channel 1 transfer select 4:  Timer1_A (TA1CCR2.IFG) */
#define DMA1TSEL__TB0CCR0      (5*0x0100u)    /* DMA channel 1 transfer select 5:  TimerB (TB0CCR0.IFG) */
#define DMA1TSEL__TB0CCR2      (6*0x0100u)    /* DMA channel 1 transfer select 6:  TimerB (TB0CCR2.IFG) */
#define DMA1TSEL__RES7         (7*0x0100u)    /* DMA channel 1 transfer select 7:  Reserved */
#define DMA1TSEL__RES8         (8*0x0100u)    /* DMA channel 1 transfer select 8:  Reserved */
#define DMA1TSEL__RES9         (9*0x0100u)    /* DMA channel 1 transfer select 9:  Reserved */
#define DMA1TSEL__RES10        (10*0x0100u)   /* DMA channel 1 transfer select 10: Reserved */
#define DMA1TSEL__RES11        (11*0x0100u)   /* DMA channel 1 transfer select 11: Reserved */
#define DMA1TSEL__RES12        (12*0x0100u)   /* DMA channel 1 transfer select 12: Reserved */
#define DMA1TSEL__RES13        (13*0x0100u)   /* DMA channel 1 transfer select 13: Reserved */
#define DMA1TSEL__RFRXIFG      (14*0x0100u)   /* DMA channel 1 transfer select 14: RFRXIFG */
#define DMA1TSEL__RFTXIFG      (15*0x0100u)   /* DMA channel 1 transfer select 15: RFTXIFG */
#define DMA1TSEL__USCIA0RX     (16*0x0100u)   /* DMA channel 1 transfer select 16: USCIA0 receive */
#define DMA1TSEL__USCIA0TX     (17*0x0100u)   /* DMA channel 1 transfer select 17: USCIA0 transmit */
#define DMA1TSEL__USCIB0RX     (18*0x0100u)   /* DMA channel 1 transfer select 18: USCIB0 receive */
#define DMA1TSEL__USCIB0TX     (19*0x0100u)   /* DMA channel 1 transfer select 19: USCIB0 transmit */
#define DMA1TSEL__RES20        (20*0x0100u)   /* DMA channel 1 transfer select 20: Reserved  */
#define DMA1TSEL__RES21        (21*0x0100u)   /* DMA channel 1 transfer select 21: Reserved  */
#define DMA1TSEL__RES22        (22*0x0100u)   /* DMA channel 1 transfer select 22: Reserved  */
#define DMA1TSEL__RES23        (23*0x0100u)   /* DMA channel 1 transfer select 23: Reserved  */
#define DMA1TSEL__ADC12IFG     (24*0x0100u)   /* DMA channel 1 transfer select 24: ADC12IFGx */
#define DMA1TSEL__RES25        (25*0x0100u)   /* DMA channel 1 transfer select 25: Reserved */
#define DMA1TSEL__RES26        (26*0x0100u)   /* DMA channel 1 transfer select 26: Reserved */
#define DMA1TSEL__RES27        (27*0x0100u)   /* DMA channel 1 transfer select 27: Reserved */
#define DMA1TSEL__RES28        (28*0x0100u)   /* DMA channel 1 transfer select 28: Reserved */
#define DMA1TSEL__MPY          (29*0x0100u)   /* DMA channel 1 transfer select 29: Multiplier ready */
#define DMA1TSEL__DMA0IFG      (30*0x0100u)   /* DMA channel 1 transfer select 30: previous DMA channel DMA0IFG */
#define DMA1TSEL__DMAE0        (31*0x0100u)   /* DMA channel 1 transfer select 31: ext. Trigger (DMAE0) */
                          
#define DMA2TSEL__DMA_REQ      (0*0x0001u)    /* DMA channel 2 transfer select 0:  DMA_REQ (sw) */
#define DMA2TSEL__TA0CCR0      (1*0x0001u)    /* DMA channel 2 transfer select 1:  Timer0_A (TA0CCR0.IFG) */
#define DMA2TSEL__TA0CCR2      (2*0x0001u)    /* DMA channel 2 transfer select 2:  Timer0_A (TA0CCR2.IFG) */
#define DMA2TSEL__TA1CCR0      (3*0x0001u)    /* DMA channel 2 transfer select 3:  Timer1_A (TA1CCR0.IFG) */
#define DMA2TSEL__TA1CCR2      (4*0x0001u)    /* DMA channel 2 transfer select 4:  Timer1_A (TA1CCR2.IFG) */
#define DMA2TSEL__TB0CCR0      (5*0x0001u)    /* DMA channel 2 transfer select 5:  TimerB (TB0CCR0.IFG) */
#define DMA2TSEL__TB0CCR2      (6*0x0001u)    /* DMA channel 2 transfer select 6:  TimerB (TB0CCR2.IFG) */
#define DMA2TSEL__RES7         (7*0x0001u)    /* DMA channel 2 transfer select 7:  Reserved */
#define DMA2TSEL__RES8         (8*0x0001u)    /* DMA channel 2 transfer select 8:  Reserved */
#define DMA2TSEL__RES9         (9*0x0001u)    /* DMA channel 2 transfer select 9:  Reserved */
#define DMA2TSEL__RES10        (10*0x0001u)   /* DMA channel 2 transfer select 10: Reserved */
#define DMA2TSEL__RES11        (11*0x0001u)   /* DMA channel 2 transfer select 11: Reserved */
#define DMA2TSEL__RES12        (12*0x0001u)   /* DMA channel 2 transfer select 12: Reserved */
#define DMA2TSEL__RES13        (13*0x0001u)   /* DMA channel 2 transfer select 13: Reserved */
#define DMA2TSEL__RFRXIFG      (14*0x0001u)   /* DMA channel 2 transfer select 14: RFRXIFG */
#define DMA2TSEL__RFTXIFG      (15*0x0001u)   /* DMA channel 2 transfer select 15: RFTXIFG */
#define DMA2TSEL__USCIA0RX     (16*0x0001u)   /* DMA channel 2 transfer select 16: USCIA0 receive */
#define DMA2TSEL__USCIA0TX     (17*0x0001u)   /* DMA channel 2 transfer select 17: USCIA0 transmit */
#define DMA2TSEL__USCIB0RX     (18*0x0001u)   /* DMA channel 2 transfer select 18: USCIB0 receive */
#define DMA2TSEL__USCIB0TX     (19*0x0001u)   /* DMA channel 2 transfer select 19: USCIB0 transmit */
#define DMA2TSEL__RES20        (20*0x0001u)   /* DMA channel 2 transfer select 20: Reserved  */
#define DMA2TSEL__RES21        (21*0x0001u)   /* DMA channel 2 transfer select 21: Reserved  */
#define DMA2TSEL__RES22        (22*0x0001u)   /* DMA channel 2 transfer select 22: Reserved  */
#define DMA2TSEL__RES23        (23*0x0001u)   /* DMA channel 2 transfer select 23: Reserved  */
#define DMA2TSEL__ADC12IFG     (24*0x0001u)   /* DMA channel 2 transfer select 24: ADC12IFGx */
#define DMA2TSEL__RES25        (25*0x0001u)   /* DMA channel 2 transfer select 25: Reserved */
#define DMA2TSEL__RES26        (26*0x0001u)   /* DMA channel 2 transfer select 26: Reserved */
#define DMA2TSEL__RES27        (27*0x0001u)   /* DMA channel 2 transfer select 27: Reserved */
#define DMA2TSEL__RES28        (28*0x0001u)   /* DMA channel 2 transfer select 28: Reserved */
#define DMA2TSEL__MPY          (29*0x0001u)   /* DMA channel 2 transfer select 29: Multiplier ready */
#define DMA2TSEL__DMA1IFG      (30*0x0001u)   /* DMA channel 2 transfer select 30: previous DMA channel DMA1IFG */
#define DMA2TSEL__DMAE0        (31*0x0001u)   /* DMA channel 2 transfer select 31: ext. Trigger (DMAE0) */

#endif /* __MSP430_DMA_BASE__ */

#endif /* __MSP430_HEADERS_DMAX_H__ */

