/*
 * Copyright (c) 2006, Swedish Institute of Computer Science.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: test-receiver.c,v 1.1 2006/06/18 07:48:48 adamdunkels Exp $
 *
 * -----------------------------------------------------------------
 *
 * Author  : Adam Dunkels, Joakim Eriksson, Niclas Finne
 * Created : 2006-03-07
 * Updated : $Date: 2006/06/18 07:48:48 $
 *           $Revision: 1.1 $
 */

#include "contiki-esb.h"
#include <stdio.h>

PROCESS(test_receiver_process, "Test - Receiver");
AUTOSTART_PROCESSES(&test_receiver_process);

#define PORT 1234

PROCESS_THREAD(test_receiver_process, ev, data)
{
  static struct uip_udp_conn *conn;

  PROCESS_BEGIN();

  conn = udp_broadcast_new(HTONS(PORT), NULL);

  while(1) {
    PROCESS_WAIT_EVENT_UNTIL(ev == tcpip_event && uip_newdata());
    leds_invert(LEDS_YELLOW);

    /* Make sure the message is null terminated */
    ((char *) uip_appdata)[uip_datalen()] = 0;
    printf("RECV: %s\n", (char *) uip_appdata);

  }
  PROCESS_END();
}
/*---------------------------------------------------------------------*/
