/*
 * Copyright (c) 2006, Swedish Institute of Computer Science.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: simEnvChange.c,v 1.8 2009/05/26 14:08:51 fros4943 Exp $
 */

#include "lib/simEnvChange.h"

#include <stdio.h>
#include <string.h>

// All registered interfaces
extern const struct simInterface *simInterfaces[];

char simDontFallAsleep = 0;
char simNoYield = 0;
char simDoReceiverCallback = 0;

int simProcessRunValue;
int simEtimerPending;
clock_time_t simNextExpirationTime;

void doActionsBeforeTick() {
  // Poll all interfaces to do their thing before the tick
  int i;
  for(i = 0; simInterfaces[i] != NULL; ++i) {
    simInterfaces[i]->doActionsBeforeTick();
  }
}

void doActionsAfterTick() {
  // Poll all interfaces to do their thing after the tick
  int i;
  for(i = 0; simInterfaces[i] != NULL; ++i) {
    simInterfaces[i]->doActionsAfterTick();
  }
}
