/*
 * Copyright (c) 2006, Swedish Institute of Computer Science
 * All rights reserved. 
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met: 
 * 1. Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright 
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the distribution. 
 * 3. Neither the name of the Institute nor the names of its contributors 
 *    may be used to endorse or promote products derived from this software 
 *    without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE 
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE. 
 *
 * @(#)$Id: minileds.c,v 1.1 2006/09/27 09:32:08 bg- Exp $
 */

/*
 * Minileds is intended to substitute the full leds package when only
 * a small portion of the full functionality is required. It is
 * intended to be syntactically compatible but with a simplified
 * semantics. The semantic difference lies in not counting the number
 * of leds_on and leds_off:s. It saves a substantial amount of RAM
 * (820 bytes on a msp430).
 */

#include <io.h>

#include "contiki.h"

#include "dev/leds.h"

void
leds_init(void)
{
  LEDS_PxDIR |= (LEDS_CONF_RED | LEDS_CONF_GREEN | LEDS_CONF_YELLOW);
  LEDS_PxOUT |= (LEDS_CONF_RED | LEDS_CONF_GREEN | LEDS_CONF_YELLOW);
}

static const unsigned char l2p[LEDS_ALL + 1] = {
  0,
  LEDS_CONF_GREEN,
  LEDS_CONF_YELLOW,
  LEDS_CONF_YELLOW | LEDS_CONF_GREEN,
  LEDS_CONF_RED,
  LEDS_CONF_RED | LEDS_CONF_GREEN,
  LEDS_CONF_RED | LEDS_CONF_YELLOW,
  LEDS_CONF_RED | LEDS_CONF_YELLOW | LEDS_CONF_GREEN
};
  

void
leds_on(unsigned char leds)
{
  LEDS_PxOUT &= ~l2p[leds & LEDS_ALL];
}

void
leds_off(unsigned char leds)
{
  LEDS_PxOUT |= l2p[leds & LEDS_ALL];
}

void
leds_toggle(unsigned char leds)
{
  /*
   * Synonym: void leds_invert(unsigned char leds);
   */
  asm(".global leds_invert\nleds_invert:\n");

  LEDS_PxOUT ^= l2p[leds & LEDS_ALL];
}
