/*
 * Copyright (c) 2007, Swedish Institute of Computer Science.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * This file is part of the Contiki operating system.
 *
 * $Id: uip-over-mesh.h,v 1.3 2008/11/09 12:20:56 adamdunkels Exp $
 */

/**
 * \file
 *         Header file for tunnelling uIP over Rime mesh
 * \author
 *         Adam Dunkels <adam@sics.se>
 */

#ifndef __UIP_OVER_MESH_H__
#define __UIP_OVER_MESH_H__

#include "net/uip.h"
#include "net/uip-fw.h"
#include "net/rime.h"

void uip_over_mesh_init(u16_t channels);
u8_t uip_over_mesh_send(void);

void uip_over_mesh_set_gateway_netif(struct uip_fw_netif *netif);
void uip_over_mesh_set_gateway(rimeaddr_t *gw);
void uip_over_mesh_set_net(uip_ipaddr_t *addr, uip_ipaddr_t *mask);

void uip_over_mesh_make_announced_gateway(void);

#endif /* __UIP-OVER-MESH_H__ */
