/*
 * Copyright (c) 2007, Swedish Institute of Computer Science
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @(#)$Id: sym.h,v 1.1 2007/04/25 15:33:29 bg- Exp $
 */

#ifndef SYM_H
#define SYM_H

typedef void (*sym_func_t)();

/*
 * Even with an explicit cast, it is invalid to convert a function
 * pointer to an object pointer or a pointer to void, or vice-versa.
 */
union sym_value {
  void *obj;			/* Object pointer */
  sym_func_t func;		/* or function pointer */
};

struct sym_bol {
  const char *name;
  union sym_value value;
};

/* Lookup a pointer to an ANSI C object. */
void *sym_object(const char *name);

/* Lookup a pointer to an ANSI C function. */
sym_func_t sym_function(const char *name);

extern const int sym_obj_nelts;
extern const int sym_func_nelts;

extern const struct sym_bol sym_obj[/* sym_obj_nelts */];
extern const struct sym_bol sym_func[/* sym_func__nelts */];

#endif /* SYM_H */
