/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.util;

public class Utils {
    private static final String str16 = "0000000000000000";
    public static final int BYTE = 0;
    public static final int UBYTE = 1;
    public static final int WORD = 2;
    public static final int UWORD = 3;
    public static final int ASCII = 1;
    public static final int HEX = 2;
    public static final int DEC = 3;

    public static int size(int type) {
        return 1 + type / 2;
    }

    public static String toString(int data, int type, int mode) {
        int size = 1 + type / 2;
        switch (mode) {
            case 1: {
                if (data >= 32 && data <= 127) {
                    return "" + (char)data;
                }
                return ".";
            }
            case 2: {
                return size == 2 ? Utils.hex16(data) : Utils.hex8(data);
            }
        }
        return "" + data;
    }

    public static String binary8(int data) {
        String s = Integer.toString(data, 2);
        if (s.length() < 8) {
            s = str16.substring(0, 8 - s.length()) + s;
        }
        return s;
    }

    public static String binary16(int data) {
        String s = Integer.toString(data, 2);
        if (s.length() < 16) {
            s = str16.substring(0, 16 - s.length()) + s;
        }
        return s;
    }

    public static String hex8(int data) {
        String s = Integer.toString(data & 0xFF, 16);
        if (s.length() < 2) {
            s = str16.substring(0, 2 - s.length()) + s;
        }
        return s;
    }

    public static String hex16(int data) {
        String s = Integer.toString(data & 0xFFFF, 16);
        if (s.length() < 4) {
            s = str16.substring(0, 4 - s.length()) + s;
        }
        return s;
    }

    public static void fill(byte[] array, int pos, int len, byte value) {
        for (int i = 0; i < len; ++i) {
            array[pos++] = value;
        }
    }

    public static int decodeInt(String value) throws NumberFormatException {
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (value.startsWith("-")) {
            ++index;
            negative = true;
        }
        if (value.startsWith("$", index) || value.startsWith("#", index)) {
            radix = 16;
            ++index;
        } else if (value.startsWith("0x", index) || value.startsWith("0X", index)) {
            radix = 16;
            index += 2;
        } else if (value.startsWith("0", index) && value.length() > index + 1) {
            radix = 8;
            ++index;
        } else if (value.startsWith("%", index)) {
            radix = 2;
            ++index;
        }
        String intValue = value;
        if (radix != 10) {
            if (value.startsWith("-", index)) {
                throw new NumberFormatException("unexpected negative sign: " + value);
            }
            intValue = negative ? '-' + value.substring(index) : value.substring(index);
        }
        return Integer.parseInt(intValue, radix);
    }

    public static long decodeLong(String value) throws NumberFormatException {
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (value.startsWith("-")) {
            ++index;
            negative = true;
        }
        if (value.startsWith("$", index) || value.startsWith("#", index)) {
            radix = 16;
            ++index;
        } else if (value.startsWith("0x", index) || value.startsWith("0X", index)) {
            radix = 16;
            index += 2;
        } else if (value.startsWith("0", index) && value.length() > index + 1) {
            radix = 8;
            ++index;
        } else if (value.startsWith("%", index)) {
            radix = 2;
            ++index;
        }
        String longValue = value;
        if (radix != 10) {
            if (value.startsWith("-", index)) {
                throw new NumberFormatException("unexpected negative sign: " + value);
            }
            longValue = negative ? '-' + value.substring(index) : value.substring(index);
        }
        return Long.parseLong(longValue, radix);
    }

    public static byte[] hexconv(String line) {
        if (line == null) {
            return null;
        }
        byte[] data = new byte[line.length() / 2];
        int hpos = 0;
        int totVal = 0;
        int dataPos = 0;
        int n = line.length();
        for (int i = 0; i < n; ++i) {
            int val = line.charAt(i);
            if (val >= 48 && val <= 57) {
                val -= 48;
            } else if (val >= 97 && val <= 102) {
                val = val + 10 - 97;
            } else if (val >= 65 && val <= 70) {
                val = val + 10 - 65;
            } else {
                return null;
            }
            if (hpos == 0) {
                totVal = val << 4;
                ++hpos;
                continue;
            }
            hpos = 0;
            data[dataPos++] = (byte)((totVal += val) & 0xFF);
        }
        return data;
    }

    public static boolean equals(byte[] arr1, byte[] arr2) {
        if (arr1 == null && arr2 == null) {
            return true;
        }
        if (arr1 == null || arr2 == null) {
            return false;
        }
        if (arr1.length != arr2.length) {
            return false;
        }
        for (int i = 0; i < arr1.length; ++i) {
            if (arr1[i] == arr2[i]) continue;
            return false;
        }
        return true;
    }
}

