/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.util;

import java.io.IOException;
import se.sics.mspsim.core.IOUnit;
import se.sics.mspsim.core.MSP430;
import se.sics.mspsim.core.USART;
import se.sics.mspsim.core.USARTListener;
import se.sics.mspsim.util.ComponentRegistry;
import se.sics.mspsim.util.ELF;
import se.sics.mspsim.util.MapTable;

public class Test
implements USARTListener {
    private StringBuilder lineBuffer = new StringBuilder();
    private MSP430 cpu;

    public Test(MSP430 cpu) {
        this.cpu = cpu;
        IOUnit usart = cpu.getIOUnit("USART 1");
        if (usart instanceof USART) {
            ((USART)usart).setUSARTListener(this);
        }
    }

    @Override
    public void dataReceived(USART source, int data) {
        if (data == 10) {
            String line = this.lineBuffer.toString();
            this.lineBuffer.setLength(0);
            System.out.println("#|" + line);
            if (line.startsWith("FAIL:")) {
                System.exit(0);
            } else if (line.startsWith("EXIT")) {
                System.out.println("Tests succeded!");
                System.exit(0);
            } else if (line.startsWith("DEBUG")) {
                this.cpu.setDebug(true);
            } else if (line.startsWith("PROFILE")) {
                this.cpu.getProfiler().printProfile(System.out);
            } else if (line.startsWith("CLEARPROFILE")) {
                this.cpu.getProfiler().clearProfile();
            }
        } else {
            this.lineBuffer.append((char)data);
        }
    }

    public static void main(String[] args) {
        MSP430 cpu = new MSP430(0, new ComponentRegistry());
        int index = 0;
        if (args[index].startsWith("-")) {
            if ("-debug".equalsIgnoreCase(args[index])) {
                cpu.setDebug(true);
            } else {
                System.err.println("Unknown flag: " + args[index]);
                System.exit(1);
            }
            ++index;
        }
        try {
            int[] memory = cpu.getMemory();
            ELF elf = ELF.readELF(args[index++]);
            elf.loadPrograms(memory);
            MapTable map = elf.getMap();
            cpu.getDisAsm().setMap(map);
            cpu.setMap(map);
            cpu.reset();
            new Test(cpu);
            try {
                cpu.cpuloop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    @Override
    public void stateChanged(int state) {
    }
}

