/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.util;

import java.io.PrintStream;
import se.sics.mspsim.cli.BasicAsyncCommand;
import se.sics.mspsim.cli.BasicCommand;
import se.sics.mspsim.cli.BasicLineCommand;
import se.sics.mspsim.cli.CommandBundle;
import se.sics.mspsim.cli.CommandContext;
import se.sics.mspsim.cli.CommandHandler;
import se.sics.mspsim.core.Chip;
import se.sics.mspsim.core.MSP430Core;
import se.sics.mspsim.core.TimeEvent;
import se.sics.mspsim.util.ComponentRegistry;
import se.sics.mspsim.util.DataSource;
import se.sics.mspsim.util.MultiDataSource;
import se.sics.mspsim.util.OperatingModeStatistics;

public class StatCommands
implements CommandBundle {
    private final MSP430Core cpu;
    private final OperatingModeStatistics statistics;

    public StatCommands(MSP430Core cpu, OperatingModeStatistics statistics) {
        this.cpu = cpu;
        this.statistics = statistics;
    }

    @Override
    public void setupCommands(ComponentRegistry registry, CommandHandler handler) {
        handler.registerCommand("chipinfo", new BasicCommand("show information about specified chip", "[chips...]"){

            @Override
            public int executeCommand(CommandContext context) {
                if (context.getArgumentCount() > 0) {
                    int n = context.getArgumentCount();
                    for (int i = 0; i < n; ++i) {
                        String chipName = context.getArgument(i);
                        Chip chip = StatCommands.this.statistics.getChip(chipName);
                        if (chip == null) {
                            context.out.println("  " + chipName + ": NOT FOUND");
                            continue;
                        }
                        context.out.println(chipName + ": " + chip);
                        context.out.println(chip.chipinfo());
                    }
                } else {
                    Chip[] chips = StatCommands.this.statistics.getChips();
                    if (chips == null) {
                        context.out.println("No chips found.");
                    } else {
                        int n = chips.length;
                        for (int i = 0; i < n; ++i) {
                            context.out.println("  " + chips[i].getName());
                        }
                    }
                }
                return 0;
            }
        });
        handler.registerCommand("mult", new BasicLineCommand("multiply line of doubles", "[m1...mn]"){
            double[] multiplicator;
            private PrintStream out;

            @Override
            public int executeCommand(CommandContext context) {
                this.out = context.out;
                int args = context.getArgumentCount();
                this.multiplicator = new double[args];
                for (int i = 0; i < args; ++i) {
                    this.multiplicator[i] = context.getArgumentAsDouble(i);
                }
                return 0;
            }

            @Override
            public void lineRead(String line) {
                String[] parts = line.split(" ");
                for (int i = 0; i < parts.length; ++i) {
                    this.out.print(this.multiplicator[i % this.multiplicator.length] * Double.parseDouble(parts[i]) + " ");
                }
                this.out.println();
            }

            @Override
            public void stopCommand(CommandContext context) {
            }
        });
        handler.registerCommand("duty", new BasicAsyncCommand("add a duty cycle sampler for operating modes to the specified chips", "<frequency> <chip> [chips...]"){
            private PrintStream out;
            private Object[] sources;
            private double frequency;
            private boolean isRunning;
            {
                this.isRunning = true;
            }

            @Override
            public int executeCommand(CommandContext context) {
                this.frequency = context.getArgumentAsDouble(0);
                if (this.frequency <= 0.0) {
                    context.err.println("illegal frequency: " + context.getArgument(0));
                    return 1;
                }
                this.sources = new Object[context.getArgumentCount() - 1];
                int n = this.sources.length;
                for (int i = 0; i < n; ++i) {
                    String sName = context.getArgument(i + 1);
                    if (sName.indexOf(46) >= 0) {
                        String[] parts = sName.split("\\.");
                        this.sources[i] = StatCommands.this.statistics.getDataSource(parts[0], parts[1]);
                        if (this.sources[i] != null) continue;
                        context.err.println("could not find chip / mode combination " + sName);
                        return 1;
                    }
                    this.sources[i] = StatCommands.this.statistics.getMultiDataSource(sName);
                    if (this.sources[i] != null) continue;
                    context.err.println("could not find chip " + sName);
                    return 1;
                }
                this.out = context.out;
                StatCommands.this.cpu.scheduleTimeEventMillis(new TimeEvent(0L){

                    @Override
                    public void execute(long t) {
                        if (isRunning) {
                            StatCommands.this.cpu.scheduleTimeEventMillis(this, 1000.0 / frequency);
                            int n = sources.length;
                            for (int j = 0; j < n; ++j) {
                                Object s = sources[j];
                                if (j > 0) {
                                    out.print(' ');
                                }
                                if (s instanceof MultiDataSource) {
                                    MultiDataSource ds = (MultiDataSource)s;
                                    int m = ds.getModeMax();
                                    for (int k = 0; k <= m; ++k) {
                                        if (k > 0) {
                                            out.print(' ');
                                        }
                                        out.print((double)((int)(ds.getDoubleValue(k) * 100.0 + 0.5)) / 100.0);
                                    }
                                    continue;
                                }
                                out.print((double)((int)(((DataSource)s).getDoubleValue() * 100.0 + 0.5)) / 100.0);
                            }
                            out.println();
                        }
                    }
                }, 1000.0 / this.frequency);
                return 0;
            }

            @Override
            public void stopCommand(CommandContext context) {
                this.isRunning = false;
                context.exit(0);
            }
        });
    }
}

