/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.util;

import se.sics.mspsim.core.CPUMonitor;
import se.sics.mspsim.core.MSP430;
import se.sics.mspsim.util.DataSource;
import se.sics.mspsim.util.MapTable;

public class StackMonitor
implements CPUMonitor {
    private MSP430 cpu;
    private int heapStartAddress;
    private int stackStartAddress;
    private int stackMin = 0;
    private int stackMax = 0;
    private int stack = 0;
    private DataSource maxDataSource = new DataSource(){

        @Override
        public int getValue() {
            int tmp = StackMonitor.this.stackMax;
            StackMonitor.this.stackMax = StackMonitor.this.stack;
            return tmp;
        }

        @Override
        public double getDoubleValue() {
            return this.getValue();
        }
    };
    private DataSource minDataSource = new DataSource(){

        @Override
        public int getValue() {
            int tmp = StackMonitor.this.stackMin;
            StackMonitor.this.stackMin = StackMonitor.this.stack;
            return tmp;
        }

        @Override
        public double getDoubleValue() {
            return this.getValue();
        }
    };
    private DataSource dataSource = new DataSource(){

        @Override
        public int getValue() {
            return StackMonitor.this.stack;
        }

        @Override
        public double getDoubleValue() {
            return this.getValue();
        }
    };

    public StackMonitor(MSP430 cpu) {
        MapTable mapTable;
        this.cpu = cpu;
        this.cpu.setRegisterWriteMonitor(1, this);
        if (cpu.getDisAsm() != null && (mapTable = cpu.getDisAsm().getMap()) != null) {
            this.heapStartAddress = mapTable.heapStartAddress;
            this.stackStartAddress = mapTable.stackStartAddress;
        }
    }

    public int getStackStart() {
        return this.stackStartAddress;
    }

    public int getHeapStart() {
        return this.heapStartAddress;
    }

    public DataSource getMaxSource() {
        return this.maxDataSource;
    }

    public DataSource getMinSource() {
        return this.minDataSource;
    }

    public DataSource getSource() {
        return this.dataSource;
    }

    @Override
    public void cpuAction(int type, int adr, int data) {
        this.stack = (this.stackStartAddress - data + 65535) % 65535;
        if (this.stack > this.stackMax) {
            this.stackMax = this.stack;
        }
        if (this.stack < this.stackMin) {
            this.stackMin = this.stack;
        }
    }
}

