/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.util;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import se.sics.mspsim.core.Chip;
import se.sics.mspsim.core.EventListener;
import se.sics.mspsim.core.EventSource;
import se.sics.mspsim.core.MSP430Core;
import se.sics.mspsim.core.Profiler;
import se.sics.mspsim.profiler.CallListener;
import se.sics.mspsim.util.ArrayUtils;
import se.sics.mspsim.util.MapEntry;
import se.sics.mspsim.util.Utils;

public class SimpleProfiler
implements Profiler,
EventListener {
    private HashMap<MapEntry, CallEntry> profileData;
    private HashMap<String, TagEntry> tagProfiles;
    private HashMap<String, TagEntry> startTags;
    private HashMap<String, TagEntry> endTags;
    private HashMap<String, String> ignoreFunctions;
    private CallEntry[] callStack;
    private int cSP = 0;
    private MSP430Core cpu;
    private PrintStream logger;
    private boolean hideIRQ = false;
    private CallListener[] callListeners;
    private long[] lastInterruptTime = new long[16];
    private long[] interruptTime = new long[16];
    private long[] interruptCount = new long[16];
    private int servicedInterrupt = -1;
    private int interruptLevel;
    private boolean newIRQ;

    public SimpleProfiler() {
        this.profileData = new HashMap();
        this.tagProfiles = new HashMap();
        this.startTags = new HashMap();
        this.endTags = new HashMap();
        this.ignoreFunctions = new HashMap();
        this.callStack = new CallEntry[64];
    }

    @Override
    public void setCPU(MSP430Core cpu) {
        this.cpu = cpu;
    }

    public void setHideIRQ(boolean hide) {
        this.hideIRQ = hide;
    }

    public void addIgnoreFunction(String function) {
        this.ignoreFunctions.put(function, function);
    }

    @Override
    public void profileCall(MapEntry entry, long cycles) {
        if (this.cSP == this.callStack.length) {
            CallEntry[] tmp = new CallEntry[this.cSP + 64];
            System.arraycopy(this.callStack, 0, tmp, 0, this.cSP);
            this.callStack = tmp;
        }
        if (this.callStack[this.cSP] == null) {
            this.callStack[this.cSP] = new CallEntry();
        }
        int hide = 0;
        if (this.logger != null) {
            int n = hide = this.cSP == 0 || this.newIRQ ? 0 : this.callStack[this.cSP - 1].hide;
            if (hide > 0) {
                ++hide;
            }
            if (!(this.hideIRQ && this.servicedInterrupt != -1 || hide != 0)) {
                if (this.servicedInterrupt >= 0) {
                    this.logger.printf("[%2d] ", this.servicedInterrupt);
                }
                this.printSpace(this.logger, this.cSP * 2 - this.interruptLevel);
                this.logger.println("Call to $" + Utils.hex16(entry.getAddress()) + ": " + entry.getInfo());
                if (this.ignoreFunctions.get(entry.getName()) != null) {
                    hide = 1;
                }
            }
        }
        CallEntry ce = this.callStack[this.cSP++];
        ce.function = entry;
        ce.calls = 0;
        ce.cycles = cycles;
        ce.exclusiveCycles = cycles;
        ce.hide = hide;
        this.newIRQ = false;
        CallListener[] listeners = this.callListeners;
        if (listeners != null) {
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                listeners[i].functionCall(this, entry);
            }
        }
    }

    @Override
    public void profileReturn(long cycles) {
        if (this.cSP <= 0) {
            this.logger.println("SimpleProfiler: Too many returns?");
            return;
        }
        CallEntry cspEntry = this.callStack[--this.cSP];
        MapEntry fkn = cspEntry.function;
        long elapsed = cycles - cspEntry.cycles;
        long exElapsed = cycles - cspEntry.exclusiveCycles;
        if (this.cSP != 0) {
            this.callStack[this.cSP - 1].exclusiveCycles += elapsed;
        }
        if (cspEntry.calls >= 0) {
            CallListener[] listeners;
            CallEntry ce = this.profileData.get(fkn);
            if (ce == null) {
                ce = new CallEntry();
                this.profileData.put(fkn, ce);
                ce.function = fkn;
            }
            ce.cycles += elapsed;
            ce.exclusiveCycles += exElapsed;
            ++ce.calls;
            if (this.cSP != 0) {
                HashMap<MapEntry, Integer> callers = ce.callers;
                MapEntry caller = this.callStack[this.cSP - 1].function;
                Integer numCalls = callers.get(caller);
                if (numCalls == null) {
                    callers.put(caller, 1);
                } else {
                    callers.put(caller, numCalls + 1);
                }
            }
            if (!(this.logger == null || cspEntry.hide > 1 || this.hideIRQ && this.servicedInterrupt != -1)) {
                if (this.servicedInterrupt >= 0) {
                    this.logger.printf("[%2d] ", this.servicedInterrupt);
                }
                this.printSpace(this.logger, this.cSP * 2 - this.interruptLevel);
                this.logger.println("return from " + ce.function.getInfo() + " elapsed: " + elapsed);
            }
            if ((listeners = this.callListeners) != null) {
                int n = listeners.length;
                for (int i = 0; i < n; ++i) {
                    listeners[i].functionReturn(this, fkn);
                }
            }
        }
        this.newIRQ = false;
    }

    @Override
    public void profileInterrupt(int vector, long cycles) {
        this.servicedInterrupt = vector;
        this.lastInterruptTime[this.servicedInterrupt] = cycles;
        this.interruptLevel = this.cSP * 2;
        this.newIRQ = true;
        if (this.logger != null && !this.hideIRQ) {
            this.logger.println("----- Interrupt vector " + vector + " start execution -----");
        }
    }

    @Override
    public void profileRETI(long cycles) {
        if (this.servicedInterrupt > -1) {
            int n = this.servicedInterrupt;
            this.interruptTime[n] = this.interruptTime[n] + (cycles - this.lastInterruptTime[this.servicedInterrupt]);
            int n2 = this.servicedInterrupt;
            this.interruptCount[n2] = this.interruptCount[n2] + 1L;
        }
        this.newIRQ = false;
        if (this.logger != null && !this.hideIRQ) {
            this.logger.println("----- Interrupt vector " + this.servicedInterrupt + " returned - elapsed: " + (cycles - this.lastInterruptTime[this.servicedInterrupt]));
        }
        this.interruptLevel = 0;
        this.servicedInterrupt = -1;
    }

    @Override
    public void clearProfile() {
        if (this.profileData != null) {
            CallEntry[] entries = this.profileData.values().toArray(new CallEntry[this.profileData.size()]);
            int n = entries.length;
            for (int i = 0; i < n; ++i) {
                entries[i].cycles = 0L;
                entries[i].calls = 0;
            }
            for (CallEntry e : this.callStack) {
                if (e == null) continue;
                e.calls = -1;
            }
        }
    }

    @Override
    public void printProfile(PrintStream out) {
        this.printProfile(out, new Properties());
    }

    @Override
    public void printProfile(PrintStream out, Properties parameters) {
        int i;
        String functionNameRegexp = parameters.getProperty("function.regexp");
        String profSort = parameters.getProperty("sortmode");
        boolean profCallers = parameters.getProperty("showcallers") != null;
        Pattern pattern = null;
        CallEntry[] entries = this.profileData.values().toArray(new CallEntry[this.profileData.size()]);
        Arrays.sort(entries, new CallEntryComparator(profSort));
        out.println("************************* Profile Data **************************************");
        out.println("Function                              Calls    Average       Total  Exclusive");
        if (functionNameRegexp != null && functionNameRegexp.length() > 0) {
            pattern = Pattern.compile(functionNameRegexp);
        }
        int n = entries.length;
        for (i = 0; i < n; ++i) {
            int c = entries[i].calls;
            if (c <= 0) continue;
            String functionName = entries[i].function.getName();
            if (pattern != null && !pattern.matcher(functionName).find()) continue;
            String cyclesS = "" + entries[i].cycles;
            String exCyclesS = "" + entries[i].exclusiveCycles;
            String callS = "" + c;
            String avgS = "" + (c > 0 ? entries[i].cycles / (long)c : 0L);
            out.print(functionName);
            this.printSpace(out, 43 - functionName.length() - callS.length());
            out.print(callS);
            out.print(' ');
            this.printSpace(out, 10 - avgS.length());
            out.print(avgS);
            out.print(' ');
            this.printSpace(out, 11 - cyclesS.length());
            out.print(cyclesS);
            this.printSpace(out, 11 - exCyclesS.length());
            out.println(exCyclesS);
            if (!profCallers) continue;
            this.printCallers(entries[i], out);
        }
        out.println("********** Profile IRQ **************************");
        out.println("Vector          Average    Calls  Tot.Cycles");
        for (i = 0; i < 16; ++i) {
            out.print((i < 10 ? "0" : "") + i + "               ");
            out.printf("%4d ", this.interruptCount[i] > 0L ? this.interruptTime[i] / this.interruptCount[i] : 0L);
            out.printf("%8d   %8d", this.interruptCount[i], this.interruptTime[i]);
            out.println();
        }
    }

    private void printCallers(CallEntry callEntry, PrintStream out) {
        HashMap<MapEntry, Integer> callers = callEntry.callers;
        LinkedList<Map.Entry<MapEntry, Integer>> list = new LinkedList<Map.Entry<MapEntry, Integer>>(callers.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<MapEntry, Integer>>(){

            @Override
            public int compare(Map.Entry<MapEntry, Integer> o1, Map.Entry<MapEntry, Integer> o2) {
                return o2.getValue().compareTo(o1.getValue());
            }
        });
        for (Map.Entry entry : list) {
            String functionName = ((MapEntry)entry.getKey()).getName();
            String callS = "" + entry.getValue();
            this.printSpace(out, 12 - callS.length());
            out.print(callS);
            this.printSpace(out, 2);
            out.print(functionName);
            out.println();
        }
    }

    private void printSpace(PrintStream out, int len) {
        for (int i = 0; i < len; ++i) {
            out.print(' ');
        }
    }

    @Override
    public void printStackTrace(PrintStream out) {
        out.println("Stack Trace: number of calls: " + this.cSP);
        for (int i = 0; i < this.cSP; ++i) {
            out.println("  " + this.callStack[this.cSP - i - 1].function.getInfo());
        }
    }

    @Override
    public void setLogger(PrintStream out) {
        this.logger = out;
    }

    public void measureStart(String tag) {
        TagEntry tagEntry = this.tagProfiles.get(tag);
        if (tagEntry == null) {
            tagEntry = new TagEntry();
            tagEntry.tag = tag;
            this.tagProfiles.put(tag, tagEntry);
        }
        if (tagEntry.lastCycles == 0L) {
            tagEntry.lastCycles = this.cpu.cycles;
        }
    }

    public void measureEnd(String tag) {
        TagEntry tagEntry = this.tagProfiles.get(tag);
        if (tagEntry != null && tagEntry.lastCycles != 0L) {
            ++tagEntry.calls;
            tagEntry.cycles += this.cpu.cycles - tagEntry.lastCycles;
            tagEntry.lastCycles = 0L;
        }
    }

    public void printTagProfile(PrintStream out) {
        Object[] entries = this.tagProfiles.values().toArray(new TagEntry[this.tagProfiles.size()]);
        Arrays.sort(entries);
        for (int i = 0; i < entries.length; ++i) {
            Object entry = entries[i];
            System.out.println(((TagEntry)entry).tag + "\t" + ((TagEntry)entry).calls + "\t" + ((TagEntry)entry).cycles);
        }
    }

    public void addProfileTag(String tag, Chip chip, String start, Chip chip2, String end) {
        System.out.println("Add profile: " + tag + " start: " + start + " end: " + end);
        TagEntry tagEntry = new TagEntry();
        tagEntry.tag = tag;
        this.startTags.put(start, tagEntry);
        this.endTags.put(end, tagEntry);
        this.tagProfiles.put(tag, tagEntry);
        chip.setEventListener(this);
        chip2.setEventListener(this);
    }

    @Override
    public void event(EventSource source, String event, Object data) {
        TagEntry tagEntry = null;
        tagEntry = this.startTags.get(event);
        if (tagEntry != null) {
            if (tagEntry.lastCycles == 0L) {
                tagEntry.lastCycles = this.cpu.cycles;
            }
        } else {
            tagEntry = this.endTags.get(event);
            if (tagEntry != null && tagEntry.lastCycles != 0L) {
                ++tagEntry.calls;
                tagEntry.cycles += this.cpu.cycles - tagEntry.lastCycles;
                tagEntry.lastCycles = 0L;
            }
        }
    }

    @Override
    public synchronized void addCallListener(CallListener listener) {
        this.callListeners = (CallListener[])ArrayUtils.add(CallListener.class, this.callListeners, listener);
    }

    @Override
    public void removeCallListener(CallListener listener) {
        this.callListeners = (CallListener[])ArrayUtils.remove(this.callListeners, listener);
    }

    private static class TagEntry
    implements Comparable<TagEntry> {
        String tag;
        long cycles;
        long lastCycles;
        int calls;

        private TagEntry() {
        }

        @Override
        public int compareTo(TagEntry o) {
            long diff = o.cycles - this.cycles;
            if (diff > 0L) {
                return 1;
            }
            if (diff < 0L) {
                return -1;
            }
            return 0;
        }
    }

    private static class CallEntry {
        MapEntry function;
        long cycles;
        long exclusiveCycles;
        int calls;
        int hide;
        HashMap<MapEntry, Integer> callers = new HashMap();
    }

    private static class CallEntryComparator
    implements Comparator<CallEntry> {
        private int mode;

        public CallEntryComparator(String modeS) {
            this.mode = "exclusive".equalsIgnoreCase(modeS) ? 1 : ("calls".equalsIgnoreCase(modeS) ? 2 : ("average".equalsIgnoreCase(modeS) ? 3 : ("function".equalsIgnoreCase(modeS) ? 4 : 0)));
        }

        @Override
        public int compare(CallEntry o1, CallEntry o2) {
            long diff;
            switch (this.mode) {
                case 1: {
                    diff = o2.exclusiveCycles - o1.exclusiveCycles;
                    break;
                }
                case 2: {
                    diff = o2.calls - o1.calls;
                    break;
                }
                case 3: {
                    diff = (o2.calls > 0 ? o2.cycles / (long)o2.calls : 0L) - (o1.calls > 0 ? o1.cycles / (long)o1.calls : 0L);
                    break;
                }
                case 4: {
                    return o1.function.getName().compareTo(o2.function.getName());
                }
                default: {
                    diff = o2.cycles - o1.cycles;
                }
            }
            if (diff > 0L) {
                return 1;
            }
            if (diff < 0L) {
                return -1;
            }
            return 0;
        }
    }
}

