/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.util;

import se.sics.mspsim.util.ConfigManager;

public class PrefixConfigManager
extends ConfigManager {
    private final ConfigManager config;
    private final String shortPrefix;
    private final String longPrefix;

    public PrefixConfigManager(ConfigManager config, String prefix, String name) {
        this(config, prefix, name, '.');
    }

    public PrefixConfigManager(ConfigManager config, String prefix, String name, char separator) {
        if (config == null) {
            throw new NullPointerException();
        }
        this.config = config;
        String string = prefix = prefix != null && prefix.length() > 0 ? prefix + separator : null;
        if (name != null && name.length() > 0) {
            this.longPrefix = prefix == null ? name + separator : prefix + name + separator;
            this.shortPrefix = prefix;
        } else if (prefix != null) {
            this.longPrefix = prefix;
            this.shortPrefix = null;
        } else {
            this.longPrefix = "";
            this.shortPrefix = null;
        }
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        String value = this.config.getProperty(this.longPrefix + name);
        if (value != null) {
            return value;
        }
        if (this.shortPrefix == null) {
            return defaultValue;
        }
        return this.config.getProperty(this.shortPrefix + name, defaultValue);
    }

    @Override
    public void setProperty(String name, String value) {
        this.config.setProperty(this.longPrefix + name, value);
    }
}

