/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import se.sics.mspsim.util.ActiveComponent;
import se.sics.mspsim.util.ComponentRegistry;
import se.sics.mspsim.util.PluginBundle;

public class PluginRepository
implements ActiveComponent {
    private URLClassLoader classLoader;

    @Override
    public void init(String name, ComponentRegistry registry) {
        File[] files;
        File dir = new File("plugins");
        if (dir.isDirectory() && (files = dir.listFiles(new JarFilter())) != null) {
            try {
                int i;
                URL[] jarFiles = new URL[files.length];
                String[] plugins = new String[files.length];
                int pluginCount = 0;
                int n = files.length;
                for (i = 0; i < n; ++i) {
                    URL jarURL = files[i].toURI().toURL();
                    JarFile jarFile = new JarFile(files[i]);
                    Manifest mf = jarFile.getManifest();
                    Attributes attr = mf.getMainAttributes();
                    String pluginBundle = attr.getValue("mspsim-plugin");
                    if (pluginBundle != null) {
                        plugins[pluginCount++] = pluginBundle;
                    }
                    jarFiles[i] = jarURL;
                }
                this.classLoader = URLClassLoader.newInstance(jarFiles);
                for (i = 0; i < pluginCount; ++i) {
                    try {
                        PluginBundle bundle = (PluginBundle)this.classLoader.loadClass(plugins[i]).newInstance();
                        bundle.init(registry);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.classLoader == null) {
            return Class.forName(name);
        }
        return this.classLoader.loadClass(name);
    }

    @Override
    public void start() {
    }

    private static class JarFilter
    implements FileFilter {
        private JarFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isFile() && f.canRead()) {
                String name = f.getName().toLowerCase();
                return name.endsWith(".jar");
            }
            return false;
        }
    }
}

