/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.util;

import java.io.PrintStream;
import java.util.HashMap;
import se.sics.mspsim.core.Chip;
import se.sics.mspsim.core.MSP430Core;
import se.sics.mspsim.core.OperatingModeListener;
import se.sics.mspsim.util.DataSource;
import se.sics.mspsim.util.MultiDataSource;

public class OperatingModeStatistics {
    public static final int OP_NORMAL = 0;
    public static final int OP_INVERT = 1;
    private MSP430Core cpu;
    private HashMap<String, StatEntry> statistics = new HashMap();

    public OperatingModeStatistics(MSP430Core cpu) {
        this.cpu = cpu;
    }

    public Chip getChip(String chipName) {
        StatEntry entry = this.statistics.get(chipName);
        return entry == null ? null : entry.chip;
    }

    public Chip[] getChips() {
        Chip[] chips = new Chip[this.statistics.size()];
        int index = 0;
        for (StatEntry entry : this.statistics.values()) {
            chips[index++] = entry.chip;
        }
        return chips;
    }

    public void addMonitor(Chip chip) {
        StatEntry entry = new StatEntry(chip);
        this.statistics.put(chip.getName(), entry);
    }

    public void printStat() {
        for (StatEntry entry : this.statistics.values()) {
            entry.printStat(System.out);
        }
    }

    public DataSource getDataSource(String chip, int mode) {
        return this.getDataSource(chip, mode, 0);
    }

    public DataSource getDataSource(String chip, String modeStr) {
        int mode;
        StatEntry se = this.statistics.get(chip);
        if (se != null && (mode = se.chip.getModeByName(modeStr)) != -1) {
            return new StatDataSource(se, mode, 0);
        }
        return null;
    }

    public DataSource getDataSource(String chip, int mode, int operation) {
        StatEntry se = this.statistics.get(chip);
        if (se != null) {
            return new StatDataSource(se, mode, operation);
        }
        return null;
    }

    public MultiDataSource getMultiDataSource(String chip) {
        StatEntry se = this.statistics.get(chip);
        if (se != null) {
            return new StatMultiDataSource(se);
        }
        return null;
    }

    private class StatEntry
    implements OperatingModeListener {
        final Chip chip;
        long startTime;
        int mode;
        long[] elapsed;

        StatEntry(Chip chip) {
            this.chip = chip;
            this.elapsed = new long[chip.getModeMax() + 1];
            this.mode = chip.getMode();
            this.startTime = ((OperatingModeStatistics)OperatingModeStatistics.this).cpu.cycles;
            chip.addOperatingModeListener(this);
        }

        long getValue(int mode, long cycles) {
            if (mode == this.mode) {
                return this.elapsed[mode] + (cycles - this.startTime);
            }
            return this.elapsed[mode];
        }

        @Override
        public void modeChanged(Chip source, int mode) {
            int n = this.mode;
            this.elapsed[n] = this.elapsed[n] + (((OperatingModeStatistics)OperatingModeStatistics.this).cpu.cycles - this.startTime);
            this.mode = mode;
            this.startTime = ((OperatingModeStatistics)OperatingModeStatistics.this).cpu.cycles;
        }

        void printStat(PrintStream out) {
            out.println("Stat for: " + this.chip.getName());
            for (int i = 0; i < this.elapsed.length; ++i) {
                out.println("" + (i + 1) + " = " + this.elapsed[i]);
            }
        }
    }

    private class StatMultiDataSource
    implements MultiDataSource {
        private final StatEntry entry;
        private long[] lastValue;
        private long[] lastCycles;

        public StatMultiDataSource(StatEntry entry) {
            this.entry = entry;
            this.lastValue = new long[entry.elapsed.length];
            this.lastCycles = new long[entry.elapsed.length];
            long cycles = ((OperatingModeStatistics)OperatingModeStatistics.this).cpu.cycles;
            int n = this.lastValue.length;
            for (int i = 0; i < n; ++i) {
                this.lastValue[i] = entry.getValue(i, cycles);
                this.lastCycles[i] = cycles;
            }
        }

        @Override
        public int getModeMax() {
            return this.entry.chip.getModeMax();
        }

        @Override
        public int getValue(int mode) {
            return (int)this.getDoubleValue(mode);
        }

        @Override
        public double getDoubleValue(int mode) {
            long diff = ((OperatingModeStatistics)OperatingModeStatistics.this).cpu.cycles - this.lastCycles[mode];
            if (diff == 0L) {
                return 0.0;
            }
            long val = this.entry.getValue(mode, ((OperatingModeStatistics)OperatingModeStatistics.this).cpu.cycles);
            long valDiff = val - this.lastValue[mode];
            this.lastValue[mode] = val;
            this.lastCycles[mode] = ((OperatingModeStatistics)OperatingModeStatistics.this).cpu.cycles;
            return 100.0 * (double)valDiff / (double)diff;
        }
    }

    private class StatDataSource
    implements DataSource {
        private final StatEntry entry;
        private final int mode;
        private final int operation;
        private long lastCycles;
        private long lastValue;

        public StatDataSource(StatEntry entry, int mode, int operation) {
            this.entry = entry;
            this.mode = mode;
            this.operation = operation;
            this.lastCycles = ((OperatingModeStatistics)OperatingModeStatistics.this).cpu.cycles;
            this.lastValue = entry.getValue(mode, this.lastCycles);
        }

        @Override
        public double getDoubleValue() {
            long diff = ((OperatingModeStatistics)OperatingModeStatistics.this).cpu.cycles - this.lastCycles;
            if (diff == 0L) {
                return 0.0;
            }
            long val = this.entry.getValue(this.mode, ((OperatingModeStatistics)OperatingModeStatistics.this).cpu.cycles);
            long valDiff = val - this.lastValue;
            this.lastValue = val;
            this.lastCycles = ((OperatingModeStatistics)OperatingModeStatistics.this).cpu.cycles;
            if (this.operation == 1) {
                return 100.0 - 100.0 * (double)valDiff / (double)diff;
            }
            return 100.0 * (double)valDiff / (double)diff;
        }

        @Override
        public int getValue() {
            return (int)this.getDoubleValue();
        }
    }
}

