/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.util;

import java.util.Enumeration;
import java.util.Hashtable;

public class NetworkPacket {
    byte[] data;
    String description;
    public static final String IPv6 = "version:4=6|trafficClass:8|flowLabel:20|payloadLength:16|nextHeader:8|hopLimit:8|sourceAddress:128|destinationAddress:128";
    Hashtable<String, Field> fields = new Hashtable();

    public NetworkPacket(String pattern) {
        this.description = pattern;
        String[] parts = this.description.split("\\|");
        int pos = 0;
        for (int i = 0; i < parts.length; ++i) {
            String[] field = parts[i].split(":");
            String val = field[1];
            String matchVal = null;
            if (val.indexOf(61) > 0) {
                String[] match = val.split("=");
                val = match[0];
                matchVal = match[1];
            }
            int size = Integer.parseInt(val);
            Field f = new Field(field[0], pos, size);
            if (matchVal != null) {
                int mask = Integer.parseInt(matchVal);
                f.setMatchMask(mask, mask);
            }
            pos += size;
            System.out.println("Adding field: " + f);
            this.fields.put(f.name, f);
        }
    }

    NetworkPacket(String pattern, Hashtable<String, Field> fields) {
        this.description = pattern;
        this.fields = fields;
    }

    public boolean matches(byte[] data) {
        Enumeration<Field> iterator = this.fields.elements();
        while (iterator.hasMoreElements()) {
            Field f = iterator.nextElement();
            if (f.mask == 0) continue;
            int val = NetworkPacket.getIntBits(data, f.pos, f.pos + f.size - 1);
            if ((val & f.mask) != f.value) {
                return false;
            }
            System.out.println("Field: " + f.name + " matches");
        }
        return true;
    }

    public NetworkPacket parseData(byte[] data) {
        if (this.matches(data)) {
            NetworkPacket np = new NetworkPacket(this.description, this.fields);
            np.data = data;
            return np;
        }
        return null;
    }

    public int getLength() {
        return this.data.length;
    }

    public static int getIntBits(byte[] data, int startBit, int endBit) {
        int startByte = startBit >> 8;
        int endByte = endBit >> 8;
        startBit &= 7;
        endBit &= 7;
        int result = 0;
        for (int i = startByte; i < endByte + 1; ++i) {
            int bt = data[i] & 0xFF;
            if (i == startByte) {
                bt >>= startBit;
            }
            if (i == endByte) {
                bt >>= 7 - endBit;
            }
            result = result << 8 | bt;
        }
        return result;
    }

    public int getInt(String field) {
        Field f = this.fields.get(field);
        return NetworkPacket.getIntBits(this.data, f.pos, f.pos + f.size - 1);
    }

    public static void main(String[] args) {
        byte[] data = new byte[]{97, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        NetworkPacket np = new NetworkPacket(IPv6);
        np = np.parseData(data);
        System.out.println("Version: " + NetworkPacket.getIntBits(np.data, 0, 3));
        System.out.println("Version: " + np.getInt("version"));
    }

    private static class Field {
        String name;
        int pos;
        int size;
        int mask = 0;
        int value = 0;

        Field(String name, int pos, int size) {
            this.name = name;
            this.pos = pos;
            this.size = size;
        }

        public void setMatchMask(int mask, int value) {
            this.mask = mask;
            this.value = value;
        }

        public String toString() {
            return this.name + ":" + this.pos + "-" + (this.pos + this.size - 1) + (this.mask != 0 ? "=" + this.value : "");
        }
    }
}

