/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import se.sics.mspsim.chip.PacketListener;
import se.sics.mspsim.util.ArrayUtils;
import se.sics.mspsim.util.Utils;

public class NetworkConnection
implements Runnable {
    private static final boolean DEBUG = false;
    private static final int DEFAULT_PORT = 4711;
    private ServerSocket serverSocket = null;
    private SendThread sendThread = null;
    private ConnectionThread[] connections = null;
    private PacketListener listener;

    public NetworkConnection() {
        if (this.connect(4711)) {
            System.out.println("NetworkConnection: Connected to network...");
        } else {
            this.setupServer(4711);
            System.out.println("NetworkConnection: Setup network server...");
        }
        this.sendThread = new SendThread();
    }

    public void addPacketListener(PacketListener pl) {
        this.listener = pl;
    }

    private void setupServer(int port) {
        try {
            this.serverSocket = new ServerSocket(port);
            new Thread(this).start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        System.out.println("NetworkConnection: Accepting new connections...");
        while (true) {
            try {
                while (true) {
                    Socket s = this.serverSocket.accept();
                    this.connections = (ConnectionThread[])ArrayUtils.add(ConnectionThread.class, this.connections, new ConnectionThread(s));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void dataReceived(byte[] data, ConnectionThread source) {
        if (this.listener != null) {
            this.listener.transmissionStarted();
            this.listener.transmissionEnded(data);
        }
        if (this.serverSocket != null) {
            this.dataSent(data, source);
        }
    }

    public void dataSent(byte[] receivedData) {
        this.dataSent(receivedData, null);
    }

    public void dataSent(byte[] receivedData, ConnectionThread source) {
        if (this.connections != null && this.sendThread != null) {
            this.sendThread.send(receivedData, source);
        }
    }

    private void printPacket(String prefix, byte[] data) {
        System.out.print("NetworkConnection: " + prefix);
        int len = data.length;
        for (int i = 0; i < len; ++i) {
            System.out.print(' ' + Utils.hex8(data[i]));
        }
        System.out.println();
    }

    private boolean connect(int port) {
        try {
            Socket socket = new Socket("127.0.0.1", port);
            this.connections = (ConnectionThread[])ArrayUtils.add(ConnectionThread.class, this.connections, new ConnectionThread(socket));
        }
        catch (UnknownHostException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    static /* synthetic */ ConnectionThread[] access$002(NetworkConnection x0, ConnectionThread[] x1) {
        x0.connections = x1;
        return x1;
    }

    class ConnectionThread
    implements Runnable {
        Socket socket;
        DataInputStream input;
        OutputStream output;

        public ConnectionThread(Socket socket) throws IOException {
            this.socket = socket;
            this.input = new DataInputStream(socket.getInputStream());
            this.output = socket.getOutputStream();
            new Thread(this).start();
        }

        public void close() {
            try {
                this.input.close();
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.socket = null;
        }

        public boolean isClosed() {
            return this.socket == null;
        }

        @Override
        public void run() {
            try {
                while (this.socket != null) {
                    int len = this.input.read();
                    if (len <= 0) continue;
                    byte[] buffer = new byte[len + 1];
                    buffer[0] = (byte)(len & 0xFF);
                    this.input.readFully(buffer, 1, len);
                    NetworkConnection.this.dataReceived(buffer, this);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.close();
            }
        }
    }

    class SendThread
    implements Runnable {
        private ArrayList<SendEvent> queue = new ArrayList();

        public SendThread() {
            new Thread(this).start();
        }

        public synchronized void send(byte[] receivedData, ConnectionThread source) {
            this.queue.add(new SendEvent(receivedData, source));
            this.notifyAll();
        }

        public synchronized SendEvent getNext() throws InterruptedException {
            while (this.queue.isEmpty()) {
                this.wait();
            }
            return this.queue.remove(0);
        }

        private void sendPacket(SendEvent event) {
            ConnectionThread[] cthr = NetworkConnection.this.connections;
            if (cthr != null) {
                for (int i = 0; i < cthr.length; ++i) {
                    if (cthr[i].isClosed()) {
                        NetworkConnection.access$002(NetworkConnection.this, (ConnectionThread[])ArrayUtils.remove(NetworkConnection.this.connections, cthr[i]));
                        continue;
                    }
                    if (cthr[i] == event.source) continue;
                    try {
                        cthr[i].output.write(event.data, 0, event.data.length);
                        cthr[i].output.flush();
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        cthr[i].close();
                    }
                }
            }
        }

        @Override
        public void run() {
            try {
                SendEvent event;
                do {
                    if ((event = this.getNext()) == null) continue;
                    this.sendPacket(event);
                } while (event != null);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private static class SendEvent {
        public final byte[] data;
        public final ConnectionThread source;

        public SendEvent(byte[] data, ConnectionThread source) {
            this.data = data;
            this.source = source;
        }
    }
}

