/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import se.sics.mspsim.util.MapEntry;

public class MapTable {
    private static final boolean DEBUG = false;
    private Mode mode;
    public int heapStartAddress = -1;
    public int stackStartAddress = -1;
    private int bssFill = 0;
    private int dataFill = 0;
    private ArrayList<MapEntry> modules = new ArrayList();
    private MapEntry[] entries;

    public MapTable() {
    }

    public MapTable(String file) throws IOException {
        this.loadMap(file);
    }

    private MapEntry getModuleEntry(HashMap<String, MapEntry> moduleTable, int addr, int size, String name) {
        MapEntry entry = moduleTable.get(name);
        if (entry == null) {
            entry = new MapEntry(MapEntry.TYPE.module, addr, size, name, null, false);
            moduleTable.put(name, entry);
            this.modules.add(entry);
        } else if (size > 0) {
            entry.setSize(entry.getSize() + size);
        }
        return entry;
    }

    private void parseMapLine(HashMap<String, MapEntry> moduleTable, String line) {
        String[] parts = line.split("\\s+");
        if (line.startsWith(".text")) {
            this.mode = Mode.CODE;
        } else if (line.startsWith(".bss")) {
            this.mode = Mode.BSS;
        } else if (line.startsWith(".data")) {
            this.mode = Mode.DATA;
        } else if (line.startsWith(" .text") || line.startsWith(" .init") || line.startsWith(" .vectors")) {
            if (parts.length > 3) {
                int addr = Integer.parseInt(parts[2].substring(2), 16);
                int size = Integer.parseInt(parts[3].substring(2), 16);
                MapEntry entry = this.getModuleEntry(moduleTable, addr, size, parts[4]);
            }
        } else if (line.startsWith(" .data")) {
            if (parts.length > 3) {
                int addr = Integer.parseInt(parts[2].substring(2), 16);
                int size = Integer.parseInt(parts[3].substring(2), 16);
                MapEntry entry = this.getModuleEntry(moduleTable, addr, 0, parts[4]);
                entry.setData(addr, size);
            }
        } else if (line.startsWith(" .bss") || line.startsWith(" COMMON")) {
            if (parts.length > 3) {
                int addr = Integer.parseInt(parts[2].substring(2), 16);
                int size = Integer.parseInt(parts[3].substring(2), 16);
                MapEntry entry = this.getModuleEntry(moduleTable, addr, 0, parts[4]);
                entry.setBSS(addr, entry.getBSSSize() + size);
            }
        } else if (line.startsWith(" *fill*")) {
            if (parts.length > 3) {
                int size = Integer.parseInt(parts[3].substring(2), 16);
                if (this.mode == Mode.BSS) {
                    this.bssFill += size;
                } else if (this.mode == Mode.DATA) {
                    this.dataFill += size;
                }
            }
        } else if (this.mode == Mode.CODE && line.startsWith("    ")) {
            if (parts.length > 2) {
                int val = Integer.parseInt(parts[1].substring(2), 16);
                this.setEntry(new MapEntry(MapEntry.TYPE.function, val, 0, parts[2], null, false));
            }
        } else if (line.contains(" _end = .") && parts.length > 2) {
            this.heapStartAddress = Integer.parseInt(parts[1].substring(2), 16);
        } else if (line.contains("PROVIDE (__stack") && parts.length > 2) {
            this.stackStartAddress = Integer.parseInt(parts[1].substring(2), 16);
        }
    }

    public void loadMap(String file) throws IOException {
        String line;
        FileInputStream fInput = new FileInputStream(file);
        BufferedReader bInput = new BufferedReader(new InputStreamReader(fInput));
        HashMap<String, MapEntry> moduleTable = new HashMap<String, MapEntry>();
        while ((line = bInput.readLine()) != null) {
            this.parseMapLine(moduleTable, line);
        }
        bInput.close();
        fInput.close();
    }

    public String getFunctionName(int address) {
        if (this.entries != null && this.entries[address] != null) {
            return this.entries[address].getName();
        }
        return null;
    }

    public MapEntry getEntry(int address) {
        if (this.entries != null) {
            return this.entries[address];
        }
        return null;
    }

    public MapEntry[] getAllEntries() {
        ArrayList<MapEntry> allEntries = new ArrayList<MapEntry>();
        if (this.entries != null) {
            for (int address = 0; address < this.entries.length; ++address) {
                MapEntry entry = this.getEntry(address);
                if (entry == null) continue;
                allEntries.add(entry);
            }
        }
        return allEntries.toArray(new MapEntry[allEntries.size()]);
    }

    public MapEntry[] getEntries(String regexp) {
        Pattern pattern = Pattern.compile(regexp);
        ArrayList<MapEntry> allEntries = new ArrayList<MapEntry>();
        if (this.entries != null) {
            for (int address = 0; address < this.entries.length; ++address) {
                MapEntry entry = this.getEntry(address);
                if (entry == null || !pattern.matcher(entry.getName()).find()) continue;
                allEntries.add(entry);
            }
        }
        return allEntries.toArray(new MapEntry[allEntries.size()]);
    }

    public void setFunctionName(int address, String name) {
        this.setEntry(new MapEntry(MapEntry.TYPE.function, address, 0, name, null, false));
    }

    public void setEntry(MapEntry entry) {
        if (this.entries == null) {
            this.entries = new MapEntry[65536];
        }
        if (entry.getAddress() < 65536) {
            this.entries[entry.getAddress()] = entry;
        }
    }

    public int getFunctionAddress(String function) {
        if (this.entries != null) {
            int n = this.entries.length;
            for (int i = 0; i < n; ++i) {
                if (this.entries[i] == null || !function.equals(this.entries[i].getName())) continue;
                return i;
            }
        }
        return -1;
    }

    public void setStackStart(int start) {
        this.stackStartAddress = start;
    }

    public void setHeapStart(int start) {
        this.heapStartAddress = start;
    }

    public static void main(String[] args) throws IOException {
        MapTable map = new MapTable(args[0]);
        int totsize = 0;
        int totdata = map.dataFill;
        int totbss = map.bssFill;
        int totmemory = totdata + totbss;
        System.out.printf("%6s %6s %6s  %4s %s\n", "text", "data", "bss", "addr", "name");
        for (int i = 0; i < map.modules.size(); ++i) {
            MapEntry module = map.modules.get(i);
            totsize += module.getSize();
            totdata += module.getDataSize();
            totbss += module.getBSSSize();
            totmemory += module.getDataSize() + module.getBSSSize();
            System.out.printf("%7d %7d %7d $%04x %s\n", module.getSize(), module.getDataSize(), module.getBSSSize(), module.getAddress(), module.getName());
        }
        System.out.printf("%7d %7d %7d       Total Size\n", totsize, totdata, totbss);
    }

    private static enum Mode {
        NONE,
        CODE,
        DATA,
        BSS;

    }
}

