/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.util;

import se.sics.mspsim.util.Utils;

public class MapEntry {
    private TYPE type;
    private int address;
    private int size;
    private String name;
    private String file;
    private boolean isLocal;
    private int dataAddr;
    private int dataSize;
    private int bssAddr;
    private int bssSize;

    public MapEntry(TYPE type, int address, int size, String name, String file, boolean isLocal) {
        this.type = type;
        this.address = address;
        this.name = name;
        this.file = file;
        this.isLocal = isLocal;
        this.size = size;
    }

    void setData(int dataAddr, int dataSize) {
        this.dataAddr = dataAddr;
        this.dataSize = dataSize;
    }

    void setBSS(int bssAddr, int bssSize) {
        this.bssAddr = bssAddr;
        this.bssSize = bssSize;
    }

    void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public int getBSSSize() {
        return this.bssSize;
    }

    public TYPE getType() {
        return this.type;
    }

    public int getAddress() {
        return this.address;
    }

    public String getName() {
        return this.name;
    }

    public String getFile() {
        return this.file;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public String getInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        if (this.file != null) {
            sb.append(" (");
            if (this.isLocal) {
                sb.append("local in ");
            }
            sb.append(this.file).append(')');
        } else if (this.isLocal) {
            sb.append(" (local)");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('$').append(Utils.hex16(this.address)).append(' ').append((Object)this.type).append(' ').append(this.name);
        if (this.file != null) {
            sb.append(" (");
            if (this.isLocal) {
                sb.append("local in ");
            }
            sb.append(this.file).append(')');
        } else if (this.isLocal) {
            sb.append(" (local)");
        }
        return sb.toString();
    }

    public static enum TYPE {
        function,
        variable,
        module;

    }
}

