/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import se.sics.mspsim.core.MSP430;
import se.sics.mspsim.util.ComponentRegistry;

public class IHexReader {
    private int[] tmpMemory = new int[65536];

    public boolean readFile(int[] memory, String file) {
        int n = this.tmpMemory.length;
        for (int i = 0; i < n; ++i) {
            this.tmpMemory[i] = -1;
        }
        try {
            String line;
            FileInputStream fInput = new FileInputStream(file);
            BufferedReader bInput = new BufferedReader(new InputStreamReader(fInput));
            boolean terminate = false;
            while ((line = bInput.readLine()) != null && !terminate) {
                if (line.charAt(0) != ':') {
                    System.out.println("Not an IHex file?! " + line.charAt(0));
                    return false;
                }
                int size = IHexReader.hexToInt(line.charAt(1)) * 16 + IHexReader.hexToInt(line.charAt(2));
                int adr = IHexReader.hexToInt(line.charAt(3)) * 4096 + IHexReader.hexToInt(line.charAt(4)) * 256 + IHexReader.hexToInt(line.charAt(5)) * 16 + IHexReader.hexToInt(line.charAt(6));
                int type = IHexReader.hexToInt(line.charAt(7)) * 16 + IHexReader.hexToInt(line.charAt(8));
                if (type == 1) {
                    System.out.println("IHEX file ended (termination)");
                    terminate = true;
                    continue;
                }
                int index = 9;
                int n2 = size;
                for (int i = 0; i < n2; ++i) {
                    this.tmpMemory[adr + i] = IHexReader.hexToInt(line.charAt(index++)) * 16 + IHexReader.hexToInt(line.charAt(index++));
                }
                int checksum = (byte)IHexReader.hexToInt(line.charAt(index++)) * 16 + IHexReader.hexToInt(line.charAt(index++));
            }
            System.out.println("Writing to memory!");
            int n3 = this.tmpMemory.length;
            for (int i = 0; i < n3; ++i) {
                if (this.tmpMemory[i] == -1) continue;
                memory[i] = this.tmpMemory[i];
            }
            return true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
    }

    private static String binary(int data) {
        return Integer.toString(data, 2);
    }

    private static String hex(int data) {
        return Integer.toString(data, 16);
    }

    private static int hexToInt(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        return c - 65 + 10;
    }

    public static void main(String[] args) throws Exception {
        IHexReader reader = new IHexReader();
        int data = 132;
        System.out.println("RRA: " + IHexReader.hex((data & 0x80) + (data >> 1)));
        MSP430 cpu = new MSP430(0, new ComponentRegistry());
        int[] memory = cpu.getMemory();
        reader.readFile(memory, args[0]);
        cpu.reset();
        cpu.cpuloop();
    }
}

