/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.util;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import se.sics.mspsim.core.EmulationException;
import se.sics.mspsim.core.MSP430Core;
import se.sics.mspsim.util.Utils;

public class GDBStubs
implements Runnable {
    private static final String OK = "OK";
    ServerSocket serverSocket;
    OutputStream output;
    MSP430Core cpu;
    int[] buffer = new int[256];
    int len;

    public void setupServer(MSP430Core cpu, int port) {
        this.cpu = cpu;
        try {
            this.serverSocket = new ServerSocket(port);
            System.out.println("GDBStubs open server socket port: " + port);
            new Thread(this).start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                block4: while (true) {
                    Socket s = this.serverSocket.accept();
                    DataInputStream input = new DataInputStream(s.getInputStream());
                    this.output = s.getOutputStream();
                    String cmd = "";
                    boolean readCmd = false;
                    while (true) {
                        int c;
                        if (s == null || (c = input.read()) == -1) continue block4;
                        System.out.println("GDBStubs: Read  " + c + " => " + (char)c);
                        if (c == 35) {
                            readCmd = false;
                            this.output.write(43);
                            this.handleCmd(cmd, this.buffer, this.len);
                            cmd = "";
                            this.len = 0;
                        }
                        if (readCmd) {
                            cmd = cmd + (char)c;
                            this.buffer[this.len++] = c & 0xFF;
                        }
                        if (c != 36) continue;
                        readCmd = true;
                    }
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            catch (EmulationException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void handleCmd(String cmd, int[] cmdBytes, int cmdLen) throws IOException, EmulationException {
        System.out.println("cmd: " + cmd);
        char c = cmd.charAt(0);
        switch (c) {
            case 'H': {
                this.sendResponse(OK);
                break;
            }
            case 'q': {
                if ("qC".equals(cmd)) {
                    this.sendResponse("QC1");
                    break;
                }
                if (!"qOffsets".equals(cmd)) break;
                this.sendResponse("Text=000;Data=000;Bss=000;");
                break;
            }
            case '?': {
                this.sendResponse("S01");
                break;
            }
            case 'g': {
                this.readRegisters();
                break;
            }
            case 'k': {
                this.sendResponse(OK);
                break;
            }
            case 'M': 
            case 'X': 
            case 'm': {
                String cmd2 = cmd.substring(1);
                String[] wdata = cmd2.split(":");
                int cPos = cmd.indexOf(58);
                if (cPos > 0) {
                    cmd2 = wdata[0];
                }
                String[] parts = cmd2.split(",");
                int addr = Integer.decode("0x" + parts[0]);
                int len = Integer.decode("0x" + parts[1]);
                String data = "";
                if (c == 'm') {
                    System.out.println("Returning memory from: " + addr + " len = " + len);
                    for (int i = 0; i < len; ++i) {
                        data = data + Utils.hex8(this.cpu.memory[addr++] & 0xFF);
                    }
                    this.sendResponse(data);
                    break;
                }
                System.out.println("Writing to memory at: " + addr + " len = " + len + " with: " + (wdata.length > 1 ? wdata[1] : ""));
                ++cPos;
                for (int i = 0; i < len; ++i) {
                    System.out.println("Writing: " + cmdBytes[cPos] + " to " + addr + " cpos=" + cPos);
                    this.cpu.write(addr++, cmdBytes[cPos++], false);
                }
                this.sendResponse(OK);
            }
        }
    }

    private void readRegisters() throws IOException {
        String regs = "";
        for (int i = 0; i < 16; ++i) {
            regs = regs + Utils.hex8(this.cpu.reg[i] & 0xFF) + Utils.hex8(this.cpu.reg[i] >> 8);
        }
        this.sendResponse(regs);
    }

    public void sendResponse(String resp) throws IOException {
        this.output.write(36);
        int cs = 0;
        if (resp != null) {
            for (int i = 0; i < resp.length(); ++i) {
                this.output.write(resp.charAt(i));
                System.out.print(resp.charAt(i));
                cs += resp.charAt(i);
            }
        }
        this.output.write(35);
        System.out.print('#');
        int c = (cs & 0xFF) >> 4;
        c = c < 10 ? (c += 48) : c - 10 + 97;
        this.output.write((char)c);
        System.out.print((char)c);
        c = cs & 0xF;
        c = c < 10 ? (c += 48) : c - 10 + 97;
        this.output.write((char)c);
        System.out.println((char)c);
    }
}

