/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.util;

import se.sics.mspsim.util.ELF;

public class ELFSection {
    public static final int TYPE_NULL = 0;
    public static final int TYPE_PROGBITS = 1;
    public static final int TYPE_SYMTAB = 2;
    public static final int TYPE_STRTAB = 3;
    public static final int TYPE_RELA = 4;
    public static final int TYPE_HASH = 5;
    public static final int TYPE_DYNAMIC = 6;
    public static final int TYPE_NOTE = 7;
    public static final int TYPE_NOBITS = 8;
    public static final int TYPE_REL = 9;
    public static final int TYPE_SHLIB = 10;
    public static final int TYPE_DYNSYM = 11;
    public static final int SYMBIND_LOCAL = 0;
    public static final int SYMBIND_GLOBAL = 1;
    public static final int SYMBIND_WEAK = 2;
    public static final int SYMTYPE_NONE = 0;
    public static final int SYMTYPE_OBJECT = 1;
    public static final int SYMTYPE_FUNCTION = 2;
    public static final int SYMTYPE_SECTION = 3;
    public static final int SYMTYPE_FILE = 4;
    public static final String[] typeNames = new String[]{"null", "progbits", "symtab", "strtab", "rela", "hash", "dynamic", "note", "nobits", "rel", "shlib", "dynsym"};
    public static final String[] symTypeNames = new String[]{"none", "object", "function", "section", "file"};
    int name;
    int type;
    int flags;
    int addr;
    int offset;
    int size;
    int link;
    int info;
    int addralign;
    int entSize;
    ELF elf;

    public String getSectionName() {
        if (this.elf.strTable != null) {
            return this.elf.strTable.getName(this.name);
        }
        return Integer.toString(this.name, 16);
    }

    public String getName(int i) {
        char c;
        int pos = this.offset + i;
        StringBuffer sb = new StringBuffer();
        while ((c = (char)this.elf.elfData[pos++]) != '\u0000') {
            sb.append(c);
        }
        return sb.toString();
    }

    public String toString() {
        String nameStr = this.getSectionName();
        return "name: " + nameStr + "\ntype: " + Integer.toString(this.type, 16) + (this.type <= 11 ? " " + typeNames[this.type] : "") + "\nflags: " + Integer.toString(this.flags, 16) + "\naddr: " + Integer.toString(this.addr, 16) + "\noffset: " + Integer.toString(this.offset, 16) + "\nsize: " + Integer.toString(this.size, 16) + "\nlink: " + Integer.toString(this.link, 16) + "\ninfo: " + Integer.toString(this.info, 16);
    }
}

