/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.util;

import java.util.ArrayList;
import se.sics.mspsim.util.DebugInfo;
import se.sics.mspsim.util.ELF;
import se.sics.mspsim.util.ELFSection;

public class ELFDebug {
    private Stab[] stabs;
    public static final int N_FUN = 36;
    public static final int N_SLINE = 68;
    public static final int N_SO = 100;
    public static final boolean DEBUG = false;
    ELFSection dbgStab;
    ELFSection dbgStabStr;

    public ELFDebug(ELF elf, ELFSection stab, ELFSection stabstr) {
        this.dbgStab = stab;
        this.dbgStabStr = stabstr;
        int len = this.dbgStab.size;
        int count = len / this.dbgStab.entSize;
        int addr = this.dbgStab.offset;
        this.stabs = new Stab[count];
        int n = count;
        for (int i = 0; i < n; ++i) {
            elf.pos = addr;
            int nI = elf.readElf32();
            String stabData = elf.dbgStabStr.getName(nI);
            int type = elf.readElf8();
            int other = elf.readElf8();
            int desc = elf.readElf16();
            int value = elf.readElf32();
            this.stabs[i] = new Stab(stabData, type, other, desc, value);
            addr += this.dbgStab.entSize;
        }
    }

    public DebugInfo getDebugInfo(int address) {
        String currentPath = null;
        String currentFile = null;
        String currentFunction = null;
        int lastAddress = 0;
        int currentLine = 0;
        int currentLineAdr = 0;
        block5: for (Stab stab : this.stabs) {
            switch (stab.type) {
                case 100: {
                    if (stab.value < address) {
                        if (stab.data != null && stab.data.endsWith("/")) {
                            currentPath = stab.data;
                            lastAddress = stab.value;
                            currentFunction = null;
                            continue block5;
                        }
                        currentFile = stab.data;
                        lastAddress = stab.value;
                        currentFunction = null;
                        continue block5;
                    }
                    return null;
                }
                case 68: {
                    if (currentPath == null || currentLineAdr >= address) continue block5;
                    currentLine = stab.desc;
                    currentLineAdr = lastAddress + stab.value;
                    if (currentLineAdr < address) continue block5;
                    return new DebugInfo(currentLine, currentPath, currentFile, currentFunction);
                }
                case 36: {
                    if (stab.value < address) {
                        currentFunction = stab.data;
                        lastAddress = stab.value;
                        continue block5;
                    }
                    return null;
                }
            }
        }
        return null;
    }

    public ArrayList<Integer> getExecutableAddresses() {
        ArrayList<Integer> allAddresses = new ArrayList<Integer>();
        int address = Integer.MAX_VALUE;
        String currentPath = null;
        String currentFile = null;
        String currentFunction = null;
        int lastAddress = 0;
        int currentLine = 0;
        int currentLineAdr = 0;
        block5: for (Stab stab : this.stabs) {
            switch (stab.type) {
                case 100: {
                    if (stab.value < address) {
                        if (stab.data != null && stab.data.endsWith("/")) {
                            currentPath = stab.data;
                            lastAddress = stab.value;
                            allAddresses.add(new Integer(lastAddress));
                            currentFunction = null;
                            continue block5;
                        }
                        currentFile = stab.data;
                        lastAddress = stab.value;
                        allAddresses.add(new Integer(lastAddress));
                        currentFunction = null;
                        continue block5;
                    }
                    return allAddresses;
                }
                case 68: {
                    if (currentPath == null || currentLineAdr >= address) continue block5;
                    currentLine = stab.desc;
                    currentLineAdr = lastAddress + stab.value;
                    allAddresses.add(new Integer(currentLineAdr));
                    continue block5;
                }
                case 36: {
                    if (stab.value < address) {
                        currentFunction = stab.data;
                        lastAddress = stab.value;
                        allAddresses.add(new Integer(lastAddress));
                        continue block5;
                    }
                    return allAddresses;
                }
            }
        }
        return allAddresses;
    }

    public String[] getSourceFiles() {
        String currentPath = null;
        String currentFile = null;
        ArrayList<String> sourceFiles = new ArrayList<String>();
        for (Stab stab : this.stabs) {
            if (stab.type != 100) continue;
            if (stab.data != null && stab.data.endsWith("/")) {
                currentPath = stab.data;
                continue;
            }
            currentFile = stab.data;
            if (currentFile == null || currentFile.length() <= 0) continue;
            if (currentPath == null) {
                sourceFiles.add(currentFile);
                continue;
            }
            sourceFiles.add(currentPath + currentFile);
        }
        String[] sourceFilesArray = new String[sourceFiles.size()];
        for (int i = 0; i < sourceFilesArray.length; ++i) {
            sourceFilesArray[i] = (String)sourceFiles.get(i);
        }
        return sourceFilesArray;
    }

    private static class Stab {
        String data;
        int type;
        int other;
        int desc;
        int value;

        Stab(String data, int type, int other, int desc, int value) {
            this.data = data;
            this.type = type;
            this.other = other;
            this.desc = desc;
            this.value = value;
        }
    }
}

