/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.util;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import se.sics.mspsim.util.DebugInfo;
import se.sics.mspsim.util.ELFDebug;
import se.sics.mspsim.util.ELFException;
import se.sics.mspsim.util.ELFProgram;
import se.sics.mspsim.util.ELFSection;
import se.sics.mspsim.util.MapEntry;
import se.sics.mspsim.util.MapTable;

public class ELF {
    private static final int EI_NIDENT = 16;
    private static final int EI_ENCODING = 5;
    private static final int[] MAGIC = new int[]{127, 69, 76, 70};
    public static final boolean DEBUG = false;
    boolean encMSB = true;
    int type;
    int machine;
    int version;
    int entry;
    int phoff;
    int shoff;
    int flags;
    int ehsize;
    int phentsize;
    int phnum;
    int shentsize;
    int shnum;
    int shstrndx;
    byte[] elfData;
    int pos = 0;
    private ELFSection[] sections;
    private ELFProgram[] programs;
    private ArrayList<FileInfo> files = new ArrayList();
    ELFSection strTable;
    ELFSection symTable;
    ELFSection dbgStab;
    ELFSection dbgStabStr;
    ELFDebug debug;

    public ELF(byte[] data) {
        this.elfData = data;
        this.pos = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isELF(File file) {
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            for (int i = 0; i < MAGIC.length; ++i) {
                if (MAGIC[i] == ((InputStream)input).read()) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (Exception e) {}
            }
        }
        return true;
    }

    private void readHeader() throws ELFException {
        for (int i = 0; i < MAGIC.length; ++i) {
            if (this.elfData[i] == (byte)(MAGIC[i] & 0xFF)) continue;
            throw new ELFException("Not an elf file");
        }
        if (this.elfData[5] == 2) {
            this.encMSB = true;
        } else if (this.elfData[5] == 1) {
            this.encMSB = false;
        } else {
            throw new ELFException("Illegal encoding: " + this.elfData[5]);
        }
        this.pos += 16;
        this.type = this.readElf16();
        this.machine = this.readElf16();
        this.version = this.readElf32();
        this.entry = this.readElf32();
        this.phoff = this.readElf32();
        this.shoff = this.readElf32();
        this.flags = this.readElf32();
        this.ehsize = this.readElf16();
        this.phentsize = this.readElf16();
        this.phnum = this.readElf16();
        this.shentsize = this.readElf16();
        this.shnum = this.readElf16();
        this.shstrndx = this.readElf16();
    }

    private ELFSection readSectionHeader() {
        ELFSection sec = new ELFSection();
        sec.name = this.readElf32();
        sec.type = this.readElf32();
        sec.flags = this.readElf32();
        sec.addr = this.readElf32();
        sec.offset = this.readElf32();
        sec.size = this.readElf32();
        sec.link = this.readElf32();
        sec.info = this.readElf32();
        sec.addralign = this.readElf32();
        sec.entSize = this.readElf32();
        sec.elf = this;
        return sec;
    }

    private ELFProgram readProgramHeader() {
        ELFProgram pHeader = new ELFProgram();
        pHeader.type = this.readElf32();
        pHeader.offset = this.readElf32();
        pHeader.vaddr = this.readElf32();
        pHeader.paddr = this.readElf32();
        pHeader.fileSize = this.readElf32();
        pHeader.memSize = this.readElf32();
        pHeader.flags = this.readElf32();
        pHeader.align = this.readElf32();
        if (this.phentsize > 32) {
            System.out.println("Program Header Entry SIZE differs from specs?!?!??!?!?***");
        }
        return pHeader;
    }

    int readElf32() {
        int b = 0;
        b = this.encMSB ? (this.elfData[this.pos++] & 0xFF) << 24 | (this.elfData[this.pos++] & 0xFF) << 16 | (this.elfData[this.pos++] & 0xFF) << 8 | this.elfData[this.pos++] & 0xFF : this.elfData[this.pos++] & 0xFF | (this.elfData[this.pos++] & 0xFF) << 8 | (this.elfData[this.pos++] & 0xFF) << 16 | (this.elfData[this.pos++] & 0xFF) << 24;
        return b;
    }

    int readElf16() {
        int b = 0;
        b = this.encMSB ? (this.elfData[this.pos++] & 0xFF) << 8 | this.elfData[this.pos++] & 0xFF : this.elfData[this.pos++] & 0xFF | (this.elfData[this.pos++] & 0xFF) << 8;
        return b;
    }

    int readElf8() {
        return this.elfData[this.pos++] & 0xFF;
    }

    public static void printBytes(String name, byte[] data) {
        System.out.print(name + " ");
        for (byte element : data) {
            System.out.print("" + (char)element);
        }
        System.out.println("");
    }

    private void readSections() {
        int i;
        this.pos = this.shoff;
        this.sections = new ELFSection[this.shnum];
        int n = this.shnum;
        for (i = 0; i < n; ++i) {
            this.sections[i] = this.readSectionHeader();
            if (this.sections[i].type == 2) {
                this.symTable = this.sections[i];
            }
            if (i != this.shstrndx) continue;
            this.strTable = this.sections[i];
        }
        n = this.shnum;
        for (i = 0; i < n; ++i) {
            if (".stabstr".equals(this.sections[i].getSectionName())) {
                this.dbgStabStr = this.sections[i];
            }
            if (!".stab".equals(this.sections[i].getSectionName())) continue;
            this.dbgStab = this.sections[i];
        }
    }

    private void readPrograms() {
        this.pos = this.phoff;
        this.programs = new ELFProgram[this.phnum];
        int n = this.phnum;
        for (int i = 0; i < n; ++i) {
            this.programs[i] = this.readProgramHeader();
        }
    }

    public void readAll() throws ELFException {
        this.readHeader();
        this.readPrograms();
        this.readSections();
        if (this.dbgStab != null) {
            this.debug = new ELFDebug(this, this.dbgStab, this.dbgStabStr);
        }
    }

    public void loadPrograms(int[] memory) {
        int n = this.phnum;
        for (int i = 0; i < n; ++i) {
            this.loadBytes(memory, this.programs[i].offset, this.programs[i].paddr, this.programs[i].fileSize, this.programs[i].memSize);
        }
    }

    private void loadBytes(int[] memory, int offset, int addr, int len, int fill) {
        int i;
        int n = len;
        for (i = 0; i < n; ++i) {
            memory[addr++] = this.elfData[offset++] & 0xFF;
        }
        if (fill > len) {
            n = fill - len;
            for (i = 0; i < n; ++i) {
                memory[addr++] = 0;
            }
        }
    }

    public ELFDebug getDebug() {
        return this.debug;
    }

    public DebugInfo getDebugInfo(int adr) {
        return this.debug.getDebugInfo(adr);
    }

    public String lookupFile(int address) {
        for (int i = 0; i < this.files.size(); ++i) {
            FileInfo fi = this.files.get(i);
            if (address < fi.start || address > fi.end) continue;
            return fi.name;
        }
        return null;
    }

    public MapTable getMap() {
        MapTable map = new MapTable();
        ELFSection name = this.sections[this.symTable.link];
        int len = this.symTable.size;
        int count = len / this.symTable.entSize;
        int addr = this.symTable.offset;
        String currentFile = "";
        int currentAddress = 0;
        int n = count;
        for (int i = 0; i < n; ++i) {
            this.pos = addr;
            int nI = this.readElf32();
            String sn = name.getName(nI);
            int sAddr = this.readElf32();
            int size = this.readElf32();
            int info = this.readElf8();
            int bind = info >> 4;
            int type = info & 0xF;
            if (type == 0 && sn != null) {
                if ("Letext".equals(sn)) {
                    if (currentFile != null) {
                        this.files.add(new FileInfo(currentFile, currentAddress, sAddr));
                        currentAddress = sAddr;
                    }
                } else if (!sn.startsWith("_")) {
                    map.setEntry(new MapEntry(MapEntry.TYPE.variable, sAddr, 0, sn, currentFile, false));
                }
            }
            if (type == 4) {
                currentFile = sn;
            }
            if (sAddr > 0 && sAddr < 65536) {
                String file;
                String symbolName = sn;
                if ("_end".equals(symbolName)) {
                    map.setHeapStart(sAddr);
                } else if ("__stack".equals(symbolName)) {
                    map.setStackStart(sAddr);
                }
                if (type == 2) {
                    file = this.lookupFile(sAddr);
                    if (file == null) {
                        file = currentFile;
                    }
                    map.setEntry(new MapEntry(MapEntry.TYPE.function, sAddr, 0, symbolName, file, bind == 0));
                } else if (type == 1) {
                    file = this.lookupFile(sAddr);
                    if (file == null) {
                        file = currentFile;
                    }
                    map.setEntry(new MapEntry(MapEntry.TYPE.variable, sAddr, 0, symbolName, file, bind == 0));
                }
            }
            addr += this.symTable.entSize;
        }
        return map;
    }

    public static ELF readELF(String file) throws IOException {
        int read;
        DataInputStream input = new DataInputStream(new FileInputStream(file));
        ByteArrayOutputStream baous = new ByteArrayOutputStream();
        byte[] buf = new byte[2048];
        while ((read = input.read(buf)) != -1) {
            baous.write(buf, 0, read);
        }
        input.close();
        buf = null;
        byte[] data = baous.toByteArray();
        ELF elf = new ELF(data);
        elf.readAll();
        return elf;
    }

    public static void main(String[] args) throws Exception {
        DebugInfo dbg;
        ELF elf = ELF.readELF(args[0]);
        if (args.length < 2) {
            int n = elf.shnum;
            for (int i = 0; i < n; ++i) {
                if (".stab".equals(elf.sections[i].getSectionName()) || ".stabstr".equals(elf.sections[i].getSectionName())) {
                    int adr = elf.sections[i].offset;
                    int m = 2000;
                    for (int j = 0; j < m; ++j) {
                    }
                }
                System.out.println();
            }
        }
        elf.getMap();
        if (args.length > 1 && (dbg = elf.getDebugInfo(Integer.parseInt(args[1]))) != null) {
            System.out.println("File: " + dbg.getFile());
            System.out.println("Function: " + dbg.getFunction());
            System.out.println("LineNo: " + dbg.getLine());
        }
    }

    class FileInfo {
        String name;
        int start;
        int end;

        FileInfo(String name, int start, int end) {
            this.name = name;
            this.start = start;
            this.end = end;
        }
    }
}

