/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.util;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class DotDiagram
extends JComponent {
    private static final long serialVersionUID = -2284181166518780931L;
    public static final int NORMAL = 0;
    public static final int ADDITIVE = 1;
    public static final int FILLED_ADDITIVE = 2;
    public static final char[] NOTE_CHAR = new char[]{'N'};
    private int[][] data;
    private String[][] notes;
    private Point[][] notesCoords;
    private int[] dataLen;
    private int[] start;
    private int[] maxData;
    private int[] minData;
    private int totMax;
    private int totMin;
    private boolean lockMinMax = false;
    private int maxDataLen;
    private double factor;
    private int[] constantY;
    private Color[] constantColor;
    private int sizeX;
    private int sizeY;
    private int lowerY;
    private double xspace;
    private int ySpacing = 0;
    private boolean rescale = false;
    private boolean gridVisible = false;
    private String yLabel = null;
    private String xLabel = null;
    private boolean isAdditive = false;
    private boolean isFilled = false;
    private Insets insets;
    private Color[] lineColor;

    public DotDiagram(int diagrams) {
        this(diagrams, 0);
    }

    public DotDiagram(int diagrams, int mode) {
        this.data = new int[diagrams][];
        this.notes = new String[diagrams][];
        this.notesCoords = new Point[diagrams][];
        this.lineColor = new Color[diagrams];
        this.dataLen = new int[diagrams];
        this.start = new int[diagrams];
        this.maxData = new int[diagrams];
        this.minData = new int[diagrams];
        for (int i = 0; i < diagrams; ++i) {
            this.lineColor[i] = Color.black;
        }
        this.setOpaque(true);
        this.isFilled = mode == 2;
        this.isAdditive = this.isFilled || mode == 1;
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                for (int i = 0; i < DotDiagram.this.notes.length; ++i) {
                    if (DotDiagram.this.notes[i] == null) continue;
                    for (int j = 0; j < DotDiagram.this.notes[i].length; ++j) {
                        Point nodeCoords;
                        if (DotDiagram.this.notes[i][j] == null || (nodeCoords = DotDiagram.this.notesCoords[i][j]) == null || !(nodeCoords.distance(x, y) < 10.0)) continue;
                        JOptionPane.showMessageDialog(DotDiagram.this, DotDiagram.this.notes[i][j], "Log message", 1);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
    }

    public void setShowGrid(boolean on) {
        this.gridVisible = on;
    }

    public void setGridYSpacing(int spacing) {
        this.ySpacing = spacing;
    }

    public void setYLabel(String yLabel) {
        this.yLabel = yLabel;
    }

    public void setXLabel(String xLabel) {
        this.xLabel = xLabel;
    }

    public void setName(int index, String name) {
    }

    public void setToolTipVisible(boolean showToolTip) {
    }

    public void addConstant(Color color, int y) {
        int index;
        if (this.constantY == null) {
            index = 0;
            this.constantY = new int[1];
            this.constantColor = new Color[1];
        } else {
            index = this.constantY.length;
            int[] tmpY = new int[index + 1];
            Color[] tmpC = new Color[index + 1];
            for (int i = 0; i < index; ++i) {
                tmpY[i] = this.constantY[i];
                tmpC[i] = this.constantColor[i];
            }
            this.constantY = tmpY;
            this.constantColor = tmpC;
        }
        this.constantY[index] = y;
        this.constantColor[index] = color == null ? Color.black : color;
        this.rescale = true;
        this.repaint();
    }

    public void setMinMax(int min, int max) {
        this.totMax = max;
        this.totMin = min;
        this.lockMinMax = true;
        this.rescale = true;
    }

    public void setData(int diag, int[] data, int start, int len) {
        int maxData = Integer.MIN_VALUE;
        int minData = Integer.MAX_VALUE;
        if (len > 0) {
            int totLen = data.length;
            int n = start + len;
            for (int i = start; i < n; ++i) {
                int val = data[i % totLen];
                if (maxData < val) {
                    maxData = val;
                }
                if (minData <= val) continue;
                minData = val;
            }
        }
        if (minData > 0) {
            minData = 0;
        }
        if (maxData < minData) {
            maxData = minData;
        }
        this.dataLen[diag] = len;
        this.start[diag] = start;
        this.data[diag] = data;
        this.maxData[diag] = maxData;
        this.minData[diag] = minData;
        this.rescale = true;
        this.repaint();
    }

    public void setDataWithNotes(int diag, int[] data, String[] notes, int start, int len) {
        this.notes[diag] = notes;
        this.notesCoords[diag] = new Point[notes.length];
        this.setData(diag, data, start, len);
    }

    public void setDotColor(int diag, Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        this.lineColor[diag] = color;
        if (this.dataLen[diag] > 0) {
            this.repaint();
        }
    }

    @Override
    protected void paintComponent(Graphics g0) {
        int i;
        int n;
        Graphics2D g = (Graphics2D)g0;
        FontMetrics fm = g.getFontMetrics();
        int fmHeight = fm.getAscent();
        Color oldColor = g.getColor();
        Insets insets = this.getInsets();
        int width = this.getWidth();
        int height = this.getHeight();
        int leftInset = 2;
        int topInset = 2;
        int yLabelSize = 0;
        if (this.yLabel != null || this.xLabel != null) {
            yLabelSize = fm.stringWidth(this.yLabel);
        }
        if (this.gridVisible) {
            topInset += fmHeight / 2;
            height -= fmHeight / 2;
            leftInset += 40;
        }
        height -= topInset + insets.top + insets.bottom;
        width -= leftInset + insets.left + insets.right;
        g.translate(leftInset + insets.left + 1, topInset + insets.top + 1);
        if (this.isOpaque()) {
            g.setColor(Color.white);
            g.fillRect(0, 0, width, height);
        }
        insets = this.getInsets(insets);
        int reserveX = this.yLabel != null ? 12 * width / 200 : 0;
        int x = insets.left + reserveX;
        int y = insets.top;
        width = width - insets.left - insets.right - reserveX;
        height = height - insets.top - insets.bottom;
        if (this.rescale || width != this.sizeX || height != this.sizeY) {
            if (this.rescale) {
                this.rescale = false;
                this.maxDataLen = 0;
                if (this.lockMinMax) {
                    int n2 = this.data.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        if (this.dataLen[i2] <= this.maxDataLen) continue;
                        this.maxDataLen = this.dataLen[i2];
                    }
                } else {
                    this.totMin = Integer.MAX_VALUE;
                    this.totMax = Integer.MIN_VALUE;
                    if (this.constantY != null) {
                        for (int cy : this.constantY) {
                            if (cy < this.totMin) {
                                this.totMin = cy;
                            }
                            if (cy <= this.totMax) continue;
                            this.totMax = cy;
                        }
                    }
                    int sum = 0;
                    n = this.data.length;
                    for (int i3 = 0; i3 < n; ++i3) {
                        if (this.dataLen[i3] <= 0) continue;
                        int min = this.minData[i3];
                        int max = this.maxData[i3];
                        if (min < this.totMin) {
                            this.totMin = min;
                        }
                        if (max > this.totMax) {
                            this.totMax = max;
                        }
                        if (this.dataLen[i3] > this.maxDataLen) {
                            this.maxDataLen = this.dataLen[i3];
                        }
                        sum += max;
                    }
                    if (this.isAdditive && sum > this.totMax) {
                        this.totMax = sum;
                    }
                    if (this.totMin > 0) {
                        this.totMin = 0;
                    }
                    if (this.totMax < this.totMin) {
                        this.totMax = this.totMin;
                    }
                }
            }
            this.sizeY = height;
            this.sizeX = width - 2;
            this.factor = this.totMax < 0 ? (double)(this.sizeY - 15) / (double)(0 - this.totMin) : (this.totMax == this.totMin ? 1.0 : (double)(this.sizeY - 15) / (double)(this.totMax - this.totMin));
            this.lowerY = this.sizeY - 5;
            this.xspace = this.maxDataLen == 0 ? 1.0 : (double)this.sizeX / (double)this.maxDataLen;
        }
        x += 2;
        int zero = y + this.lowerY - (int)(this.factor * (double)(0 - this.totMin));
        if (this.gridVisible) {
            int tlen;
            String text;
            int dy;
            double d;
            double div;
            g.setColor(Color.lightGray);
            double yfac = 1.0 * (double)height / (double)(this.totMax - this.totMin);
            g.setColor(Color.lightGray);
            g.drawLine(0, zero, width, zero);
            g.setColor(Color.black);
            g.drawString("0", -4 - fm.stringWidth("0"), zero + fmHeight / 2);
            for (d = div = this.getDivider(this.totMin, this.totMax); d < (double)this.totMax; d += div) {
                dy = (int)((double)zero - yfac * d);
                text = "" + (int)d;
                tlen = fm.stringWidth(text);
                g.setColor(Color.lightGray);
                g.drawLine(0, dy, width, dy);
                g.setColor(Color.black);
                g.drawString(text, -4 - tlen, dy + fmHeight / 2);
            }
            for (d = div; d < (double)(-this.totMin); d += div) {
                dy = (int)((double)zero + yfac * d);
                text = "" + (int)(-d);
                tlen = fm.stringWidth(text);
                g.setColor(Color.lightGray);
                g.drawLine(0, dy, width, dy);
                g.setColor(Color.black);
                g.drawString(text, -4 - tlen, dy + fmHeight / 2);
            }
        }
        if (this.isAdditive) {
            if (this.isFilled) {
                int delta = (int)(this.xspace + 1.0);
                int n3 = this.maxDataLen;
                for (int i4 = 0; i4 < n3; ++i4) {
                    int lastY = zero;
                    int m = this.data.length;
                    for (int j = 0; j < m; ++j) {
                        int pos;
                        int[] drawData;
                        int y0;
                        if (this.dataLen[j] <= i4 || (y0 = (int)(this.factor * (double)(drawData = this.data[j])[(pos = this.start[j] + i4) % drawData.length])) <= 0) continue;
                        g.setColor(this.lineColor[j]);
                        g.fillRect(x + (int)((double)i4 * this.xspace), lastY - y0, delta, y0);
                        lastY -= y0;
                    }
                }
            } else {
                n = this.maxDataLen;
                for (i = 0; i < n; ++i) {
                    int lastY = zero;
                    int m = this.data.length;
                    for (int j = 0; j < m; ++j) {
                        int pos;
                        int[] drawData;
                        int y0;
                        if (this.dataLen[j] <= i || (y0 = (int)(this.factor * (double)(drawData = this.data[j])[(pos = this.start[j] + i) % drawData.length])) <= 0) continue;
                        g.setColor(this.lineColor[j]);
                        g.drawLine(x + (int)((double)(i - 1) * this.xspace), lastY - y0, x + (int)((double)i * this.xspace), lastY - y0);
                        lastY -= y0;
                    }
                }
            }
        } else {
            int m = this.data.length;
            for (int j = 0; j < m; ++j) {
                if (this.dataLen[j] <= 0) continue;
                int[] drawData = this.data[j];
                int maxLen = drawData.length;
                int startData = this.start[j];
                int lastY = (int)(this.factor * (double)(drawData[startData % maxLen] - this.totMin));
                g.setColor(this.lineColor[j]);
                int n4 = this.dataLen[j];
                for (int i5 = 1; i5 < n4; ++i5) {
                    int pos = startData + i5;
                    int y0 = (int)(this.factor * (double)(drawData[pos % maxLen] - this.totMin));
                    g.drawLine(x + (int)((double)(i5 - 1) * this.xspace), y + this.lowerY - lastY, x + (int)((double)i5 * this.xspace), y + this.lowerY - y0);
                    lastY = y0;
                }
                g.setColor(Color.BLACK);
                String[] noteData = this.notes[j];
                if (noteData == null) continue;
                int n5 = this.dataLen[j];
                for (int i6 = 1; i6 < n5; ++i6) {
                    int pos = startData + i6;
                    if (noteData[pos % maxLen] == null) continue;
                    int charWidth = g.getFontMetrics().charWidth('N');
                    int charHeight = g.getFontMetrics().getAscent();
                    g.drawChars(NOTE_CHAR, 0, 1, x + (int)((double)i6 * this.xspace) - charWidth / 2, y + charHeight);
                    this.notesCoords[j][pos % maxLen] = new Point(x + (int)((double)i6 * this.xspace) - charWidth / 2, y + charHeight);
                }
            }
        }
        if (this.constantY != null) {
            n = this.constantY.length;
            for (i = 0; i < n; ++i) {
                int cy = y + this.lowerY - (int)(this.factor * (double)(this.constantY[i] - this.totMin));
                g.setColor(this.constantColor[i]);
                g.drawLine(x, cy, x + this.sizeX, cy);
            }
        }
        g.setColor(Color.black);
        g.drawLine(x -= 2, zero, x + this.sizeX, zero);
        g.drawLine(x + 1, y, x + 1, y + this.sizeY - 1);
        if (this.yLabel != null) {
            g.rotate(-1.57075);
            g.scale((double)height / 200.0, (double)width / 200.0);
            g.drawString(this.yLabel, -100 - yLabelSize / 2, 10);
        }
        g.setColor(oldColor);
    }

    private double getDivider(double minY, double maxY) {
        double diff = Math.abs(maxY - minY);
        if (diff >= 1500.0) {
            return 500.0;
        }
        if (diff >= 400.0) {
            return 100.0;
        }
        if (diff >= 80.0) {
            return 20.0;
        }
        if (diff >= 20.0) {
            return 10.0;
        }
        if (diff >= 10.0) {
            return 5.0;
        }
        return 1.0;
    }

    public static void main(String[] args) throws Exception {
        JFrame jf = new JFrame("DotDiagram - Test");
        int[] data = new int[100];
        int[] data2 = new int[100];
        int[] data3 = new int[100];
        boolean neg = true;
        int pos = 100;
        int pos2 = 50;
        int pos3 = 0;
        int s = neg ? -10 : 0;
        for (int i = 0; i < 60; ++i) {
            data[i] = pos += (int)((double)s + 20.0 * Math.random());
            data2[i] = pos2 += (int)((double)s + 20.0 * Math.random());
            data3[i] = pos3 += (int)((double)s + 20.0 * Math.random());
        }
        DotDiagram bd = DotDiagram.setupDiagram(10, data, data2, data3, 0);
        DotDiagram bd2 = DotDiagram.setupDiagram(10, data, data2, data3, 1);
        DotDiagram bd3 = DotDiagram.setupDiagram(10, data, data2, data3, 2);
        jf.setDefaultCloseOperation(3);
        jf.setSize(600, 200);
        jf.getContentPane().setLayout(new GridLayout(0, 3));
        jf.getContentPane().add(bd);
        jf.getContentPane().add(bd2);
        jf.getContentPane().add(bd3);
        jf.setVisible(true);
        for (int i = 0; i < 20000; ++i) {
            Thread.sleep(100L);
            pos2 += (int)(5.0 - 10.0 * Math.random());
            pos3 += (int)(5.0 - 10.0 * Math.random());
            if ((pos += (int)(5.0 - 10.0 * Math.random())) < 0) {
                pos = 0;
            }
            if (pos3 < 0) {
                pos3 = 0;
            }
            data[(60 + i) % data.length] = pos;
            data2[(60 + i) % data2.length] = pos2;
            data3[(60 + i) % data3.length] = pos3;
            bd.setData(0, data, i % data.length, 60);
            bd.setData(1, data2, i % data2.length, 60);
            bd.setData(2, data3, i % data3.length, 60);
            bd2.setData(0, data, i % data.length, 60);
            bd2.setData(1, data2, i % data2.length, 60);
            bd2.setData(2, data3, i % data3.length, 60);
            bd3.setData(0, data, i % data.length, 60);
            bd3.setData(1, data2, i % data2.length, 60);
            bd3.setData(2, data3, i % data3.length, 60);
        }
    }

    private static DotDiagram setupDiagram(int v, int[] d1, int[] d2, int[] d3, int mode) {
        DotDiagram bd = new DotDiagram(v, mode);
        bd.setDotColor(0, Color.red);
        bd.setDotColor(1, Color.green);
        bd.setDotColor(2, Color.blue);
        bd.addConstant(Color.yellow, 100);
        bd.setShowGrid(true);
        bd.setYLabel("The Y-Axis (" + (mode == 0 ? "normal" : "additive") + ')');
        bd.setData(0, d1, 0, 60);
        bd.setData(1, d2, 0, 60);
        bd.setData(2, d3, 0, 60);
        return bd;
    }
}

