/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.util;

import java.io.PrintStream;
import se.sics.mspsim.core.EmulationException;
import se.sics.mspsim.core.EmulationLogger;
import se.sics.mspsim.core.MSP430;

public class DefaultEmulationLogger
implements EmulationLogger {
    private EmulationLogger.WarningMode warningMode = EmulationLogger.WarningMode.PRINT;
    private PrintStream out;
    private MSP430 cpu;

    public DefaultEmulationLogger(MSP430 cpu, PrintStream out) {
        this.cpu = cpu;
        this.out = out;
    }

    @Override
    public void warning(Object source, String message) throws EmulationException {
        if (this.warningMode == EmulationLogger.WarningMode.EXCEPTION) {
            throw new EmulationException(message);
        }
        if (this.warningMode == EmulationLogger.WarningMode.PRINT) {
            this.out.println(message);
            this.cpu.generateTrace(this.out);
        }
    }

    @Override
    public void setWarningMode(EmulationLogger.WarningMode mode) {
        this.warningMode = mode;
    }

    @Override
    public void log(Object source, String message) {
        this.out.println(message);
    }
}

