/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Properties;
import java.util.StringTokenizer;

public class ConfigManager {
    protected final ConfigManager parent;
    protected Properties properties = null;

    public ConfigManager() {
        this(null);
    }

    public ConfigManager(ConfigManager parent) {
        this.parent = parent;
    }

    protected String getBackupFile(String configFile) {
        int index = configFile.lastIndexOf(46);
        if (index > 0 && index < configFile.length() - 1) {
            return configFile.substring(0, index) + ".bak";
        }
        return null;
    }

    public boolean loadConfiguration(String configFile) {
        return this.loadConfiguration(new File(configFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadConfiguration(File configFile) {
        try {
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(configFile));
            try {
                this.loadConfiguration(input);
            }
            finally {
                ((InputStream)input).close();
            }
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("could not read config file '" + configFile + "': " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadConfiguration(URL configURL) {
        try {
            BufferedInputStream input = new BufferedInputStream(configURL.openStream());
            try {
                this.loadConfiguration(input);
            }
            finally {
                ((InputStream)input).close();
            }
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("could not read config file '" + configURL + "': " + e);
        }
    }

    public void loadConfiguration(InputStream input) throws IOException {
        Properties p = new Properties();
        p.load(input);
        this.properties = p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveConfiguration(File filename, String comments) {
        if (this.properties != null) {
            FileOutputStream output = null;
            try {
                output = new FileOutputStream(filename);
                this.properties.store(output, comments);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (output != null) {
                    try {
                        ((OutputStream)output).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPropertyNames() {
        if (this.properties == null) {
            return new String[0];
        }
        Properties properties = this.properties;
        synchronized (properties) {
            return this.properties.keySet().toArray(new String[this.properties.size()]);
        }
    }

    public String getProperty(String name) {
        return this.getProperty(name, null);
    }

    public String getProperty(String name, String defaultValue) {
        String value;
        String string = value = this.properties != null ? this.properties.getProperty(name) : null;
        if (value == null || value.length() == 0) {
            value = this.parent != null ? this.parent.getProperty(name, defaultValue) : defaultValue;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String name, String value) {
        if (this.properties == null) {
            ConfigManager configManager = this;
            synchronized (configManager) {
                if (this.properties == null) {
                    this.properties = new Properties();
                }
            }
        }
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    public String[] getPropertyAsArray(String name) {
        return this.getPropertyAsArray(name, null);
    }

    public String[] getPropertyAsArray(String name, String defaultValue) {
        StringTokenizer tok;
        int len;
        String valueList = this.getProperty(name, defaultValue);
        if (valueList != null && (len = (tok = new StringTokenizer(valueList, ", \t")).countTokens()) > 0) {
            String[] values = new String[len];
            for (int i = 0; i < len; ++i) {
                values[i] = tok.nextToken();
            }
            return values;
        }
        return null;
    }

    public int getPropertyAsInt(String name, int defaultValue) {
        String value = this.getProperty(name, null);
        return value != null ? this.parseInt(name, value, defaultValue) : defaultValue;
    }

    public int[] getPropertyAsIntArray(String name) {
        return this.getPropertyAsIntArray(name, null);
    }

    public int[] getPropertyAsIntArray(String name, String defaultValue) {
        String valueList = this.getProperty(name, defaultValue);
        if (valueList != null) {
            return this.parseIntArray(valueList, defaultValue);
        }
        if (defaultValue != null) {
            return this.parseIntArray(defaultValue, null);
        }
        return null;
    }

    private int[] parseIntArray(String valueList, String secondaryValue) {
        StringTokenizer tok = new StringTokenizer(valueList, ", \t/");
        int len = tok.countTokens();
        if (len > 0) {
            try {
                int[] values = new int[len];
                for (int i = 0; i < len; ++i) {
                    values[i] = Integer.parseInt(tok.nextToken());
                }
                return values;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (secondaryValue != null && !secondaryValue.equals(valueList)) {
            return this.parseIntArray(secondaryValue, null);
        }
        return null;
    }

    public long getPropertyAsLong(String name, long defaultValue) {
        String value = this.getProperty(name, null);
        return value != null ? this.parseLong(name, value, defaultValue) : defaultValue;
    }

    public float getPropertyAsFloat(String name, float defaultValue) {
        String value = this.getProperty(name, null);
        return value != null ? this.parseFloat(name, value, defaultValue) : defaultValue;
    }

    public double getPropertyAsDouble(String name, double defaultValue) {
        String value = this.getProperty(name, null);
        return value != null ? this.parseDouble(name, value, defaultValue) : defaultValue;
    }

    public boolean getPropertyAsBoolean(String name, boolean defaultValue) {
        String value = this.getProperty(name, null);
        return value != null ? this.parseBoolean(name, value, defaultValue) : defaultValue;
    }

    protected int parseInt(String name, String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            System.err.println("config '" + name + "' has a non-integer value '" + value + '\'');
            return defaultValue;
        }
    }

    protected long parseLong(String name, String value, long defaultValue) {
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            System.err.println("config '" + name + "' has a non-long value '" + value + '\'');
            return defaultValue;
        }
    }

    protected float parseFloat(String name, String value, float defaultValue) {
        try {
            return Float.parseFloat(value);
        }
        catch (Exception e) {
            System.err.println("config '" + name + "' has a non-float value '" + value + '\'');
            return defaultValue;
        }
    }

    protected double parseDouble(String name, String value, double defaultValue) {
        try {
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            System.err.println("config '" + name + "' has a non-double value '" + value + '\'');
            return defaultValue;
        }
    }

    protected boolean parseBoolean(String name, String value, boolean defaultValue) {
        return "true".equals(value) || "yes".equals(value) || "1".equals(value);
    }

    public void print(PrintStream out) {
        this.properties.list(out);
    }
}

