/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.util;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import se.sics.mspsim.util.ActiveComponent;
import se.sics.mspsim.util.ServiceComponent;

public class ComponentRegistry {
    private ArrayList<ComponentEntry> components = new ArrayList();
    private boolean running = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerComponent(String name, Object component) {
        ArrayList<ComponentEntry> arrayList = this.components;
        synchronized (arrayList) {
            this.components.add(new ComponentEntry(name, component));
        }
        if (component instanceof ActiveComponent) {
            ((ActiveComponent)component).init(name, this);
            if (this.running) {
                ((ActiveComponent)component).start();
            }
        } else if (component instanceof ServiceComponent) {
            ((ServiceComponent)component).init(name, this);
        }
    }

    public synchronized Object getComponent(String name) {
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            if (!name.equals(this.components.get((int)i).name)) continue;
            return this.components.get((int)i).component;
        }
        return null;
    }

    public synchronized Object[] getAllComponents(String name) {
        ArrayList<Object> list = new ArrayList<Object>();
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            ComponentEntry entry = this.components.get(i);
            if (!name.equals(entry.name)) continue;
            list.add(entry.component);
        }
        return list.toArray();
    }

    public synchronized Object getComponent(Class name) {
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            if (!name.isAssignableFrom(this.components.get((int)i).component.getClass())) continue;
            return this.components.get((int)i).component;
        }
        return null;
    }

    public synchronized Object[] getAllComponents(Class name) {
        ArrayList<Object> list = new ArrayList<Object>();
        int n = this.components.size();
        for (int i = 0; i < n; ++i) {
            Object component = this.components.get((int)i).component;
            if (!name.isAssignableFrom(component.getClass())) continue;
            list.add(component);
        }
        return list.toArray((Object[])Array.newInstance(name, list.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        ComponentEntry[] plugs;
        ComponentRegistry componentRegistry = this;
        synchronized (componentRegistry) {
            this.running = true;
            plugs = this.components.toArray(new ComponentEntry[this.components.size()]);
        }
        for (int i = 0; i < plugs.length; ++i) {
            if (!(plugs[i].component instanceof ActiveComponent)) continue;
            ((ActiveComponent)plugs[i].component).start();
        }
    }

    public void printRegistry(PrintStream out) {
        ComponentEntry[] plugs = this.components.toArray(new ComponentEntry[this.components.size()]);
        out.printf("%-22s %s\n", "Component Name", "Component Class");
        out.println("----------------------------------------------");
        for (int i = 0; i < plugs.length; ++i) {
            out.printf("%-22s %s\n", plugs[i].name, plugs[i].component.getClass().getName());
        }
    }

    private static class ComponentEntry {
        public final String name;
        public final Object component;

        private ComponentEntry(String name, Object component) {
            this.name = name;
            this.component = component;
        }
    }
}

