/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.ui;

import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.prefs.Preferences;

public class WindowUtils {
    private static Preferences prefs = Preferences.userNodeForPackage(WindowUtils.class);
    private static Hashtable<Window, CloseListener> closeTable;
    private static Hashtable<Window, String> exitTable;

    private WindowUtils() {
    }

    public static void saveWindowBounds(String key, Window window) {
        WindowUtils.putWindowBounds(key, window);
        try {
            prefs.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void putWindowBounds(String key, Window window) {
        prefs.put("window." + key + ".bounds", WindowUtils.getBounds(window));
    }

    public static void restoreWindowBounds(String key, Window window) {
        WindowUtils.setBounds(window, prefs.get("window." + key + ".bounds", null));
    }

    private static String getBounds(Window window) {
        return "" + window.getX() + ',' + window.getY() + ',' + window.getWidth() + ',' + window.getHeight();
    }

    private static void setBounds(Window window, String bounds) {
        String[] b;
        if (bounds != null && (b = bounds.split(",")) != null && b.length == 4) {
            try {
                window.setBounds(Integer.parseInt(b[0]), Integer.parseInt(b[1]), Integer.parseInt(b[2]), Integer.parseInt(b[3]));
            }
            catch (Exception e) {
                e.printStackTrace();
                window.pack();
            }
        } else {
            window.pack();
        }
    }

    public static void clearState() {
        try {
            prefs.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized void addSaveOnClose(String key, Window window) {
        if (closeTable == null) {
            closeTable = new Hashtable();
        }
        if (closeTable.get(window) == null) {
            CloseListener c = new CloseListener(key);
            window.addWindowListener(c);
            closeTable.put(window, c);
        }
    }

    public static synchronized void removeSaveOnClose(Window window) {
        CloseListener c;
        if (closeTable != null && (c = closeTable.remove(window)) != null) {
            window.removeWindowListener(c);
        }
    }

    public static synchronized void addSaveOnShutdown(String key, Window window) {
        if (exitTable == null) {
            exitTable = new Hashtable();
            Runtime.getRuntime().addShutdownHook(new ShutdownHandler());
        }
        exitTable.put(window, key);
    }

    public static synchronized void removeSaveOnShutdown(Window window) {
        if (exitTable != null) {
            exitTable.remove(window);
        }
    }

    public static void main(String[] args) {
        if (args.length != 1 || !args[0].equals("-clearState")) {
            System.err.println("Usage: WindowUtils -clearState");
            System.exit(1);
        }
        WindowUtils.clearState();
    }

    private static class ShutdownHandler
    extends Thread {
        public ShutdownHandler() {
            super("WindowUtils-Shutdown");
        }

        @Override
        public void run() {
            Hashtable table = exitTable;
            if (table != null && table.size() > 0) {
                exitTable = null;
                Enumeration e = table.keys();
                while (e.hasMoreElements()) {
                    Window w = (Window)e.nextElement();
                    WindowUtils.putWindowBounds((String)table.get(w), w);
                }
                try {
                    prefs.flush();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    private static class CloseListener
    extends WindowAdapter {
        private String key;

        public CloseListener(String key) {
            this.key = key;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            Window source = (Window)e.getSource();
            WindowUtils.saveWindowBounds(this.key, source);
            source.removeWindowListener(this);
            closeTable.remove(source);
        }
    }
}

