/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;
import se.sics.mspsim.core.CPUMonitor;
import se.sics.mspsim.core.MSP430;
import se.sics.mspsim.ui.ChartPanel;
import se.sics.mspsim.ui.ConstantLineChart;
import se.sics.mspsim.ui.LineChart;
import se.sics.mspsim.ui.ManagedWindow;
import se.sics.mspsim.ui.WindowManager;
import se.sics.mspsim.util.ComponentRegistry;
import se.sics.mspsim.util.MapTable;
import se.sics.mspsim.util.ServiceComponent;

public class StackUI
extends JPanel
implements CPUMonitor,
ServiceComponent {
    private static final long serialVersionUID = 8648239617509299768L;
    private static final int STACK_FRAME = 1024;
    private int updateCyclePeriod = 2500;
    private MSP430 cpu;
    private int heapStartAddress;
    private int stackStartAddress = 2560;
    private ChartPanel chartPanel;
    private LineChart minStackChart;
    private LineChart maxStackChart;
    private int[] minData = new int[1024];
    private int[] maxData = new int[1024];
    private int[] minCache = new int[1024];
    private int[] maxCache = new int[1024];
    private long lastCycles = 0L;
    private int pos = 0;
    private boolean update = false;
    private ServiceComponent.Status status = ServiceComponent.Status.STOPPED;
    private ComponentRegistry registry;
    private ManagedWindow window;
    private String name;

    public StackUI(MSP430 cpu) {
        this(cpu, 2500);
    }

    public StackUI(MSP430 cpu, int updateCyclePeriod) {
        super(new BorderLayout());
        MapTable mapTable;
        this.updateCyclePeriod = updateCyclePeriod;
        this.cpu = cpu;
        this.cpu.setRegisterWriteMonitor(1, this);
        if (cpu.getDisAsm() != null && (mapTable = cpu.getDisAsm().getMap()) != null) {
            this.heapStartAddress = mapTable.heapStartAddress;
            this.stackStartAddress = mapTable.stackStartAddress;
        }
    }

    private void setup() {
        if (this.chartPanel != null) {
            return;
        }
        this.chartPanel = new ChartPanel();
        ConstantLineChart maxChart = new ConstantLineChart("Max", this.stackStartAddress - this.heapStartAddress);
        maxChart.setConfig("color", Color.red);
        this.chartPanel.addChart(maxChart);
        this.minStackChart = new LineChart("Min Stack");
        this.minStackChart.setConfig("color", Color.green);
        this.chartPanel.addChart(this.minStackChart);
        this.maxStackChart = new LineChart("Max Stack");
        this.maxStackChart.setConfig("color", Color.green);
        this.chartPanel.addChart(this.maxStackChart);
        this.chartPanel.setAxisChart(this.maxStackChart);
        this.add((Component)this.chartPanel, "Center");
        this.chartPanel.setMinimumSize(new Dimension(320, 200));
        this.setPreferredSize(new Dimension(320, 200));
        this.setSize(320, 200);
        this.setMinimumSize(new Dimension(320, 200));
        WindowManager wm = (WindowManager)this.registry.getComponent("windowManager");
        if (wm != null) {
            this.window = wm.createWindow("stackui");
            this.window.add(this);
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.update) {
            this.update = false;
            int p = this.pos;
            this.copy(this.minData, this.minCache, p);
            this.copy(this.maxData, this.maxCache, p);
            this.minStackChart.setData(this.minCache);
            this.maxStackChart.setData(this.maxCache);
        }
        super.paint(g);
    }

    private void copy(int[] data1, int[] data2, int p) {
        if (p + 1 < data1.length) {
            System.arraycopy(data1, p + 1, data2, 0, data1.length - p - 1);
        }
        if (p > 0) {
            System.arraycopy(data1, 0, data2, data1.length - p, p);
        }
    }

    @Override
    public void cpuAction(int type, int adr, int data) {
        int size = (this.stackStartAddress - data + 65535) % 65535;
        if (this.minData[this.pos] > size) {
            this.minData[this.pos] = size;
        }
        if (this.maxData[this.pos] < size) {
            this.maxData[this.pos] = size;
        }
        if (this.cpu.cpuCycles - this.lastCycles > (long)this.updateCyclePeriod) {
            this.lastCycles = this.cpu.cpuCycles;
            this.pos = (this.pos + 1) % this.minData.length;
            this.minData[this.pos] = Integer.MAX_VALUE;
            this.maxData[this.pos] = 0;
            this.update = true;
            this.repaint();
        }
    }

    @Override
    public ServiceComponent.Status getStatus() {
        return this.status;
    }

    @Override
    public void init(String name, ComponentRegistry registry) {
        this.registry = registry;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void start() {
        this.setup();
        this.status = ServiceComponent.Status.STARTED;
        this.window.setVisible(true);
    }

    @Override
    public void stop() {
        this.status = ServiceComponent.Status.STOPPED;
        this.window.setVisible(false);
    }
}

