/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import se.sics.mspsim.core.USART;
import se.sics.mspsim.core.USARTListener;
import se.sics.mspsim.ui.WindowUtils;

public class SerialMon
implements KeyListener,
USARTListener {
    private static final String PREFIX = " > ";
    private static final int MAX_LINES = 200;
    private String name;
    private JFrame window;
    private USART usart;
    private JTextArea textArea;
    private JLabel statusLabel;
    private String text = "*** Serial mon for MSPsim ***\n";
    private static final int BUFFER_SIZE = 20;
    private byte[] buffer = new byte[20];
    private int wPos = 0;
    private int rPos = 0;
    private int bsize = 0;
    private int lines = 1;
    private boolean isUpdatePending = false;
    private StringBuilder keyBuffer = new StringBuilder();

    public SerialMon(USART usart, String name) {
        this.name = name;
        this.usart = usart;
        this.window = new JFrame(name);
        this.textArea = new JTextArea(20, 40);
        this.window.add((Component)new JScrollPane(this.textArea, 20, 31), "Center");
        this.textArea.setText(this.text);
        this.textArea.setEditable(false);
        this.statusLabel = new JLabel(PREFIX);
        this.keyBuffer.append(PREFIX);
        this.statusLabel.setOpaque(true);
        this.statusLabel.setBackground(Color.lightGray);
        this.window.add((Component)this.statusLabel, "South");
        String key = "usart." + name;
        WindowUtils.restoreWindowBounds(key, this.window);
        WindowUtils.addSaveOnShutdown(key, this.window);
        this.window.setVisible(true);
        this.textArea.addKeyListener(this);
    }

    public void saveWindowBounds() {
        WindowUtils.saveWindowBounds("usart." + this.name, this.window);
    }

    @Override
    public void dataReceived(USART source, int data) {
        if (data == 10) {
            if (this.lines >= 200) {
                int index = this.text.indexOf(10);
                this.text = this.text.substring(index + 1);
            } else {
                ++this.lines;
            }
        }
        this.text = this.text + (char)data;
        if (!this.isUpdatePending) {
            this.isUpdatePending = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SerialMon.this.isUpdatePending = false;
                    String newText = SerialMon.this.text;
                    SerialMon.this.textArea.setText(newText);
                    SerialMon.this.textArea.setCaretPosition(newText.length());
                    SerialMon.this.textArea.repaint();
                }
            });
        }
    }

    @Override
    public void keyPressed(KeyEvent key) {
    }

    @Override
    public void keyReleased(KeyEvent key) {
    }

    @Override
    public void keyTyped(KeyEvent key) {
        char c = key.getKeyChar();
        if (this.usart.isReceiveFlagCleared() && this.bsize == 0) {
            this.usart.byteReceived(c & 0xFF);
        } else if (this.bsize < 20) {
            this.buffer[this.wPos] = (byte)(c & 0xFF);
            this.wPos = (this.wPos + 1) % 20;
            ++this.bsize;
        }
        if (this.bsize < 20) {
            if (c == '\n') {
                this.statusLabel.setText(PREFIX);
                this.keyBuffer = new StringBuilder();
                this.keyBuffer.append(PREFIX);
            } else {
                this.keyBuffer.append(c);
                this.statusLabel.setText(this.keyBuffer.toString());
            }
        } else {
            this.statusLabel.getToolkit().beep();
            this.statusLabel.setText("*** input buffer full ***");
        }
    }

    @Override
    public void stateChanged(int state) {
        if (state == 1 && this.bsize > 0 && this.usart.isReceiveFlagCleared()) {
            this.usart.byteReceived(this.buffer[this.rPos]);
            this.rPos = (this.rPos + 1) % 20;
            if (this.bsize == 20) {
                this.statusLabel.setText(this.keyBuffer.toString());
            }
            --this.bsize;
        }
    }
}

