/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import se.sics.mspsim.core.DbgInstruction;
import se.sics.mspsim.core.DisAsm;
import se.sics.mspsim.core.MSP430;
import se.sics.mspsim.util.Utils;

public class DebugUI
extends JPanel {
    private JList disList;
    private JLabel[] regsLabel;
    private MSP430 cpu;
    private DbgListModel listModel;
    private int currentAddress = 0;
    private DisAsm disAsm;

    public DebugUI(MSP430 cpu) {
        this(cpu, true);
    }

    public DebugUI(MSP430 cpu, boolean showRegs) {
        super(new BorderLayout());
        this.cpu = cpu;
        this.disAsm = cpu.getDisAsm();
        this.listModel = new DbgListModel();
        this.disList = new JList(this.listModel);
        this.disList.setFont(new Font("courier", 0, 12));
        this.disList.setCellRenderer(new MyCellRenderer());
        this.disList.setPreferredSize(new Dimension(500, 350));
        this.add((Component)this.disList, "Center");
        if (showRegs) {
            JPanel regs = new JPanel(new GridLayout(2, 8, 4, 0));
            this.regsLabel = new JLabel[16];
            int n = 16;
            for (int i = 0; i < n; ++i) {
                this.regsLabel[i] = new JLabel("$0000");
                regs.add(this.regsLabel[i]);
            }
            this.add((Component)regs, "South");
            this.updateRegs();
        }
    }

    public void updateRegs() {
        if (this.regsLabel != null) {
            int n = 16;
            for (int i = 0; i < n; ++i) {
                this.regsLabel[i].setText("$" + Utils.hex16(this.cpu.reg[i]));
            }
        }
        this.repaint();
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MyCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s;
            int pos = 0;
            if (value == null) {
                s = "---";
            } else if (value instanceof DbgInstruction) {
                DbgInstruction i = (DbgInstruction)value;
                s = i.getASMLine(false);
                if (i.getFunction() != null) {
                    s = s + ";   " + i.getFunction();
                }
                pos = i.getPos();
                s = DebugUI.this.cpu.hasBreakPoint(pos) ? "*B " + s : "   " + s;
            } else {
                s = value.toString();
            }
            this.setText(s);
            int[] nArray = ((DebugUI)DebugUI.this).cpu.reg;
            DebugUI.this.cpu;
            if (pos == nArray[0]) {
                this.setBackground(Color.green);
            } else if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            return this;
        }
    }

    private class DbgListModel
    extends AbstractListModel {
        int startPos = -1;
        int endPos = -1;
        final int size = 21;
        DbgInstruction[] instructions = new DbgInstruction[21];
        private DbgInstruction[] instrs = new DbgInstruction[65536];

        private DbgListModel() {
        }

        public void setCurrentAddress(int address) {
            this.startPos = address;
        }

        @Override
        public int getSize() {
            return 21;
        }

        private void checkPC() {
            int[] nArray = ((DebugUI)DebugUI.this).cpu.reg;
            DebugUI.this.cpu;
            int pc = nArray[0];
            if (pc < this.startPos || pc > this.endPos) {
                this.startPos = pc;
                int currentPos = pc;
                int n = 21;
                for (int i = 0; i < n; ++i) {
                    if (DebugUI.this.cpu.getExecCount(currentPos) == 0) {
                        // empty if block
                    }
                    DbgInstruction inst = DebugUI.this.disAsm.getDbgInstruction(currentPos, DebugUI.this.cpu);
                    inst.setPos(currentPos);
                    currentPos += inst.getSize();
                    this.instructions[i] = inst;
                }
                this.endPos = currentPos;
            }
        }

        @Override
        public Object getElementAt(int index) {
            this.checkPC();
            return this.instructions[index];
        }
    }
}

