/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import se.sics.mspsim.core.MSP430;
import se.sics.mspsim.core.SimEvent;
import se.sics.mspsim.core.SimEventListener;
import se.sics.mspsim.platform.GenericNode;
import se.sics.mspsim.ui.DebugUI;
import se.sics.mspsim.ui.ManagedWindow;
import se.sics.mspsim.ui.SourceViewer;
import se.sics.mspsim.ui.WindowManager;
import se.sics.mspsim.util.ComponentRegistry;
import se.sics.mspsim.util.DebugInfo;
import se.sics.mspsim.util.ELF;
import se.sics.mspsim.util.ServiceComponent;

public class ControlUI
extends JPanel
implements ActionListener,
SimEventListener,
ServiceComponent {
    private static final long serialVersionUID = -2431892192775232653L;
    private static final String TITLE = "MSPSim monitor";
    private ManagedWindow window;
    private JButton controlButton;
    private MSP430 cpu;
    private GenericNode node;
    private DebugUI dui;
    private ELF elfData;
    private SourceViewer sourceViewer;
    private Action stepAction;
    private ComponentRegistry registry;
    private ServiceComponent.Status status = ServiceComponent.Status.STOPPED;
    private String name;

    public ControlUI() {
        super(new GridLayout(0, 1));
    }

    private void setup() {
        if (this.window != null) {
            return;
        }
        this.cpu = (MSP430)this.registry.getComponent("cpu");
        this.node = (GenericNode)this.registry.getComponent("node");
        this.elfData = (ELF)this.registry.getComponent("elf");
        WindowManager wm = (WindowManager)this.registry.getComponent("windowManager");
        this.window = wm.createWindow("ControlUI");
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        jp.add((Component)this, "West");
        this.dui = new DebugUI(this.cpu);
        jp.add((Component)this.dui, "Center");
        this.window.add(jp);
        this.createButton("Debug On");
        this.controlButton = this.createButton(this.cpu.isRunning() ? "Stop" : "Run");
        this.stepAction = new AbstractAction("Single Step"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ControlUI.this.node.step();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                ControlUI.this.dui.updateRegs();
                ControlUI.this.dui.repaint();
                if (ControlUI.this.elfData != null && ControlUI.this.sourceViewer != null && ControlUI.this.sourceViewer.isVisible()) {
                    int pc = ControlUI.this.cpu.readRegister(0);
                    DebugInfo dbg = ControlUI.this.elfData.getDebugInfo(pc);
                    if (dbg != null) {
                        if (ControlUI.this.cpu.getDebug()) {
                            System.out.println("looking up $" + Integer.toString(pc, 16) + " => " + dbg.getFile() + ':' + dbg.getLine());
                        }
                        ControlUI.this.sourceViewer.viewFile(dbg.getPath(), dbg.getFile());
                        ControlUI.this.sourceViewer.viewLine(dbg.getLine());
                    }
                }
            }
        };
        this.stepAction.putValue("MnemonicKey", new Integer(83));
        this.stepAction.setEnabled(!this.cpu.isRunning());
        JButton stepButton = new JButton(this.stepAction);
        this.add(stepButton);
        this.createButton("Stack Trace");
        if (this.elfData != null) {
            this.createButton("Show Source");
        }
        this.createButton("Profile Dump");
        stepButton.getInputMap(2).put(KeyStroke.getKeyStroke(83, 2), "cpuStep");
        stepButton.getActionMap().put("cpuStep", this.stepAction);
        this.cpu.addSimEventListener(this);
        this.window.setVisible(true);
    }

    public void setSourceViewer(SourceViewer viewer) {
        this.sourceViewer = viewer;
    }

    private JButton createButton(String text) {
        JButton jb = new JButton(text);
        jb.addActionListener(this);
        this.add(jb);
        return jb;
    }

    private void updateCPUPercent() {
        this.window.setTitle("MSPSim monitor  CPU On: " + this.cpu.getCPUPercent() + "%");
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        this.updateCPUPercent();
        if ("Debug On".equals(cmd)) {
            this.cpu.setDebug(true);
            ((JButton)ae.getSource()).setText("Debug Off");
        } else if ("Debug Off".equals(cmd)) {
            this.cpu.setDebug(false);
            ((JButton)ae.getSource()).setText("Debug On");
        } else if ("Run".equals(cmd)) {
            this.node.start();
        } else if ("Stop".equals(cmd)) {
            this.node.stop();
        } else if ("Profile Dump".equals(cmd)) {
            if (this.cpu.getProfiler() != null) {
                this.cpu.getProfiler().printProfile(System.out);
            } else {
                System.out.println("*** No profiler available");
            }
        } else if ("Show Source".equals(cmd)) {
            DebugInfo dbg;
            int pc = this.cpu.readRegister(0);
            if (this.elfData != null && (dbg = this.elfData.getDebugInfo(pc)) != null) {
                if (this.cpu.getDebug()) {
                    System.out.println("looking up $" + Integer.toString(pc, 16) + " => " + dbg.getFile() + ':' + dbg.getLine());
                }
                if (this.sourceViewer != null) {
                    this.sourceViewer.viewFile(dbg.getPath(), dbg.getFile());
                    this.sourceViewer.viewLine(dbg.getLine());
                } else {
                    System.out.println("File: " + dbg.getFile());
                    System.out.println("LineNr: " + dbg.getLine());
                }
            }
        } else if ("Stack Trace".equals(cmd)) {
            this.cpu.getProfiler().printStackTrace(System.out);
        }
        this.dui.updateRegs();
    }

    @Override
    public void simChanged(SimEvent event) {
        switch (event.getType()) {
            case START: 
            case STOP: {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (ControlUI.this.cpu.isRunning()) {
                            ControlUI.this.controlButton.setText("Stop");
                            ControlUI.this.stepAction.setEnabled(false);
                        } else {
                            ControlUI.this.controlButton.setText("Run");
                            ControlUI.this.stepAction.setEnabled(true);
                        }
                    }
                });
            }
        }
    }

    @Override
    public ServiceComponent.Status getStatus() {
        return this.status;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void init(String name, ComponentRegistry registry) {
        this.name = name;
        this.registry = registry;
    }

    @Override
    public void start() {
        this.setup();
        this.status = ServiceComponent.Status.STARTED;
        this.window.setVisible(true);
    }

    @Override
    public void stop() {
        this.status = ServiceComponent.Status.STOPPED;
        this.window.setVisible(false);
    }
}

