/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.ui;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.border.Border;
import se.sics.mspsim.ui.BarChart;
import se.sics.mspsim.ui.Chart;
import se.sics.mspsim.ui.LineChart;

public class ChartPanel
extends JComponent {
    private static final long serialVersionUID = 7243446493049199594L;
    public static final String COLOR_TICK = "color.tick";
    private static final Border DEFAULT_BORDER = BorderFactory.createEmptyBorder(10, 10, 10, 10);
    private static final Color[] DEFAULT_COLOR = new Color[]{Color.blue, new Color(-16744448), Color.red, Color.black};
    private static final Color LIGHT_GRAY = new Color(-7303024);
    private ArrayList<Chart> charts = new ArrayList();
    private Hashtable<String, Object> config = new Hashtable();
    private Chart[] chartCache = null;
    private Chart axisChart;

    public ChartPanel() {
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.setBorder(DEFAULT_BORDER);
        this.setOpaque(true);
    }

    public Chart getAxisChart() {
        return this.axisChart;
    }

    public void setAxisChart(Chart chart) {
        this.axisChart = chart;
    }

    public synchronized void addChart(Chart chart) {
        this.charts.add(chart);
        this.chartCache = null;
    }

    public synchronized void removeChart(Chart chart) {
        this.charts.remove(chart);
        this.chartCache = null;
    }

    public synchronized Chart getChart(String name) {
        int n = this.charts.size();
        for (int i = 0; i < n; ++i) {
            if (!name.equals(this.charts.get(i).getName())) continue;
            return this.charts.get(i);
        }
        return null;
    }

    public synchronized Chart[] getCharts() {
        if (this.chartCache == null) {
            this.chartCache = this.charts.toArray(new Chart[this.charts.size()]);
        }
        return this.chartCache;
    }

    public Object getConfig(String param) {
        return this.getConfig(param, null);
    }

    public Object getConfig(String param, Object defVal) {
        Object retVal = this.config.get(param);
        return retVal != null ? retVal : defVal;
    }

    public void setConfig(String param, Object value) {
        if (value != null) {
            this.config.put(param, value);
        } else {
            this.config.remove(param);
        }
    }

    private Color getDefaultColor(int index) {
        return DEFAULT_COLOR[index % DEFAULT_COLOR.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        try {
            if (this.isOpaque()) {
                g2d.setColor(this.getBackground());
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            this.paintCharts(g2d);
        }
        finally {
            g2d.dispose();
        }
    }

    protected void paintCharts(Graphics2D g) {
        Chart axisChart = this.axisChart;
        Color foreground = this.getForeground();
        Color tickColor = (Color)this.getConfig(COLOR_TICK, LIGHT_GRAY);
        FontMetrics fm = this.getFontMetrics(g.getFont());
        int fmHeight = fm.getAscent();
        Insets insets = this.getInsets();
        int height = this.getHeight();
        int width = this.getWidth();
        int leftInset = 40;
        g.translate(leftInset + insets.left + 1, insets.top + 1);
        g.setColor(foreground);
        g.drawRect(-1, -1, (width -= leftInset + insets.left + insets.right + 2) + 2, (height -= insets.top + insets.bottom + fmHeight + 2) + 2);
        Chart[] chs = this.getCharts();
        if (chs.length > 0) {
            double totMaxY = Double.MIN_VALUE;
            double totMinY = Double.MAX_VALUE;
            double totMaxX = Double.MIN_VALUE;
            double totMinX = Double.MAX_VALUE;
            int n = chs.length;
            for (int i = 0; i < n; ++i) {
                Chart chart = chs[i];
                double maxY = chart.getMaxY();
                double minY = chart.getMinY();
                double minX = chart.getMinX();
                double maxX = chart.getMaxX();
                if (!(maxY >= minY) || !(maxX > minX)) continue;
                if (maxY > totMaxY) {
                    totMaxY = maxY;
                }
                if (minY < totMinY) {
                    totMinY = minY;
                }
                if (maxX > totMaxX) {
                    totMaxX = maxX;
                }
                if (!(minX < totMinX)) continue;
                totMinX = minX;
            }
            if (totMaxY >= totMinY && totMaxX > totMinX) {
                double yfac = 1.0 * (double)height / (totMaxY - totMinY);
                double xfac = 1.0 * (double)width / (totMaxX - totMinX);
                int zero = height;
                if (totMinY < 0.0) {
                    zero += (int)(yfac * totMinY);
                }
                if (axisChart != null) {
                    int tlen;
                    String text;
                    double d;
                    double gridValue;
                    g.setColor(tickColor);
                    g.drawLine(0, zero, width, zero);
                    g.setColor(foreground);
                    g.drawString("0", -4 - fm.stringWidth("0"), zero + fmHeight / 2);
                    for (d = gridValue = this.getGridValue(totMinY, totMaxY, 10); d < totMaxY; d += gridValue) {
                        int y = (int)((double)zero - yfac * d);
                        text = "" + (int)d;
                        tlen = fm.stringWidth(text);
                        g.setColor(tickColor);
                        g.drawLine(0, y, width, y);
                        g.setColor(foreground);
                        g.drawString(text, -4 - tlen, y + fmHeight / 2);
                    }
                    for (d = gridValue; d < -totMinY; d += gridValue) {
                        int y = (int)((double)zero + yfac * d);
                        text = "" + (int)(-d);
                        tlen = fm.stringWidth(text);
                        g.setColor(tickColor);
                        g.drawLine(0, y, width, y);
                        g.setColor(foreground);
                        g.drawString(text, -4 - tlen, y + fmHeight / 2);
                    }
                    for (d = gridValue = this.getGridValue(totMinX, totMaxX, 10); d < totMaxX; d += gridValue) {
                        int x = (int)(xfac * d);
                        text = "" + (int)d;
                        tlen = fm.stringWidth(text);
                        g.setColor(tickColor);
                        g.drawLine(x, 0, x, height);
                        g.setColor(foreground);
                        g.drawString(text, x - tlen / 2, height + fmHeight);
                    }
                }
                int n2 = chs.length;
                for (int i = 0; i < n2; ++i) {
                    Chart chart = chs[i];
                    double maxY = chart.getMaxY();
                    double minY = chart.getMinY();
                    double minX = chart.getMinX();
                    double maxX = chart.getMaxX();
                    if (maxY < minY || maxX <= minX) continue;
                    g.setColor((Color)chart.getConfig("color", this.getDefaultColor(i)));
                    chart.drawChart(g, xfac, yfac, width, height);
                }
            }
        }
    }

    private double getGridValue(double totMinX, double totMaxX, int maxCount) {
        int z;
        double diff = totMaxX - totMinX;
        if (diff <= 0.0) {
            return 1.0;
        }
        double d = Math.log(diff) / Math.log(10.0);
        if (d - (double)(z = (int)d) > 0.69) {
            ++z;
        }
        if (z < 1) {
            return 1.0;
        }
        d = Math.pow(10.0, z - 1);
        if (diff / (double)((int)(1.0 * d)) <= (double)maxCount) {
            return (int)(1.0 * d);
        }
        if (diff / (double)((int)(2.5 * d)) <= (double)maxCount) {
            return (int)(2.5 * d);
        }
        return (int)(5.0 * d);
    }

    public static void main(String[] args) {
        JFrame jf = new JFrame("test charts");
        jf.setDefaultCloseOperation(3);
        jf.setBounds(100, 100, 600, 400);
        jf.setVisible(true);
        BarChart bc = new BarChart();
        LineChart lc = new LineChart();
        int[] data = new int[40];
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            data[i] = (int)(Math.random() * 300.0);
        }
        bc.setConfig("color", new Color(-5197648));
        bc.setData(data);
        lc.setData(data);
        lc.setMinMax(-4096.0, 4096.0);
        ChartPanel chp = new ChartPanel();
        chp.addChart(lc);
        chp.addChart(bc);
        jf.getContentPane().add(chp);
        jf.setVisible(true);
        while (true) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                // empty catch block
            }
            int len = 1024;
            data = new int[len];
            int n2 = data.length;
            for (int i = 0; i < n2; ++i) {
                data[i] = (int)(2500.0 - Math.random() * 5000.0);
            }
            lc.setData(data);
            chp.repaint();
        }
    }
}

