/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.plugin;

import java.util.Hashtable;
import se.sics.mspsim.cli.BasicAsyncCommand;
import se.sics.mspsim.cli.CommandContext;
import se.sics.mspsim.cli.CommandHandler;
import se.sics.mspsim.core.MSP430;
import se.sics.mspsim.core.Profiler;
import se.sics.mspsim.profiler.CallListener;
import se.sics.mspsim.util.ActiveComponent;
import se.sics.mspsim.util.ComponentRegistry;
import se.sics.mspsim.util.MapEntry;

public class ContikiChecker
implements CallListener,
ActiveComponent {
    private ComponentRegistry registry;
    private CommandContext context;
    private Profiler profiler;
    private Hashtable<String, Integer> callTable = new Hashtable();
    private int callCount = 0;

    @Override
    public void init(String name, ComponentRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void start() {
        CommandHandler commandHandler = (CommandHandler)this.registry.getComponent("commandHandler");
        if (commandHandler != null) {
            commandHandler.registerCommand("contikichecker", new BasicAsyncCommand("enable the Contiki checker", ""){

                @Override
                public int executeCommand(CommandContext context) {
                    if (ContikiChecker.this.profiler != null) {
                        context.err.println("already running");
                        return 1;
                    }
                    MSP430 cpu = (MSP430)ContikiChecker.this.registry.getComponent(MSP430.class);
                    ContikiChecker.this.profiler = cpu.getProfiler();
                    if (ContikiChecker.this.profiler == null) {
                        context.err.println("no profiler available");
                        return 1;
                    }
                    ContikiChecker.this.context = context;
                    ContikiChecker.this.profiler.addCallListener(ContikiChecker.this);
                    return 0;
                }

                @Override
                public void stopCommand(CommandContext context) {
                    if (ContikiChecker.this.profiler != null) {
                        ContikiChecker.this.profiler.removeCallListener(ContikiChecker.this);
                        ContikiChecker.this.profiler = null;
                    }
                    ContikiChecker.this.context = null;
                }
            });
        }
    }

    @Override
    public void functionCall(Profiler source, MapEntry entry) {
        String name = entry.getName();
        if (name != null && this.callTable.get(name) == null) {
            boolean addEntry = true;
            int index = name.indexOf(95);
            if (index > 0 && !name.endsWith("_init")) {
                String init2;
                int lastIndex = name.lastIndexOf(95);
                String init1 = name.substring(0, index + 1) + "init";
                String string = init2 = index != lastIndex ? name.substring(0, lastIndex + 1) + "init" : null;
                if (this.callTable.get(init1) == null && (init2 == null || this.callTable.get(init2) == null)) {
                    if (this.context.getMapTable().getFunctionAddress(init1) > 0) {
                        this.context.err.println("ContikiChecker: warning, " + name + " is called before " + init1);
                        this.profiler.printStackTrace(this.context.err);
                        addEntry = false;
                    } else if (init2 != null && this.context.getMapTable().getFunctionAddress(init2) > 0) {
                        this.context.err.println("ContikiChecker: warning, " + name + " is called before " + init2);
                        this.profiler.printStackTrace(this.context.err);
                        addEntry = false;
                    }
                }
            }
            if (addEntry) {
                this.callTable.put(name, ++this.callCount);
            }
        }
    }

    @Override
    public void functionReturn(Profiler source, MapEntry entry) {
    }
}

