/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.platform.sky;

import java.io.IOException;
import se.sics.mspsim.chip.AT45DB;
import se.sics.mspsim.chip.FileAT45DB;
import se.sics.mspsim.core.IOPort;
import se.sics.mspsim.core.USART;
import se.sics.mspsim.platform.sky.MoteIVNode;
import se.sics.mspsim.util.ArgumentManager;

public class TelosNode
extends MoteIVNode {
    public static final boolean DEBUG = false;
    public static final int FLASH_RESET = 8;
    public static final int FLASH_CS = 16;
    private AT45DB flash;

    public TelosNode() {
        this.setMode(0);
    }

    public AT45DB getFlash() {
        return this.flash;
    }

    public void setFlash(AT45DB flash) {
        this.flash = flash;
    }

    @Override
    protected void flashWrite(IOPort source, int data) {
        this.flash.setReset((data & 8) == 0);
        this.flash.setChipSelect((data & 0x10) == 0);
    }

    @Override
    public void dataReceived(USART source, int data) {
        this.radio.dataReceived(source, data);
        this.flash.dataReceived(source, data);
    }

    @Override
    public String getName() {
        return "Telos";
    }

    @Override
    public void setupNodePorts() {
        super.setupNodePorts();
        if (this.flashFile != null) {
            this.flash = new FileAT45DB(this.cpu, this.flashFile);
        }
    }

    public static void main(String[] args) throws IOException {
        TelosNode node = new TelosNode();
        ArgumentManager config = new ArgumentManager();
        config.handleArguments(args);
        node.setupArgs(config);
    }

    @Override
    public void stateChanged(int state) {
    }
}

