/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.platform.sky;

import java.io.IOException;
import se.sics.mspsim.chip.FileM25P80;
import se.sics.mspsim.chip.M25P80;
import se.sics.mspsim.core.IOPort;
import se.sics.mspsim.core.USART;
import se.sics.mspsim.platform.sky.MoteIVNode;
import se.sics.mspsim.util.ArgumentManager;

public class SkyNode
extends MoteIVNode {
    public static final boolean DEBUG = false;
    private M25P80 flash;

    public SkyNode() {
        this.setMode(0);
    }

    public M25P80 getFlash() {
        return this.flash;
    }

    public void setFlash(M25P80 flash) {
        this.flash = flash;
        this.registry.registerComponent("xmem", flash);
    }

    @Override
    public void dataReceived(USART source, int data) {
        this.radio.dataReceived(source, data);
        this.flash.dataReceived(source, data);
        if (!this.radio.getChipSelect() && !this.flash.getChipSelect()) {
            source.byteReceived(0);
        }
    }

    @Override
    protected void flashWrite(IOPort source, int data) {
        this.flash.portWrite(source, data);
    }

    @Override
    public String getName() {
        return "Tmote Sky";
    }

    @Override
    public void setupNodePorts() {
        super.setupNodePorts();
        if (this.flashFile != null) {
            this.setFlash(new FileM25P80(this.cpu, this.flashFile));
        }
    }

    public static void main(String[] args) throws IOException {
        SkyNode node = new SkyNode();
        ArgumentManager config = new ArgumentManager();
        config.handleArguments(args);
        node.setupArgs(config);
    }

    @Override
    public void stateChanged(int state) {
    }
}

