/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.platform.sky;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import se.sics.mspsim.core.IOUnit;
import se.sics.mspsim.core.MSP430;
import se.sics.mspsim.core.USART;
import se.sics.mspsim.platform.AbstractNodeGUI;
import se.sics.mspsim.platform.sky.MoteIVNode;
import se.sics.mspsim.ui.SerialMon;

public class SkyGui
extends AbstractNodeGUI {
    private static final long serialVersionUID = 7753659717805292786L;
    public static final int GREEN_Y = 40;
    public static final int BLUE_Y = 46;
    public static final int RED_Y = 34;
    public static final int LED_X = 10;
    public static final Color BLUE_TRANS = new Color(128, 128, 255, 160);
    public static final Color GREEN_TRANS = new Color(64, 240, 64, 160);
    public static final Color RED_TRANS = new Color(240, 64, 64, 160);
    public static final Color BLUE_C = new Color(-6250241);
    public static final Color GREEN_C = new Color(-10420384);
    public static final Color RED_C = new Color(Short.MIN_VALUE);
    private SerialMon serial;
    private MoteIVNode node;

    public SkyGui(MoteIVNode node) {
        super("SkyGui", "images/sky.jpg");
        this.node = node;
    }

    @Override
    protected void startGUI() {
        MouseAdapter mouseHandler = new MouseAdapter(){
            private boolean buttonDown = false;
            private boolean resetDown = false;

            @Override
            public void mousePressed(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                if (x > 122 && x < 135) {
                    if (y > 41 && y < 55) {
                        this.buttonDown = true;
                        SkyGui.this.node.setButton(true);
                    } else if (y > 72 && y < 85) {
                        this.resetDown = true;
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.buttonDown) {
                    this.buttonDown = false;
                    SkyGui.this.node.setButton(false);
                } else if (this.resetDown) {
                    int x = e.getX();
                    int y = e.getY();
                    this.resetDown = false;
                    if (x > 122 && x < 135 && y > 72 && y < 85) {
                        SkyGui.this.node.getCPU().reset();
                    }
                }
            }
        };
        this.addMouseListener(mouseHandler);
        MSP430 cpu = this.node.getCPU();
        IOUnit usart = cpu.getIOUnit("USART 1");
        if (usart instanceof USART) {
            this.serial = new SerialMon((USART)usart, "USART1 Port Output");
            ((USART)usart).setUSARTListener(this.serial);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Color old = g.getColor();
        ImageIcon skyImage = this.getNodeImage();
        int w = this.getWidth();
        int h = this.getHeight();
        int iw = skyImage.getIconWidth();
        int ih = skyImage.getIconHeight();
        skyImage.paintIcon(this, g, 0, 0);
        g.setColor(this.getBackground());
        if (w > iw) {
            g.fillRect(iw, 0, w, h);
        }
        if (h > ih) {
            g.fillRect(0, ih, w, h);
        }
        if (this.node.redLed) {
            g.setColor(RED_TRANS);
            g.fillOval(8, 33, 9, 5);
            g.setColor(RED_C);
            g.fillOval(10, 34, 4, 3);
        }
        if (this.node.greenLed) {
            g.setColor(GREEN_TRANS);
            g.fillOval(8, 39, 9, 5);
            g.setColor(GREEN_C);
            g.fillOval(10, 40, 4, 3);
        }
        if (this.node.blueLed) {
            g.setColor(BLUE_TRANS);
            g.fillOval(8, 45, 9, 5);
            g.setColor(BLUE_C);
            g.fillOval(10, 46, 4, 3);
        }
        g.setColor(old);
    }

    @Override
    protected void stopGUI() {
    }
}

