/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.platform.sky;

import se.sics.mspsim.chip.CC2420;
import se.sics.mspsim.chip.PacketListener;
import se.sics.mspsim.chip.RFListener;

public class RadioWrapper
implements RFListener {
    private CC2420 radio;
    private PacketListener listener;
    int len = 0;
    int pos = 0;
    byte[] buffer = new byte[128];

    public RadioWrapper(CC2420 radio) {
        this.radio = radio;
        radio.setRFListener(this);
    }

    public void setPacketListener(PacketListener list) {
        this.listener = list;
    }

    public void packetReceived(byte[] receivedData) {
        this.radio.receivedByte((byte)0);
        this.radio.receivedByte((byte)0);
        this.radio.receivedByte((byte)0);
        this.radio.receivedByte((byte)0);
        this.radio.receivedByte((byte)122);
        for (int i = 0; i < receivedData.length; ++i) {
            this.radio.receivedByte(receivedData[i]);
        }
    }

    @Override
    public void receivedByte(byte data) {
        if (this.pos == 5) {
            this.len = data;
        }
        if (this.pos == 0) {
            this.listener.transmissionStarted();
        }
        this.buffer[this.pos++] = data;
        if (this.len > 0 && this.len + 1 == this.pos - 5) {
            byte[] packet = new byte[this.len + 1];
            System.arraycopy(this.buffer, 5, packet, 0, this.len + 1);
            this.listener.transmissionEnded(packet);
            this.pos = 0;
            this.len = 0;
        }
    }
}

