/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.platform.sky;

import se.sics.mspsim.chip.CC2420;
import se.sics.mspsim.chip.DS2411;
import se.sics.mspsim.chip.PacketListener;
import se.sics.mspsim.chip.SHT11;
import se.sics.mspsim.core.IOPort;
import se.sics.mspsim.core.IOUnit;
import se.sics.mspsim.core.PortListener;
import se.sics.mspsim.core.USART;
import se.sics.mspsim.core.USARTListener;
import se.sics.mspsim.extutil.jfreechart.DataChart;
import se.sics.mspsim.extutil.jfreechart.DataSourceSampler;
import se.sics.mspsim.platform.GenericNode;
import se.sics.mspsim.platform.sky.RadioWrapper;
import se.sics.mspsim.platform.sky.SkyGui;
import se.sics.mspsim.util.ELF;
import se.sics.mspsim.util.NetworkConnection;

public abstract class MoteIVNode
extends GenericNode
implements PortListener,
USARTListener {
    public static final int MODE_LEDS_OFF = 0;
    public static final int MODE_LEDS_1 = 1;
    public static final int MODE_LEDS_2 = 2;
    public static final int MODE_LEDS_3 = 3;
    public static final int MODE_MAX = 3;
    public static final int DS2411_DATA_PIN = 4;
    public static final int DS2411_DATA = 16;
    public static final int BUTTON_PIN = 7;
    public static final int CC2420_FIFOP = 0;
    public static final int CC2420_FIFO = 3;
    public static final int CC2420_CCA = 4;
    public static final int SHT11_CLK_PIN = 6;
    public static final int SHT11_DATA_PIN = 5;
    public static final int SHT11_CLK = 64;
    public static final int SHT11_DATA = 32;
    public static final int CC2420_SFD = 1;
    public static final int CC2420_VREG = 32;
    public static final int CC2420_CHIP_SELECT = 4;
    public static final int BLUE_LED = 64;
    public static final int GREEN_LED = 32;
    public static final int RED_LED = 16;
    public boolean redLed;
    public boolean blueLed;
    public boolean greenLed;
    protected IOPort port1;
    protected IOPort port2;
    protected IOPort port4;
    protected IOPort port5;
    public CC2420 radio;
    public SHT11 sht11;
    public DS2411 ds2411;
    public SkyGui gui;
    public NetworkConnection network;
    protected String flashFile;

    public void setDebug(boolean debug) {
        this.cpu.setDebug(debug);
    }

    public void setButton(boolean hi) {
        this.port2.setPinState(7, hi ? 1 : 0);
    }

    public boolean getDebug() {
        return this.cpu.getDebug();
    }

    public ELF getElfInfo() {
        return this.elf;
    }

    public void setNodeID(int id) {
        this.ds2411.setMACID(id & 0xFF, id & 0xFF, id & 0xFF, id >> 8 & 0xFF, id & 0xFF, id & 0xFF);
    }

    public void setupNodePorts() {
        IOUnit usart0;
        this.sht11 = new SHT11(this.cpu);
        this.ds2411 = new DS2411(this.cpu);
        IOUnit unit = this.cpu.getIOUnit("Port 5");
        if (unit instanceof IOPort) {
            this.port5 = (IOPort)unit;
            this.port5.setPortListener(this);
        }
        if ((unit = this.cpu.getIOUnit("Port 1")) instanceof IOPort) {
            this.port1 = (IOPort)unit;
            this.port1.setPortListener(this);
            this.sht11.setDataPort(this.port1, 5);
        }
        if ((unit = this.cpu.getIOUnit("Port 2")) instanceof IOPort) {
            this.port2 = (IOPort)unit;
            this.ds2411.setDataPort(this.port2, 4);
            this.port2.setPortListener(this);
        }
        if ((usart0 = this.cpu.getIOUnit("USART 0")) instanceof USART) {
            this.radio = new CC2420(this.cpu);
            this.radio.setCCAPort(this.port1, 4);
            this.radio.setFIFOPPort(this.port1, 0);
            this.radio.setFIFOPort(this.port1, 3);
            ((USART)usart0).setUSARTListener(this);
            this.port4 = (IOPort)this.cpu.getIOUnit("Port 4");
            if (this.port4 != null) {
                this.port4.setPortListener(this);
                this.radio.setSFDPort(this.port4, 1);
            }
        }
    }

    @Override
    public void setupNode() {
        String fileName = this.config.getProperty("flashfile");
        if (fileName == null && (fileName = this.firmwareFile) != null) {
            int ix = fileName.lastIndexOf(46);
            if (ix > 0) {
                fileName = fileName.substring(0, ix);
            }
            fileName = fileName + ".flash";
        }
        if (this.DEBUG) {
            System.out.println("Using flash file: " + (fileName == null ? "no file" : fileName));
        }
        this.flashFile = fileName;
        this.setupNodePorts();
        this.stats.addMonitor(this);
        this.stats.addMonitor(this.radio);
        this.stats.addMonitor(this.cpu);
        if (this.config.getPropertyAsBoolean("enableNetwork", false)) {
            this.network = new NetworkConnection();
            final RadioWrapper radioWrapper = new RadioWrapper(this.radio);
            radioWrapper.setPacketListener(new PacketListener(){

                @Override
                public void transmissionStarted() {
                }

                @Override
                public void transmissionEnded(byte[] receivedData) {
                    MoteIVNode.this.network.dataSent(receivedData);
                }
            });
            this.network.addPacketListener(new PacketListener(){

                @Override
                public void transmissionStarted() {
                }

                @Override
                public void transmissionEnded(byte[] receivedData) {
                    radioWrapper.packetReceived(receivedData);
                }
            });
        }
        if (!this.config.getPropertyAsBoolean("nogui", true)) {
            this.gui = new SkyGui(this);
            this.registry.registerComponent("nodegui", this.gui);
            DataChart dataChart = new DataChart(this.registry, "Duty Cycle", "Duty Cycle");
            this.registry.registerComponent("dutychart", dataChart);
            DataSourceSampler dss = dataChart.setupChipFrame(this.cpu);
            dataChart.addDataSource(dss, "LEDS", this.stats.getDataSource(this.getName(), 0, 1));
            dataChart.addDataSource(dss, "Listen", this.stats.getDataSource("CC2420", 1));
            dataChart.addDataSource(dss, "Transmit", this.stats.getDataSource("CC2420", 2));
            dataChart.addDataSource(dss, "CPU", this.stats.getDataSource("MSP430 Core", 0));
        }
    }

    @Override
    public void portWrite(IOPort source, int data) {
        if (source == this.port5) {
            this.redLed = (data & 0x10) == 0;
            this.blueLed = (data & 0x40) == 0;
            this.greenLed = (data & 0x20) == 0;
            int newMode = (this.redLed ? 1 : 0) + (this.greenLed ? 1 : 0) + (this.blueLed ? 1 : 0);
            this.setMode(newMode);
            if (this.gui != null) {
                this.gui.repaint();
            }
        } else if (source == this.port4) {
            this.radio.setChipSelect((data & 4) == 0);
            this.radio.setVRegOn((data & 0x20) != 0);
            this.flashWrite(source, data);
        } else if (source == this.port1) {
            this.sht11.clockPin((data & 0x40) != 0);
            this.sht11.dataPin((data & 0x20) != 0);
        } else if (source == this.port2) {
            this.ds2411.dataPin((data & 0x10) != 0);
        }
    }

    @Override
    public int getModeMax() {
        return 3;
    }

    protected abstract void flashWrite(IOPort var1, int var2);
}

