/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.platform.esb;

import java.io.IOException;
import se.sics.mspsim.chip.TR1001;
import se.sics.mspsim.core.IOPort;
import se.sics.mspsim.core.IOUnit;
import se.sics.mspsim.core.PortListener;
import se.sics.mspsim.core.USART;
import se.sics.mspsim.extutil.jfreechart.DataChart;
import se.sics.mspsim.extutil.jfreechart.DataSourceSampler;
import se.sics.mspsim.platform.GenericNode;
import se.sics.mspsim.platform.esb.ESBGui;
import se.sics.mspsim.util.ArgumentManager;

public class ESBNode
extends GenericNode
implements PortListener {
    public static final boolean DEBUG = false;
    public static final int PIR_PIN = 3;
    public static final int VIB_PIN = 4;
    public static final int BUTTON_PIN = 7;
    private IOPort port1;
    private IOPort port2;
    private IOPort port5;
    public static final int RED_LED = 1;
    public static final int GREEN_LED = 2;
    public static final int YELLOW_LED = 4;
    public static final int BEEPER = 8;
    public boolean redLed;
    public boolean greenLed;
    public boolean yellowLed;
    private TR1001 radio;
    private ESBGui gui;

    public void setPIR(boolean hi) {
        this.port1.setPinState(3, hi ? 1 : 0);
    }

    public void setVIB(boolean hi) {
        this.port1.setPinState(4, hi ? 1 : 0);
    }

    public void setButton(boolean hi) {
        this.port2.setPinState(7, hi ? 1 : 0);
    }

    public boolean getDebug() {
        return this.cpu.getDebug();
    }

    public void setDebug(boolean debug) {
        this.cpu.setDebug(debug);
    }

    @Override
    public void portWrite(IOPort source, int data) {
        if (source == this.port2) {
            this.redLed = (data & 1) == 0;
            this.greenLed = (data & 2) == 0;
            boolean bl = this.yellowLed = (data & 4) == 0;
            if (this.gui != null) {
                this.gui.ledsChanged();
                this.gui.beeper.beepOn((data & 8) != 0);
            }
        } else if (source == this.port5) {
            if ((data & 0xC0) == 192) {
                this.radio.setMode(1);
            } else if ((data & 0xC0) == 64) {
                this.radio.setMode(2);
            } else {
                this.radio.setMode(0);
            }
        }
    }

    public void setupNodePorts() {
        IOUnit usart0;
        IOUnit unit = this.cpu.getIOUnit("Port 2");
        if (unit instanceof IOPort) {
            this.port2 = (IOPort)unit;
            this.port2.setPortListener(this);
        }
        if ((unit = this.cpu.getIOUnit("Port 1")) instanceof IOPort) {
            this.port1 = (IOPort)unit;
        }
        if ((unit = this.cpu.getIOUnit("Port 5")) instanceof IOPort) {
            this.port5 = (IOPort)unit;
            this.port5.setPortListener(this);
        }
        if ((usart0 = this.cpu.getIOUnit("USART 0")) instanceof USART) {
            this.radio = new TR1001((USART)usart0);
            ((USART)usart0).setUSARTListener(this.radio);
        }
    }

    @Override
    public void setupNode() {
        this.setupNodePorts();
        this.stats.addMonitor(this);
        this.stats.addMonitor(this.radio);
        this.stats.addMonitor(this.cpu);
        if (!this.config.getPropertyAsBoolean("nogui", true)) {
            this.gui = new ESBGui(this);
            this.registry.registerComponent("nodegui", this.gui);
            DataChart dataChart = new DataChart(this.registry, "Duty Cycle", "Duty Cycle");
            this.registry.registerComponent("dutychart", dataChart);
            DataSourceSampler dss = dataChart.setupChipFrame(this.cpu);
            dataChart.addDataSource(dss, "LEDS", this.stats.getDataSource(this.getName(), 0, 1));
            dataChart.addDataSource(dss, "Listen", this.stats.getDataSource("TR1001", 1));
            dataChart.addDataSource(dss, "Transmit", this.stats.getDataSource("TR1001", 2));
            dataChart.addDataSource(dss, "CPU", this.stats.getDataSource("MSP430 Core", 0));
        }
    }

    @Override
    public int getModeMax() {
        return 0;
    }

    @Override
    public String getName() {
        return "ESB";
    }

    public static void main(String[] args) throws IOException {
        ESBNode node = new ESBNode();
        ArgumentManager config = new ArgumentManager();
        config.handleArguments(args);
        node.setupArgs(config);
    }
}

