/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.platform.esb;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;
import javax.swing.ImageIcon;
import se.sics.mspsim.chip.Beeper;
import se.sics.mspsim.core.ADC12;
import se.sics.mspsim.core.ADCInput;
import se.sics.mspsim.core.IOUnit;
import se.sics.mspsim.core.MSP430;
import se.sics.mspsim.core.USART;
import se.sics.mspsim.platform.AbstractNodeGUI;
import se.sics.mspsim.platform.esb.ESBNode;
import se.sics.mspsim.ui.SerialMon;

public class ESBGui
extends AbstractNodeGUI
implements ADCInput {
    private static final long serialVersionUID = -139331418649524704L;
    public static final int GREEN_X = 2;
    public static final int YELLOW_X = 9;
    public static final int RED_X = 16;
    public static final int LED_Y = 4;
    private static final Rectangle LED_BOUNDS = new Rectangle(0, 0, 22, 14);
    public static final Color RED_TRANS = new Color(255, 64, 64, 160);
    public static final Color YELLOW_TRANS = new Color(255, 255, 0, 160);
    public static final Color GREEN_TRANS = new Color(64, 240, 64, 160);
    public static final Color RED_C = new Color(-40864);
    public static final Color YELLOW_C = new Color(-256);
    public static final Color GREEN_C = new Color(-12517568);
    private static final float SAMPLE_RATE = 22050.0f;
    private static final int DL_BUFFER_SIZE = 2200;
    private MouseMotionAdapter mouseMotionListener;
    private MouseAdapter mouseListener;
    private SerialMon serial;
    Beeper beeper;
    private ESBNode node;
    private boolean buttonDown = false;
    private boolean resetDown = false;
    private TargetDataLine inDataLine;
    private byte[] data = new byte[4];

    public ESBGui(ESBNode esbNode) {
        super("ESBGui", "images/esb.jpg");
        this.node = esbNode;
    }

    @Override
    protected void startGUI() {
        IOUnit adc;
        this.mouseMotionListener = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                ESBGui.this.node.setPIR(x > 18 && x < 80 && y > 35 && y < 100);
                ESBGui.this.node.setVIB(x > 62 && x < 95 && y > 160 && y < 178);
            }
        };
        this.addMouseMotionListener(this.mouseMotionListener);
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    int x = e.getX();
                    int y = e.getY();
                    if (y > 152 && y < 168) {
                        if (x > 0 && x < 19) {
                            ESBGui.this.buttonDown = true;
                            ESBGui.this.node.setButton(true);
                        } else {
                            int w = ESBGui.this.getNodeImage().getIconWidth();
                            if (x > w - 20 && x < w) {
                                ESBGui.this.resetDown = true;
                            }
                        }
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 1) {
                    if (ESBGui.this.buttonDown) {
                        ESBGui.this.buttonDown = false;
                        ESBGui.this.node.setButton(false);
                    } else if (ESBGui.this.resetDown) {
                        int w;
                        int x = e.getX();
                        int y = e.getY();
                        if (y > 152 && y < 168 && x > (w = ESBGui.this.getNodeImage().getIconWidth()) - 20 && x < w) {
                            ESBGui.this.node.getCPU().reset();
                        }
                        ESBGui.this.resetDown = false;
                    }
                }
            }
        };
        this.addMouseListener(this.mouseListener);
        MSP430 cpu = this.node.getCPU();
        IOUnit usart = cpu.getIOUnit("USART 1");
        if (usart instanceof USART) {
            if (this.serial == null) {
                this.serial = new SerialMon((USART)usart, "RS232 Port Output");
            }
            ((USART)usart).setUSARTListener(this.serial);
        }
        if ((adc = cpu.getIOUnit("ADC12")) instanceof ADC12) {
            ((ADC12)adc).setADCInput(0, this);
        }
        this.beeper = new Beeper();
        try {
            AudioFormat af = new AudioFormat(22050.0f, 16, 1, true, false);
            DataLine.Info dlin = new DataLine.Info(TargetDataLine.class, af, 2200);
            this.inDataLine = (TargetDataLine)AudioSystem.getLine(dlin);
            if (this.inDataLine == null) {
                System.out.println("No input dataline");
            } else {
                System.out.println("Format: " + this.inDataLine.getFormat());
                this.inDataLine.open(this.inDataLine.getFormat(), 2200);
                this.inDataLine.start();
            }
        }
        catch (Exception e) {
            System.err.println("Failed to get audio data line: " + e.getMessage());
        }
    }

    @Override
    protected void stopGUI() {
        this.removeMouseMotionListener(this.mouseMotionListener);
        this.removeMouseListener(this.mouseListener);
    }

    public void ledsChanged() {
        this.repaint(LED_BOUNDS);
    }

    @Override
    public int nextData() {
        if (this.inDataLine != null) {
            this.inDataLine.read(this.data, 0, 4);
        }
        return ((this.data[1] & 0xFF) << 8 | this.data[0] & 0xFF) >> 4;
    }

    @Override
    protected void paintComponent(Graphics g) {
        Color old = g.getColor();
        int w = this.getWidth();
        int h = this.getHeight();
        ImageIcon esbImage = this.getNodeImage();
        int iw = esbImage.getIconWidth();
        int ih = esbImage.getIconHeight();
        esbImage.paintIcon(this, g, 0, 0);
        g.setColor(this.getBackground());
        if (w > iw) {
            g.fillRect(iw, 0, w, h);
        }
        if (h > ih) {
            g.fillRect(0, ih, w, h);
        }
        if (this.node.greenLed) {
            g.setColor(GREEN_TRANS);
            g.fillOval(1, 1, 5, 9);
            g.setColor(GREEN_C);
            g.fillOval(2, 4, 3, 4);
        }
        if (this.node.redLed) {
            g.setColor(RED_TRANS);
            g.fillOval(15, 1, 5, 9);
            g.setColor(RED_C);
            g.fillOval(16, 4, 3, 4);
        }
        if (this.node.yellowLed) {
            g.setColor(YELLOW_TRANS);
            g.fillOval(8, 1, 5, 9);
            g.setColor(YELLOW_C);
            g.fillOval(9, 4, 3, 4);
        }
        g.setColor(old);
    }
}

