/*
 * Decompiled with CFR 0.152.
 */
package se.sics.mspsim.platform;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import se.sics.mspsim.cli.CommandHandler;
import se.sics.mspsim.cli.DebugCommands;
import se.sics.mspsim.cli.FileCommands;
import se.sics.mspsim.cli.MiscCommands;
import se.sics.mspsim.cli.NetCommands;
import se.sics.mspsim.cli.ProfilerCommands;
import se.sics.mspsim.cli.StreamCommandHandler;
import se.sics.mspsim.cli.WindowCommands;
import se.sics.mspsim.core.Chip;
import se.sics.mspsim.core.EmulationException;
import se.sics.mspsim.core.EmulationLogger;
import se.sics.mspsim.core.MSP430;
import se.sics.mspsim.extutil.highlight.HighlightSourceViewer;
import se.sics.mspsim.ui.ControlUI;
import se.sics.mspsim.ui.JFrameWindowManager;
import se.sics.mspsim.ui.StackUI;
import se.sics.mspsim.util.ArgumentManager;
import se.sics.mspsim.util.ComponentRegistry;
import se.sics.mspsim.util.ConfigManager;
import se.sics.mspsim.util.DefaultEmulationLogger;
import se.sics.mspsim.util.ELF;
import se.sics.mspsim.util.IHexReader;
import se.sics.mspsim.util.MapTable;
import se.sics.mspsim.util.OperatingModeStatistics;
import se.sics.mspsim.util.PluginRepository;
import se.sics.mspsim.util.StatCommands;

public abstract class GenericNode
extends Chip
implements Runnable {
    private static final String PROMPT = "MSPSim>";
    protected ConfigManager config;
    protected ComponentRegistry registry = new ComponentRegistry();
    protected MSP430 cpu = new MSP430(0, this.registry);
    protected String firmwareFile = null;
    protected ELF elf;
    protected OperatingModeStatistics stats;

    public ComponentRegistry getRegistry() {
        return this.registry;
    }

    public MSP430 getCPU() {
        return this.cpu;
    }

    public abstract void setupNode();

    public void setCommandHandler(CommandHandler handler) {
        this.registry.registerComponent("commandHandler", handler);
    }

    public void setupArgs(ArgumentManager config) throws IOException {
        File fp;
        String script;
        String[] args = config.getArguments();
        if (args.length == 0) {
            System.out.println("Usage: " + this.getClass().getName() + " <firmware>");
            System.exit(1);
        }
        this.firmwareFile = args[0];
        if (config.getProperty("nogui") == null) {
            config.setProperty("nogui", "false");
        }
        if (config.getProperty("autorun") == null) {
            File fp2 = new File("scripts/autorun.sc");
            if (fp2.exists()) {
                config.setProperty("autorun", "scripts/autorun.sc");
            } else {
                try {
                    File dir = new File(GenericNode.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile();
                    fp2 = new File(dir, "scripts/autorun.sc");
                    if (fp2.exists()) {
                        config.setProperty("autorun", fp2.getAbsolutePath());
                    }
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
            }
        }
        int[] memory = this.cpu.getMemory();
        if (args[0].endsWith("ihex")) {
            IHexReader reader = new IHexReader();
            reader.readFile(memory, this.firmwareFile);
        } else {
            this.loadFirmware(this.firmwareFile, memory);
        }
        if (args.length > 1) {
            MapTable map = new MapTable(args[1]);
            this.cpu.getDisAsm().setMap(map);
            this.registry.registerComponent("mapTable", map);
        }
        this.setup(config);
        if (!config.getPropertyAsBoolean("nogui", false)) {
            File fp3;
            ControlUI control = new ControlUI();
            this.registry.registerComponent("controlgui", control);
            this.registry.registerComponent("stackchart", new StackUI(this.cpu));
            HighlightSourceViewer sourceViewer = new HighlightSourceViewer();
            if (this.firmwareFile != null && (fp3 = new File(this.firmwareFile).getParentFile()) != null) {
                try {
                    fp3 = fp3.getCanonicalFile();
                }
                catch (Exception e) {
                    // empty catch block
                }
                sourceViewer.addSearchPath(fp3);
            }
            control.setSourceViewer(sourceViewer);
        }
        if ((script = config.getProperty("autorun")) != null && (fp = new File(script)).canRead()) {
            CommandHandler ch = (CommandHandler)this.registry.getComponent("commandHandler");
            script = script.replace('\\', '/');
            System.out.println("Autoloading script: " + script);
            config.setProperty("autoloadScript", script);
            if (ch != null) {
                ch.lineRead("source \"" + script + '\"');
            }
        }
        config.setProperty("firmwareFile", this.firmwareFile);
        System.out.println("-----------------------------------------------");
        System.out.println("MSPSim 0.97 starting firmware: " + this.firmwareFile);
        System.out.println("-----------------------------------------------");
        System.out.print(PROMPT);
        System.out.flush();
    }

    public void setup(ConfigManager config) throws IOException {
        this.config = config;
        EmulationLogger logger = (EmulationLogger)this.registry.getComponent("logger");
        if (logger == null) {
            logger = new DefaultEmulationLogger(this.cpu, System.out);
            this.registry.registerComponent("logger", logger);
        }
        this.registry.registerComponent("cpu", this.cpu);
        this.registry.registerComponent("node", this);
        this.registry.registerComponent("config", config);
        this.cpu.setEmulationLogger(logger);
        CommandHandler ch = (CommandHandler)this.registry.getComponent("commandHandler");
        if (ch == null) {
            ch = new StreamCommandHandler(System.in, System.out, System.err, PROMPT);
            this.registry.registerComponent("commandHandler", ch);
        }
        this.stats = new OperatingModeStatistics(this.cpu);
        this.registry.registerComponent("pluginRepository", new PluginRepository());
        this.registry.registerComponent("debugcmd", new DebugCommands());
        this.registry.registerComponent("misccmd", new MiscCommands());
        this.registry.registerComponent("filecmd", new FileCommands());
        this.registry.registerComponent("statcmd", new StatCommands(this.cpu, this.stats));
        this.registry.registerComponent("wincmd", new WindowCommands());
        this.registry.registerComponent("profilecmd", new ProfilerCommands());
        this.registry.registerComponent("netcmd", new NetCommands());
        this.registry.registerComponent("windowManager", new JFrameWindowManager());
        this.cpu.setMonitorExec(true);
        this.setupNode();
        this.registry.start();
        this.cpu.reset();
    }

    @Override
    public void run() {
        if (!this.cpu.isRunning()) {
            try {
                this.cpu.cpuloop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void start() {
        if (!this.cpu.isRunning()) {
            Thread thread = new Thread(this);
            thread.setPriority(5);
            thread.start();
        }
    }

    public void stop() {
        this.cpu.setRunning(false);
    }

    public void step() throws EmulationException {
        if (!this.cpu.isRunning()) {
            this.cpu.step();
        }
    }

    public ELF loadFirmware(URL url, int[] memory) throws IOException {
        int read;
        DataInputStream inputStream = new DataInputStream(url.openStream());
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        byte[] firmwareData = new byte[2048];
        while ((read = inputStream.read(firmwareData)) != -1) {
            byteStream.write(firmwareData, 0, read);
        }
        inputStream.close();
        ELF elf = new ELF(byteStream.toByteArray());
        elf.readAll();
        return this.loadFirmware(elf, memory);
    }

    public ELF loadFirmware(String name, int[] memory) throws IOException {
        this.firmwareFile = name;
        return this.loadFirmware(ELF.readELF(this.firmwareFile), memory);
    }

    public ELF loadFirmware(ELF elf, int[] memory) {
        this.stop();
        this.elf = elf;
        elf.loadPrograms(memory);
        MapTable map = elf.getMap();
        this.cpu.getDisAsm().setMap(map);
        this.cpu.setMap(map);
        this.registry.registerComponent("elf", elf);
        this.registry.registerComponent("mapTable", map);
        return elf;
    }

    public void step(int nr) throws EmulationException {
        if (!this.cpu.isRunning()) {
            this.cpu.stepInstructions(nr);
        }
    }
}

